<?php
$current_user = wp_get_current_user();
$user_id = $current_user->ID;
$first_name = get_user_meta($user_id, "first_name", true);
$last_name = get_user_meta($user_id, "last_name", true);
$user_email = $current_user->user_email;
$login_type = get_user_meta($user_id, "login_type", true);
?>
<!-- Account Settings -->
<div class="tabContentPlugin hidden space-y-5" id="accountSettings">
    <div class="space-y-3 md:space-y-0 flex flex-col md:flex-row justify-between items-center font-bold">
        <h2 class="text-lg lg:text-xl text-black !leading-[120%]">
            My account
        </h2>
        <a href="#" class="text-base text-[#EB4335] !leading-[160%] duration-300 hover:opacity-75" id="delete_account">
            Delete account
        </a>
    </div>

    <div class="">
        <form action="#" method="POST" class="space-y-3 text-black" id="login_signup_form">
            <input type="hidden" name="user_id" value="<?= $user_id ?>">
            <div class="relative">
                <label for="name" class="absolute top-2 left-3 text-[10px] !leading-[120%] font-normal">Complete
                    name</label>
                <input type="text" id="name" name="name" placeholder="" value="<?= $first_name . " " . $last_name ?>"
                    class="w-full px-3 pb-1.5 pt-5 text-base !leading-[160%] font-bold border border-[#F2F2F2] !outline-0 !focus:outline-0 !focus:ring-0 !focus:shadow-none rounded-md" />
            </div>

            <div class="relative noAutofillBg">
                <label for="name" class="absolute top-2 left-3 text-[10px] !leading-[120%] font-normal">Email
                    address</label>
                <input type="text" id="" name="" placeholder="" value="<?= $user_email ?>"
                    class="w-full px-3 pb-1.5 pt-5 text-base !leading-[160%] font-bold border border-[#F2F2F2] !outline-0 !focus:outline-0 !focus:ring-0 !focus:shadow-none rounded-md"
                    readonly />
            </div>

            <div class="relative noAutofillBg">
                <label for="name" class="absolute top-2 left-3 text-[10px] !leading-[120%] font-normal">Sign in
                    method</label>
                <input type="text" id="" name="" placeholder="" value="<?= $login_type ?>"
                    class="w-full px-3 pb-1.5 pt-5 text-base !leading-[160%] font-bold border border-[#F2F2F2] !outline-0 !focus:outline-0 !focus:ring-0 !focus:shadow-none rounded-md"
                    readonly />
            </div>

            <div class="relative noAutofillBg">
                <label for="name" class="absolute top-2 left-3 text-[10px] !leading-[120%] font-normal">Subscribe
                    to newsletter?</label>
                <input type="text" id="" placeholder="" value="Yes"
                    class="w-full px-3 pb-1.5 pt-5 text-base !leading-[160%] font-bold border border-[#F2F2F2] !outline-0 !focus:outline-0 !focus:ring-0 !focus:shadow-none rounded-md"
                    readonly />
                <div class="absolute top-1/2 -translate-y-1/2 right-3">
                    <label class="cursor-pointer">
                        <input type="checkbox" class="sr-only peer" name="subscribe_to_newslatter" <?php echo get_user_meta($user_id, 'subscribe_to_newslatter', true) ? "checked" : null ?> />
                        <div
                            class="w-12 h-7 bg-gray-300 rounded-full peer-checked:bg-[#1A2DC9] relative after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:w-6 after:h-6 after:bg-white after:rounded-full after:transition-all peer-checked:after:translate-x-5">
                        </div>
                    </label>
                </div>
            </div>

            <div class="pt-5">
                <button type="submit"
                    class="w-full md:w-auto py-3 lg:py-3.5 px-8 text-base !leading-[160%] font-bold text-white bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full duration-500 hover:opacity-85">
                    Save changes
                </button>
            </div>
        </form>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    jQuery(function ($) {
        $("#login_signup_form").on("submit", function (e) {
            e.preventDefault();


            /* ---------------------------
             * AJAX submit
             * --------------------------- */
            Swal.showLoading();

            const formData = $(this).serialize();

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>', // WordPress safe
                type: "POST",
                dataType: 'json',
                data: {
                    action: "save_user_settings",
                    formData: formData,
                },
                success: function (data) {

                    Swal.fire({
                        // position: 'top-end',
                        icon: 'success',
                        showConfirmButton: false,
                        timer: 2500
                    })
                }
            });

        });
    })

</script>