<?php

$rating = percent_to_rating($the_plugin_information->rating);
$plugin_ratings_json = $the_plugin_information->plugin_ratings_json;
$plugin_ratings_json_to_array = json_decode($plugin_ratings_json, true);
// dd($plugin_ratings_json_to_array);
// dd($plugin_ratings_json);
?>
<div class="tabContentPlugin hidden lg:pr-[30px] text-black/80 text-base font-normal leading-[160%] space-y-[60px] md:space-y-[80px] lg:space-y-[120px]"
    id="reviews">
    <div class="text-black space-y-6 lg:space-y-8">
        <h2 class="text-[22px] md:text-[25px] font-bold leading-[120%]">
            Ratings
        </h2>

        <div class="flex items-center space-x-3">
            <div class="flex items-center">
                <?php echo render_star_rating($rating) ?>
            </div>
            <p>
                <strong>
                    <?= $rating ?> out of 5 |
                    <span class="text-[#1C37D1]"><?= $the_plugin_information->num_ratings ?></span>
                </strong>
            </p>
        </div>

        <div class="space-y-3">
            <?php
            foreach (array_reverse($plugin_ratings_json_to_array, true) as $key => $single_review) {
                ?>
                <div class="w-full flex justify-between items-center space-x-3">
                    <strong class="w-20 min-w-20 whitespace-nowrap">
                        <?php echo $key ?> stars
                    </strong>
                    <div class="w-full h-2 sm:h-3 bg-[#EDEEF0] rounded-[30px] overflow-hidden">
                        <div class="h-2 sm:h-3 bg-[#1A2DC9] rounded-[30px]"
                            style="width: <?php echo $single_review > 0 ? (($single_review / $the_plugin_information->num_ratings) * 100) : 0 ?>%">
                        </div>
                    </div>
                    <strong class="text-[#1C37D1] w-12 min-w-12 text-end">
                        <?php echo $single_review ?>
                    </strong>
                </div>

                <?php
            }
            ?>
        </div>

        <div>
            <a href="#"
                class="group w-full sm:w-auto px-6 py-1.5 space-x-2.5 font-bold inline-flex justify-center sm:justify-normal items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                <span>Add Review</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="group-hover:fill-white"
                        d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                        fill="#1A2DC9" />
                </svg>
            </a>
        </div>
    </div>

    <?php
    $template = get_template_directory() . '/frontend/single-plugin-includes/review-tabs.php';

    if (file_exists($template)) {
        include $template;
    }


    ?>
</div>