<div class="space-y-[30px]">
    <div
        class="aspect-[1/0.4] sm:aspect-[1/0.306] xl:aspect-[1/0.323] rounded-[20px] md:rounded-[30px] overflow-hidden">
        <img class="w-full h-full object-cover object-center"
            src="<?php echo $the_plugin_information->plugin_feature_image ? $the_plugin_information->plugin_feature_image : $the_plugin_information->plugin_icon ?>"
            alt="banner plugin Image" />
    </div>

    <div class="flex flex-col lg:flex-row space-y-8 lg:space-y-0 lg:space-x-8">
        <div class="space-y-12 lg:space-y-[60px]">
            <div class="flex-1 flex space-x-3 sm:space-x-6">
                <div class="flex w-20 min-w-20 sm:w-28 sm:min-w-28 lg:w-[136px] lg:min-w-[136px]">
                    <div
                        class="flex justify-center items-center w-full h-20 sm:h-28 lg:h-[136px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl overflow-hidden">
                        <img class="w-[70px] min-w-[70px] sm:w-24 sm:min-w-24 lg:w-[123px] lg:min-w-[123px] h-[70px] sm:h-24 lg:h-[123px] object-contain object-center rounded-3xl"
                            src="<?php echo $the_plugin_information->plugin_icon ? $the_plugin_information->plugin_icon : $the_plugin_information->plugin_feature_image ?>"
                            alt="woo-image" />
                    </div>
                </div>

                <div class="space-y-3 text-[#000000]">
                    <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-[39px] font-bold leading-[120%]">
                        <?= $the_plugin_information->post_title ?>
                    </h1>
                    <p class="text-base font-normal leading-[160%]">
                        By
                        <span class="text-[#1A2DC9] font-bold"><a
                                href="<?php echo $the_plugin_information->author_profile ?>"><?php echo $the_plugin_information->author_name ?></a></span>
                    </p>
                </div>
            </div>

            <div class="space-y-12 lg:space-y-[60px]">
                <!-- Tabs -->
                <div class="sticky top-[72px] lg:top-[85px] bg-white z-[18px]">
                    <div
                        class="flex space-x-7 sm:space-x-12 md:space-x-[60px] text-base text-[#A1A7B1] font-normal leading-[160%] border-b border-[#F2F2F2] overflow-x-auto">
                        <button
                            class="tabBtnPlugin pb-3 border-b-4 border-[#1A2DC9] text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors duration-300"
                            data-tab="details">
                            Details
                        </button>
                        <button
                            class="tabBtnPlugin pb-3 border-b-4 border-transparent hover:text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors duration-300"
                            data-tab="reviews">
                            Reviews
                        </button>
                        <button
                            class="tabBtnPlugin pb-3 border-b-4 border-transparent hover:text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors duration-300"
                            data-tab="development">
                            Development
                        </button>
                        <button
                            class="tabBtnPlugin pb-3 border-b-4 border-transparent hover:text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors duration-300"
                            data-tab="support">
                            Support
                        </button>
                    </div>
                </div>

                <!-- Tab Contents -->
                <div class="">
                    <!-- Details -->
                    <div class="tabContentPlugin lg:pr-[30px] text-black/80 text-base font-normal leading-[160%] space-y-[60px] md:space-y-[80px] lg:space-y-[120px]"
                        id="details">
                        <div class="space-y-6 lg:space-y-8">
                            <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                Description
                            </h2>
                            <?php echo $the_plugin_information->post_long_descripton ?>
                        </div>
                        <?php
                        $post_meta_keywords_arr = [];
                        if (!empty($the_plugin_information->post_meta_keywords)) {
                            $post_meta_keywords_arr = explode(',', $the_plugin_information->post_meta_keywords);
                        }
                        ?>
                        <?php
                        if (!empty($post_meta_keywords_arr)) {
                        ?>
                            <div class="space-y-6 lg:space-y-8">
                                <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                    Other Notable Features
                                </h2>

                                <p>
                                    Here are a few other notable features of this free
                                    <?php echo $the_plugin_information->post_title ?> plugin.
                                </p>

                                <div class="-m-1">
                                    <div class="flex flex-wrap">
                                        <?php

                                        foreach ($post_meta_keywords_arr as $single) {
                                        ?>
                                            <div
                                                class="group w-[calc(100%-12px)] sm:w-[calc(50%-12px)] md:w-[calc(33.33333%-12px)] m-1 flex items-center py-2 px-3 lg:p-[15px] hover:text-white bg-white hover:bg-black duration-300 rounded-[12px] border border-[#F2F2F2] space-x-3">
                                                <div
                                                    class="w-[46px] min-w-[46px] h-[46px] lg:w-[54px] lg:min-w-[54px] lg:h-[54px] bg-[#02AAF23D] group-hover:bg-white flex justify-center items-center rounded-full">
                                                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                        src="<?php echo asset_image_path_generator() . 'plugin-page/check-fill.svg' ?>"
                                                        alt="check-fill" />
                                                </div>
                                                <span><?php echo $single ?></span>
                                            </div>
                                        <?php
                                        }
                                        ?>


                                    </div>
                                </div>
                            </div>
                        <?php
                        }

                        ?>

                        <?php
                        $plugin_screenshots = $the_plugin_information->plugin_screenshots;
                        if (!empty($plugin_screenshots)) {
                            $plugin_screenshots_arr = json_decode($plugin_screenshots, true);
                            //dd($plugin_screenshots_arr);
                        ?>
                            <div class="space-y-6 lg:space-y-8">
                                <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                    Screenshots
                                </h2>

                                <div class="p-4 sm:p-6 space-y-4 sm:space-y-6">
                                    <div class="relative overflow-hidden rounded-[30px] -z-10">
                                        <button id="prevBtn"
                                            class="flex justify-center items-center absolute top-1/2 left-3 sm:left-6 -translate-y-1/2 w-[42px] min-w-[42px] h-[42px] sm:w-[54px] sm:min-w-[54px] sm:h-[54px] bg-black rounded-full duration-300 hover:opacity-80 z-10">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                src="<?php echo asset_image_path_generator() . 'plugin-page/arrow-left-s-line.svg' ?>"
                                                alt="arrow-left" />
                                        </button>
                                        <button id="nextBtn"
                                            class="flex justify-center items-center absolute top-1/2 right-3 sm:right-6 -translate-y-1/2 w-[42px] min-w-[42px] h-[42px] sm:w-[54px] sm:min-w-[54px] sm:h-[54px] bg-black rounded-full duration-300 hover:opacity-80 z-10">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                src="<?php echo asset_image_path_generator() . 'plugin-page/arrow-right-s-line.svg' ?>"
                                                alt="arrow-right" />
                                        </button>
                                        <div id="sliderWrapperPlugin"
                                            class="aspect-[1/0.708] flex transition-transform duration-500 ease-in-out">
                                            <?php
                                            foreach ($plugin_screenshots_arr as $single) {
                                            ?>
                                                <img class="flex-shrink-0" src="<?php echo $single['src'] ?>"
                                                    alt="<?php echo $single_value['caption'] ?>" />
                                            <?php
                                            }
                                            ?>


                                        </div>
                                    </div>
                                    <!-- Dots -->
                                    <div id="dotsContainerPlugin" class="flex justify-center items-center space-x-1"></div>
                                </div>
                            </div>

                        <?php
                        }
                        ?>


                        <!-- <div class="space-y-6 lg:space-y-8">
                            <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                Blocks
                            </h2>

                            <p>This plugin provides 2 blocks.</p>

                            <div class="-m-1">
                                <div class="flex flex-wrap">
                                    <div
                                        class="group w-[calc(100%-12px)] sm:w-[calc(50%-12px)] m-1 flex items-center py-2 px-3 lg:p-[15px] hover:text-white bg-white hover:bg-black duration-300 rounded-[12px] border border-[#F2F2F2] space-x-3">
                                        <div
                                            class="w-[46px] min-w-[46px] h-[46px] lg:w-[54px] lg:min-w-[54px] lg:h-[54px] bg-[#02AAF23D] group-hover:bg-white flex justify-center items-center rounded-full">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                src="assets/images/plugin-page/check-fill.svg" alt="check-fill" />
                                        </div>
                                        <span>Student Registration</span>
                                    </div>

                                    <div
                                        class="group w-[calc(100%-12px)] sm:w-[calc(50%-12px)] m-1 flex items-center py-2 px-3 lg:p-[15px] hover:text-white bg-white hover:bg-black duration-300 rounded-[12px] border border-[#F2F2F2] space-x-3">
                                        <div
                                            class="w-[46px] min-w-[46px] h-[46px] lg:w-[54px] lg:min-w-[54px] lg:h-[54px] bg-[#02AAF23D] group-hover:bg-white flex justify-center items-center rounded-full">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                src="assets/images/plugin-page/check-fill.svg" alt="check-fill" />
                                        </div>
                                        <span>Instructor Registration</span>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                        <?php
                        if (!empty($plugin_faqs)) {
                        ?>
                            <div class="space-y-6 lg:space-y-8">
                                <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                    FAQ
                                </h2>

                                <div class="space-y-2 lg:space-y-3">
                                    <!-- FAQ Item -->
                                    <?php
                                    foreach ($plugin_faqs as $ky => $single_plugin) {
                                    ?>
                                        <div class="border border-[#EDEEF0] rounded-3xl overflow-hidden">
                                            <button
                                                class="py-4 lg:py-[19px] px-6 lg:px-8 faq-btn flex justify-between items-center w-full text-left font-medium">
                                                <strong><?php echo $single_plugin->question ?></strong>
                                                <span
                                                    class="icon text-2xl transform transition-transform duration-300 rotate-180 -z-10">+</span>
                                            </button>
                                            <div
                                                class="py-4 lg:py-6 px-6 lg:px-8 faq-content border-t border-[#EDEEF0] <?php echo $ky > 0 ? "hidden" : null ?>">
                                                <?php echo $single_plugin->answer ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                        ?>


                        <div class="space-y-6 lg:space-y-8">
                            <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
                                Contributors and developers
                            </h2>

                            <p>
                                “<?php echo $the_plugin_information->post_title ?>”
                                is open source software. The following people have
                                contributed to this plugin.
                            </p>
                            <div class="-m-1">
                                <div class="flex flex-wrap">
                                    <?php
                                    foreach ($plugin_contributors as $single) {
                                    ?>
                                        <a href="<?php echo $single->profile_url ?>"
                                            class="flex space-x-4 duration-300 hover:opacity-80 w-[calc(100%-20px)] sm:w-[calc(50%-20px)] m-1">
                                            <div class="flex w-[60px] min-w-[60px]">
                                                <div
                                                    class="flex justify-center items-center w-full h-[60px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl overflow-hidden">
                                                    <img class="w-[54px] min-w-[54px] h-[54px] object-contain object-center rounded-3xl"
                                                        src="<?php echo $single->profile_image ?>" alt="woo-image" />
                                                </div>
                                            </div>

                                            <div class="flex items-center space-x-2.5 text-[#000000]">
                                                <strong><?php echo $single->name ?></strong>
                                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M6.66667 4V5.33333H3.33333V12.6667H10.6667V9.33333H12V13.3333C12 13.7015 11.7015 14 11.3333 14H2.66667C2.29848 14 2 13.7015 2 13.3333V4.66667C2 4.29848 2.29848 4 2.66667 4H6.66667ZM14 2V7.33333H12.6667L12.6666 4.27533L7.4714 9.4714L6.52859 8.5286L11.7233 3.33333H8.66667V2H14Z"
                                                        fill="#1A2DC9" />
                                                </svg>
                                            </div>
                                        </a>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Reviews -->
                    <?php
                    $template = get_template_directory() . '/frontend/single-plugin-includes/reviews-part.php';

                    if (file_exists($template)) {
                        include $template;
                    }


                    ?>

                    <!-- Development -->
                    <?php
                    $template = get_template_directory() . '/frontend/single-plugin-includes/development-tab.php';
                    if (file_exists($template)) {
                        include $template;
                    }


                    ?>


                    <!-- Support -->
                    <div class="tabContentPlugin hidden bg-slate-200 p-12" id="support">
                        <p class="text-3xl">Upcoming Soon</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="relative">
            <div class="sticky top-[85px] z-20">
                <div class="w-full lg:w-[306px] lg:min-w-[306px] space-y-[26px]">
                    <!-- Video Thumbnail -->
                    <a href="#" id="videoTrigger" class="group relative inline-block">
                        <div class="aspect-[1/0.476] lg:aspect-[1/0.576] rounded-[30px] overflow-hidden">
                            <img class="w-full h-full object-cover object-center"
                                src="<?php echo $the_plugin_information->plugin_feature_image ? $the_plugin_information->plugin_feature_image : $the_plugin_information->plugin_icon ?>"
                                alt="video Image" />
                        </div>
                        <div class="absolute inset-0 bg-black/20 duration-300 group-hover:bg-black/30 rounded-[30px]">
                        </div>
                        <div
                            class="flex justify-center items-center w-[72px] min-w-[72px] h-[72px] absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-[#E3E5E7] hover:bg-[#d4d7da] duration-300 rounded-full">
                            <img class="w-8 min-w-8 h-8 object-contain object-center"
                                src="<?php echo asset_image_path_generator() . 'plugin-page/play-fill.svg' ?>"
                                alt="play-fill" />
                        </div>
                    </a>

                    <!-- Video Modal -->
                    <div class="">
                        <div id="videoModal"
                            class="fixed inset-0 bg-black/80 flex justify-center items-center z-50 hidden">
                            <div class="relative w-full max-w-3xl aspect-video rounded-2xl overflow-hidden">
                                <!-- YouTube video or local video -->
                                <iframe id="videoFrame" class="w-full h-full" src="" title="Video Player"
                                    frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

                                <!-- Close Button -->
                                <button id="closeModal" class="absolute -top-10 right-0 text-white text-3xl font-bold">
                                    ✕
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="-m-1">
                        <div class="flex flex-wrap justify-center">
                            <a href="<?= $the_plugin_information->plugin_pro_version_link ? $the_plugin_information->plugin_pro_version_link : "#" ?>"
                                class="w-[calc(50%-10px)] m-1 flex justify-center items-center py-[6.3px] px-1 text-base font-bold leading-[160%] text-white bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 hover:opacity-80 space-x-2.5 rounded-full border border-[#1B3CD2]">
                                <span>Pro version</span>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.66667 4V5.33333H3.33333V12.6667H10.6667V9.33333H12V13.3333C12 13.7015 11.7015 14 11.3333 14H2.66667C2.29848 14 2 13.7015 2 13.3333V4.66667C2 4.29848 2.29848 4 2.66667 4H6.66667ZM14 2V7.33333H12.6667L12.6666 4.27533L7.4714 9.4714L6.52859 8.5286L11.7233 3.33333H8.66667V2H14Z"
                                        fill="white" />
                                </svg>
                            </a>

                            <a href="<?= $the_plugin_information->download_link ? $the_plugin_information->download_link : "#" ?>"
                                class="group w-[calc(50%-10px)] m-1 flex justify-center items-center py-[6.3px] px-1 text-base font-bold leading-[160%] text-[#1A2DC9] bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 space-x-2.5 rounded-full border border-[#1B3CD2]">
                                <span class="group-hover:text-white duration-300">
                                    Free Version
                                </span>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path class="group-hover:fill-white duration-300"
                                        d="M8.66634 6.66667H11.9997L7.99967 10.6667L3.99967 6.66667H7.33301V2H8.66634V6.66667ZM2.66634 12.6667H13.333V8H14.6663V13.3333C14.6663 13.7015 14.3679 14 13.9997 14H1.99967C1.63149 14 1.33301 13.7015 1.33301 13.3333V8H2.66634V12.6667Z"
                                        fill="#1A2DC9" />
                                </svg>
                            </a>

                            <a href="<?= $the_plugin_information->plugin_docs_link ? $the_plugin_information->plugin_docs_link : "#" ?>"
                                class="group w-[calc(50%-10px)] m-1 flex justify-center items-center py-[6.3px] px-1 text-base font-bold leading-[160%] text-[#1A2DC9] bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 space-x-2.5 rounded-full border border-[#1B3CD2]">
                                <span class="group-hover:text-white duration-300">
                                    Docs
                                </span>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path class="group-hover:fill-white duration-300"
                                        d="M8.66634 6.66667H11.9997L7.99967 10.6667L3.99967 6.66667H7.33301V2H8.66634V6.66667ZM2.66634 12.6667H13.333V8H14.6663V13.3333C14.6663 13.7015 14.3679 14 13.9997 14H1.99967C1.63149 14 1.33301 13.7015 1.33301 13.3333V8H2.66634V12.6667Z"
                                        fill="#1A2DC9" />
                                </svg>
                            </a>

                            <a href="<?= $the_plugin_information->plugin_live_demo_link ? $the_plugin_information->plugin_live_demo_link : "#" ?>"
                                class="group w-[calc(50%-10px)] m-1 flex justify-center items-center py-[6.3px] px-1 text-base font-bold leading-[160%] text-[#1A2DC9] bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 space-x-2.5 rounded-full border border-[#1B3CD2]">
                                <span class="group-hover:text-white duration-300">
                                    Live Demo
                                </span>
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path class="group-hover:fill-white duration-300"
                                        d="M8.66634 6.66667H11.9997L7.99967 10.6667L3.99967 6.66667H7.33301V2H8.66634V6.66667ZM2.66634 12.6667H13.333V8H14.6663V13.3333C14.6663 13.7015 14.3679 14 13.9997 14H1.99967C1.63149 14 1.33301 13.7015 1.33301 13.3333V8H2.66634V12.6667Z"
                                        fill="#1A2DC9" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>