<div class="tabContentPlugin hidden lg:pr-[30px] text-black/80 text-base font-normal leading-[160%] space-y-[60px] md:space-y-[80px] lg:space-y-[120px]"
    id="development">
    <div class="space-y-6 lg:space-y-8">
        <h2 class="text-black text-[22px] md:text-[25px] font-bold leading-[120%]">
            Contributors & Developers
        </h2>

        <?php
        echo $the_plugin_information->plugin_developememt_with_changelog;

        ?>
    </div>
    <?php
    if (!empty($the_plugin_information->plugin_changelog)) {
        $change_log = json_decode($the_plugin_information->plugin_changelog, true);
    ?>
        <div class="text-black space-y-8 lg:space-y-[45px]">
            <h2 class="text-[22px] md:text-[25px] font-bold leading-[120%]">
                Changelog
            </h2>

            <div class="space-y-6 lg:space-y-8">
                <?php
                $change_log_first_three = array_slice($change_log, 0, 3, true);
                foreach ($change_log_first_three as $single => $value) {
                ?>
                    <div class="p-4 lg:p-6 border border-[#F2F2F2] rounded-[30px] space-y-6">
                        <!-- Title -->
                        <div class="flex space-x-3">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?php echo asset_image_path_generator() ?>'calendar-todo-line.svg'?>"
                                alt="calendar-todo" />
                            <strong><?php echo $value["version"] ?> – <?php echo $value["date"] ?></strong>
                        </div>

                        <!-- Timeline Items -->
                        <div class="space-y-6 relative -z-10">
                            <?php
                            foreach ($value['changes'] as $single_change => $value_change) {
                                if (!empty($value_change["label"])) {
                                    // ✅ If label already exists, just use it
                                    $change_label = $value_change["label"];
                                    $change_value = $value_change["value"] ?? '';
                                } else {
                                    // ✅ Otherwise, try to parse the value
                                    $filter_data = !empty($value_change["value"]) ? explode(':', $value_change["value"], 2) : null;

                                    if (!empty($filter_data) && isset($filter_data[1])) {
                                        $first_word = trim($filter_data[0]);
                                        $keywords = ['New', 'Fixed', 'Fix', 'Changed', 'Change', 'Tweak', 'Update', 'Updated'];

                                        if (in_array($first_word, $keywords, true)) {
                                            $change_label = $first_word;
                                            $change_value = trim($filter_data[1]);
                                        } else {
                                            $change_label = trim($filter_data[0]);
                                            $change_value = trim($filter_data[1]);
                                        }
                                    } else {
                                        // Fallback — if no colon found
                                        $change_label = '';
                                        $change_value = $value_change["value"] ?? '';
                                    }
                                }
                            ?>
                                <!-- Item 1 -->
                                <div class="flex justify-between space-x-2.5 relative group">
                                    <div class="flex space-x-2.5 relative">
                                        <!-- Icon + Vertical Line -->
                                        <div class="relative flex flex-col items-center">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center z-10 bg-white"
                                                src="<?php echo asset_image_path_generator() . 'checkbox-circle-fill1.svg' ?>"
                                                alt="checkbox-circle" />
                                            <span
                                                class="absolute top-6 left-1/2 -translate-x-1/2 h-full border-l border-[#EDEEF0] border-dashed group-last:hidden"></span>
                                        </div>
                                        <p>
                                            <?php echo $change_value ?>
                                        </p>
                                    </div>
                                    <button class="font-bold text-[#111]">
                                        <?php echo $change_label ?>
                                    </button>
                                </div>

                            <?php
                            }

                            ?>



                        </div>
                    </div>

                <?php
                }
                ?>
            </div>

            <div>
                <a target="_blank"
                    href="https://wordpress.org/plugins/<?php echo $the_plugin_information->slug ?>/#developers<?php ?>"
                    class="group px-6 py-1.5 space-x-2.5 font-bold inline-flex items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                    <span>View the Full Changelog</span>
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path class="group-hover:fill-white"
                            d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                            fill="#1A2DC9" />
                    </svg>
                </a>
            </div>
        </div>
    <?php
    }
    ?>
    <?php
    if (!empty($the_plugin_information->version_json_link)) {
        $all_version_json_link = json_decode($the_plugin_information->version_json_link, true);
        //dd($all_version_json_link);
        $all_version_json_link = array_reverse($all_version_json_link);
    ?>
        <div class="text-black space-y-8 lg:space-y-[45px]">
            <h2 class="text-[22px] md:text-[25px] font-bold leading-[120%]">
                All Versions
            </h2>

            <div class="grid grid-cols-2 sm:grid-cols-4 md:grid-cols-5 lg:grid-cols-4 2xl:grid-cols-5 gap-2 sm:gap-3">
                <?php

                foreach ($all_version_json_link as $single => $value) {
                ?>

                    <a href="<?php echo $value ?>"
                        class="w-full flex duration-300 hover:opacity-65">

                        <div class="w-full px-2 py-2 flex items-center justify-center space-x-2.5 text-[#000000] duration-300 rounded-lg border border-[#1B3CD2]">
                            <strong class="break-all line-clamp-1"><?php echo $single ?></strong>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white duration-300"
                                    d="M8.66634 6.66667H11.9997L7.99967 10.6667L3.99967 6.66667H7.33301V2H8.66634V6.66667ZM2.66634 12.6667H13.333V8H14.6663V13.3333C14.6663 13.7015 14.3679 14 13.9997 14H1.99967C1.63149 14 1.33301 13.7015 1.33301 13.3333V8H2.66634V12.6667Z"
                                    fill="#1A2DC9"></path>
                            </svg>
                        </div>
                    </a>
                <?php
                }

                ?>
            </div>
        </div>
    <?php
    }
    ?>

</div>