<?php
foreach ($plugins as $k => $v) {
    ?>
    <section <?php echo ($k == 0) ? "id=resultSection" : "" ?>
        class="<?php echo ($k == 0) ? "sectionPadding !pt-0 scroll-mt-32 lg:scroll-mt-36" : "sectionPadding !pt-0 scroll-mt-32 lg:scroll-mt-36" ?>">
        <div class="py-[24px] bg-[#14243B]">
            <div class="container">
                <div class="flex space-x-3">
                    <div
                        class="flex justify-center items-center w-12 min-w-12 h-12 object-contain object-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                        <h4 class="text-white text-[25px] !leading-[120%] font-bold">
                            <?php echo ($k + 1) ?>
                        </h4>
                    </div>
                    <div class="space-y-1">
                        <p class="text-[#B0B0B0] text-sm !leading-[145%] font-normal">
                            Plugin recommendations
                        </p>
                        <h4 class="text-white text-xl !leading-[120%] font-bold">
                            <span class="relative">
                                <span
                                    class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>
                                <?= $v['feature_name'] ?></span>
                            plugin comparison
                        </h4>
                    </div>
                </div>
            </div>
        </div>

        <div class="">
            <div class="container">
                <div class="personalizeTable">
                    <div class="relative w-full overflow-x-auto scrollbarHide">
                        <table class="min-w-full text-sm text-left text-gray-600">
                            <?php
                            $plugins = $v['plugins_recommanded']; // or whatever array holds your compared plugins
                            $plugin_count = min(count($plugins), 5); // max 5 columns
                            ?>
                            <colgroup>
                                <!-- First static column -->
                                <col style="width:160px; height:560px" />

                                <!-- Dynamic plugin columns -->
                                <?php for ($i = 0; $i < $plugin_count; $i++): ?>
                                    <col style="width:232px; height:80px" />
                                <?php endfor; ?>
                            </colgroup>

                            <thead class="text-black !leading-[120%] divide-y divide-[#EEEEEE] border-b border-[#EEEEEE]">
                                <tr class="divide-x divide-[#EEEEEE]">
                                    <th class="px-3 pt-6 pb-8"></th>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k1 => $v1) {
                                        ?>
                                        <th class="px-3 pt-6 pb-8">
                                            <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                                <div
                                                    class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                                    <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                        src="<?= $v1["plugin_icon"] ?>" alt="" />
                                                </div>

                                                <div class="space-y-1">
                                                    <h4 class="text-[13px] font-bold line-clamp-3">
                                                        <?= $v1["name"] ?>
                                                    </h4>
                                                    <p class="text-[10px] font-normal">
                                                        By <?= $v1["author_name"] ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </th>
                                        <?php
                                    }
                                    ?>


                                </tr>
                            </thead>

                            <tbody class="divide-y divide-[#EEEEEE]">
                                <tr class="divide-x divide-[#EEEEEE] h-[80px] font-bold leading-[120%]">
                                    <td class="pr-4 py-4 text-[13px] text-black border-r border-[#EEEEEE]">
                                        WPScore
                                    </td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_overall_wpscore => $v_overall_wpscore) {
                                        ?>
                                        <td
                                            class="<?php echo ($v_overall_wpscore['overall_wpscore'] >= 5 && $v_overall_wpscore['overall_wpscore'] <= 7) ? "text-center font-bold text-[#FBBC05] bg-[#FBBC050A] border-l-0 border-b-[3px] !border-b-[#FBBC05]" : "text-center font-bold text-blue-600 bg-[#FCFCFC] border-l-0 border-b-[3px] !border-[#1A2DC9]" ?>">
                                            <div class="relative px-4 py-4">
                                                <a href="javascript:void(0)" class="openModalBtn absolute top-1.5 right-1.5"
                                                    data-plugin_id="<?= $v_overall_wpscore['wp_post_id'] ?>">
                                                    <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                        src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                        alt="exclamation" />
                                                </a>
                                                <div class="space-y-1">
                                                    <h3 class="text-[25px]"><?= $v_overall_wpscore['overall_wpscore'] ?></h3>
                                                    <p class="text-[10px]">
                                                        <?= wps_score_description($v_overall_wpscore['overall_wpscore']) ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </td>
                                        <?php
                                    }
                                    ?>


                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Key Features</td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_key_features => $v_key_features) {
                                        $key_features = $v_key_features["plugin_ai_profile"]["key_features"] ?? [];

                                        $features_string = is_array($key_features)
                                            ? implode(', ', $key_features)
                                            : '';



                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                            <?= $features_string ?>
                                        </td>
                                        <?php
                                    }
                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Rating</td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_key_rating => $v_key_rating) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                            <div class="flex justify-center items-center space-x-0.5">
                                                <?php render_star_rating($v_key_rating['rating']) ?>
                                            </div>
                                            <p><?= format_active_installs($v_key_rating['num_ratings']) ?>+ reviews</p>
                                        </td>
                                        <?php
                                    }

                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Active Installs</td>

                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_active_install => $v_active_install) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                            <?= format_active_installs($v_active_install['active_installs']) ?>+
                                        </td>
                                        <?php
                                    }

                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Compatibility</td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_tested => $v_tested) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]"><?= $v_tested['tested'] ?>+</td>
                                        <?php
                                    }

                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Free</td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_tested => $v_tested) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                            <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                        </td>
                                        <?php
                                    }

                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                    <td class="pr-4 py-4 font-bold">Pro</td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_license_type => $v_license_type) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                            <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                                src="<?php echo asset_image_path_generator(); ?>/<?php echo !in_array($v_license_type, ['freemium', 'paid'], true) ? 'tickmark.svg' : 'close-circle.svg'; ?>"
                                                alt="tickmark" />
                                        </td>
                                        <?php
                                    }

                                    ?>
                                </tr>

                                <tr
                                    class="divide-x divide-[#EEEEEE] h-[80px] text-base text-[#1A2DC9] font-bold leading-[160%]">
                                    <td class="pr-4 py-4 font-bold"></td>
                                    <?php
                                    foreach ($v['plugins_recommanded'] as $k_license_type => $v_license_type) {
                                        ?>
                                        <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                            <div class="">
                                                <a href="<?php echo get_the_permalink($v_license_type['wp_post_id'])?>"
                                                    class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                                    <p>View details</p>
                                                    <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                        src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                                </a>
                                            </div>
                                        </td>
                                        <?php
                                    }

                                    ?>


                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php
}

?>




<!-- <section id="resultSection" class="sectionPadding !pt-0 scroll-mt-32 lg:scroll-mt-36">
    <div class="py-[24px] bg-[#14243B]">
        <div class="container">
            <div class="flex space-x-3">
                <div
                    class="flex justify-center items-center w-12 min-w-12 h-12 object-contain object-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                    <h4 class="text-white text-[25px] !leading-[120%] font-bold">
                        1
                    </h4>
                </div>
                <div class="space-y-1">
                    <p class="text-[#B0B0B0] text-sm !leading-[145%] font-normal">
                        Plugin recommendations
                    </p>
                    <h4 class="text-white text-xl !leading-[120%] font-bold">
                        <span class="relative">
                            <span
                                class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>
                            SEO</span>
                        plugin comparison
                    </h4>
                </div>
            </div>
        </div>
    </div>

    <div class="">
        <div class="container">
            <div class="personalizeTable">
                <div class="relative w-full overflow-x-auto scrollbarHide">
                    <table class="min-w-full text-sm text-left text-gray-600">
                        <colgroup>
                            <col style="width: 160px; height: 560px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                        </colgroup>

                        <thead class="text-black !leading-[120%] divide-y divide-[#EEEEEE] border-b border-[#EEEEEE]">
                            <tr class="divide-x divide-[#EEEEEE]">
                                <th class="px-3 pt-6 pb-8"></th>
                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/10.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                Rank Math SEO – AI SEO Tools to Dominate SEO
                                                Rankings
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>
                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/7.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                Yoast SEO – Advanced SEO with real-time guidance
                                                and built-in AI
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/11.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                All in One SEO – Powerful SEO Plugin to Boost SEO
                                                Rankings & Increase Traffic
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/personalized-3.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                The SEO Framework – Fast, Automated, Effortless.
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/personalized-4.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                SEOPress – On-site SEO & Analytics
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>
                            </tr>
                        </thead>

                        <tbody class="divide-y divide-[#EEEEEE]">
                            <tr class="divide-x divide-[#EEEEEE] h-[80px] font-bold leading-[120%]">
                                <td class="pr-4 py-4 text-[13px] text-black border-r border-[#EEEEEE]">
                                    WPScore
                                </td>
                                <td
                                    class="text-center font-bold text-blue-600 bg-[#FCFCFC] border-l-0 border-b-[3px] !border-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">9.2</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#1A2DC9] bg-[#FCFCFC] border-l-0 border-b-[3px] !border-b-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">8.7</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#1A2DC9] bg-[#FCFCFC] border-l-0 border-b-[3px] !border-b-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">8.4</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#FBBC05] bg-[#FBBC050A] border-l-0 border-b-[3px] !border-b-[#FBBC05]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">6.5</h3>
                                            <p class="text-[10px]">Should be considered</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#FBBC05] bg-[#FBBC050A] border-l-0 border-b-[3px] !border-b-[#FBBC05]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">6.0</h3>
                                            <p class="text-[10px]">Should be considered</p>
                                        </div>
                                    </div>
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Key Features</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Smart schema, beginner wizard, lightweight
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Classic SEO tools, strong readability checker
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Easy XML sitemaps, social meta
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Lightweight, automated meta tags
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Clean UI, privacy-focused
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Rating</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>3k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>27k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>1.8k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>400+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>800+ reviews</p>
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Active Installs</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">2M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">5M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">3M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">100k+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">300k+</td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Compatibility</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Free</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Pro</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/close-circle.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-base text-[#1A2DC9] font-bold leading-[160%]">
                                <td class="pr-4 py-4 font-bold"></td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sectionPadding !pt-0">
    <div class="py-[24px] bg-[#14243B]">
        <div class="container">
            <div class="flex space-x-3">
                <div
                    class="flex justify-center items-center w-12 min-w-12 h-12 object-contain object-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                    <h4 class="text-white text-[25px] !leading-[120%] font-bold">
                        2
                    </h4>
                </div>
                <div class="space-y-1">
                    <p class="text-[#B0B0B0] text-sm !leading-[145%] font-normal">
                        Plugin recommendations
                    </p>
                    <h4 class="text-white text-xl !leading-[120%] font-bold">
                        <span class="relative">
                            <span
                                class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>
                            Performance & optimization</span>
                        plugin comparison
                    </h4>
                </div>
            </div>
        </div>
    </div>

    <div class="">
        <div class="container">
            <div class="personalizeTable">
                <div class="relative w-full overflow-x-auto scrollbarHide">
                    <table class="min-w-full text-[13px] text-left text-black">
                        <colgroup>
                            <col style="width: 160px; height: 560px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                            <col style="width: 232px; height: 80px" />
                        </colgroup>

                        <thead
                            class="text-black !leading-[120%] divide-y !text-left divide-[#EEEEEE] border-b border-[#EEEEEE]">
                            <tr class="divide-x divide-[#EEEEEE] !text-left">
                                <th class="px-3 pt-6 pb-8"></th>
                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/8.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                LiteSpeed Cache
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/7.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                Autoptimize
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/library/11.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                WP Rocket
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/personalized-3.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                W3 Total Cache
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>

                                <th class="px-3 pt-6 pb-8">
                                    <div class="flex flex-col lg:flex-row space-y-2.5 lg:space-y-0 lg:space-x-2.5">
                                        <div
                                            class="w-9 min-w-9 h-9 bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                            <img class="w-8 min-w-8 h-8 object-contain object-center rounded-xl"
                                                src="<?= asset_image_path_generator() ?>/personalized-4.webp" alt="" />
                                        </div>

                                        <div class="space-y-1">
                                            <h4 class="text-[13px] font-bold line-clamp-3">
                                                Hummingbird Performance – Cache & Page Speed
                                                Optimization for Core Web Vitals | Critical CSS |
                                                Minify CSS | Defer CSS Javascript | CDN
                                            </h4>
                                            <p class="text-[10px] font-normal">
                                                By Developer name
                                            </p>
                                        </div>
                                    </div>
                                </th>
                            </tr>
                        </thead>

                        <tbody class="divide-y divide-[#EEEEEE]">
                            <tr class="divide-x divide-[#EEEEEE] h-[80px] font-bold leading-[120%]">
                                <td class="pr-4 py-4 text-[13px] text-black border-r border-[#EEEEEE]">
                                    WPScore
                                </td>
                                <td
                                    class="text-center font-bold text-blue-600 bg-[#FCFCFC] border-l-0 border-b-[3px] !border-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">9.2</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#1A2DC9] bg-[#FCFCFC] border-l-0 border-b-[3px] !border-b-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">8.7</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#1A2DC9] bg-[#FCFCFC] border-l-0 border-b-[3px] !border-b-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">8.4</h3>
                                            <p class="text-[10px]">Exceptional</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#1A2DC9] bg-[#FCFCFC] border-l-0 border-b-[3px] !border-b-[#1A2DC9]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">8.4</h3>
                                            <p class="text-[10px]">Should be considered</p>
                                        </div>
                                    </div>
                                </td>
                                <td
                                    class="text-center font-bold text-[#FBBC05] bg-[#FBBC050A] border-l-0 border-b-[3px] !border-b-[#FBBC05]">
                                    <div class="relative px-4 py-4">
                                        <a href="javascript:void(0)" class="absolute top-1.5 right-1.5">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/exclamation.svg"
                                                alt="exclamation" />
                                        </a>
                                        <div class="space-y-1">
                                            <h3 class="text-[25px]">6.0</h3>
                                            <p class="text-[10px]">Should be considered</p>
                                        </div>
                                    </div>
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Key Features</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Full-page caching, image optimization, CDN support
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Minify CSS/JS/HTML, async scripts, lazy load
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    All-in-one optimization, advanced caching
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Object/database caching, CDN integration
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    Performance scanning, GZIP, lazy loading
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Rating</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>3k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>27k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>1.8k+ reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>1.8k+reviews</p>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <div class="flex justify-center items-center space-x-0.5">
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                        <img class="w-3 min-w-3 h-3 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/star-fill.svg" alt="star-fill" />
                                    </div>
                                    <p>800+ reviews</p>
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Active Installs</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">2M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">5M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">3M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">3M+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">300k+</td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Compatibility</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">6.7+</td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Free</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/close-circle.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal leading-[120%]">
                                <td class="pr-4 py-4 font-bold">Pro</td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/close-circle.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/close-circle.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                    <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/tickmark.svg" alt="tickmark" />
                                </td>
                            </tr>

                            <tr
                                class="divide-x divide-[#EEEEEE] h-[80px] text-base text-[#1A2DC9] font-bold leading-[160%]">
                                <td class="pr-4 py-4 font-bold"></td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                                <td class="px-4 py-4 text-center bg-[#FCFCFC] border-b">
                                    <div class="">
                                        <a href="javascript:void(0)"
                                            class="group flex justify-center items-center py-1.5 px-4 space-x-1.5 lg:space-x-2.5 hover:bg-[#EEEEEE] border border-[#1B3CD2] rounded-full duration-300 whitespace-nowrap">
                                            <p>View details</p>
                                            <img class="w-4 min-w-4 h-4 object-contain object-center transform duration-300 group-hover:scale-110"
                                                src="<?= asset_image_path_generator() ?>/arrow-right.svg" alt="" />
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section> -->