<?php
/*
Template Name:Customized Plugin comparison
 */
$_child_categories = Helpers::get_all_plugin_comparison_category();
$category_ids_array = $_GET['category_ids'] ? explode(',', $_GET['category_ids']) : [];
$subcategory_chunk = array_chunk($_child_categories, 7);
$category_ids = $_GET['category_ids'] ?? '';
$search_text = $_GET['search_text'] ?? '';

$args = [
    'post_type' => 'plugin_comparison',
    'posts_per_page' => limit_plugin_show,
    'post_status' => 'publish',
];

// 🔎 Search text
if (!empty($search_text)) {
    $args['s'] = $search_text;
}

// 📂 Category filter (taxonomy)
if (!empty($category_ids)) {
    $args['tax_query'] = [
        [
            'taxonomy' => 'comparison_category',
            'field' => 'term_id',
            'terms' => $category_ids_array,
        ],
    ];
}

// Run query
$query = new WP_Query($args);

get_header();
?>
<main>
    <?php
    $template = get_template_directory() . '/frontend/comparison-post-includes/header-part.php';

    if (file_exists($template)) {
        include $template;
    }
    ?>
    <section class="flex items-stretch h-full">


        <?php
        $template = get_template_directory() . '/frontend/comparison-post-includes/sidebar-part.php';

        if (file_exists($template)) {
            include $template;
        }
        ?>

        <div class="container">
            <!-- Right side  -->
            <div class="-m-3 xl:-m-4">
                <div class="py-12 flex flex-wrap items-stretch" id="all_ajax_appear_here">
                    <?php if ($query->have_posts()): ?>
                        <?php while ($query->have_posts()):
                            $query->the_post(); ?>

                            <?php
                            $post_id = get_the_ID();

                            // Get icons
                            $icons_csv_related = get_post_meta($post_id, '_comparison_plugin_icons', true);
                            $icons_related = array_filter(array_map('trim', explode(',', (string) $icons_csv_related)));
                            $template = get_template_directory() . '/frontend/content-single-plugin-comparison.php';

                            if (file_exists($template)) {
                                include $template;
                            }
                            ?>

                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                        <?php
                    else: ?>
                        <div class="flex justify-center items-center w-full py-20">
                            No Comparison found
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </section>
</main>
<form action="" method="get" id="filter_form">
    <input type="hidden" name="category_ids" value="<?php echo $category_ids; ?>">
    <input type="hidden" name="search_text" value="<?php echo $search_text; ?>">
</form>
<?php
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-basic-utility-control.php';
if (file_exists($template)) {
    include $template;
}
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-search-operations.php';
if (file_exists($template)) {
    include $template;
}

?>
<script>
    jQuery(function ($) {

        let isLoading = false;
        let offset = <?=limit_plugin_show?>;
        const limit = <?=limit_plugin_show?>;

        function loadMorePlugins() {

            if (isLoading) return;
            isLoading = true;
            $("#scroll_loader").removeClass("hidden");
            let data = {
                action: "load_more_comparison_plugins",
                offset: offset,
                limit: limit
            };

            // 🔥 Automatically read all hidden inputs from filter form
            $("#filter_form input[type='hidden']").each(function () {
                let key = $(this).attr("name");
                let val = $(this).val();
                data[key] = val;
            });

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                type: "POST",
                data: data,
                success: function (response) {
                    $("#scroll_loader").addClass("hidden");
                    if ($.trim(response) !== "") {
                        $("#all_ajax_appear_here").append(response);
                        offset += limit;
                        isLoading = false;
                    } else {
                        // No more items
                        $(window).off("scroll");
                    }
                }
            });

        }

        // 🔥 Trigger load when scroll bottom
        $(window).on("scroll", function () {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 300) {
                loadMorePlugins();
            }
        });

        // Load first set automatically
        //loadMorePlugins();
        function triggerSearch(inputSelector) {
            var searchText = $(inputSelector).val().trim();
            $('[name="search_text"]').val(searchText);
            $("#filter_form").submit();

        }
        $('#searchInput, #searchInputM').on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                triggerSearch(this);
            }
        });
        $(document).on('click', 'img.close_icon', function () {
            $("#searchInput").val('').trigger('input')
            $("#searchInputM").val('').trigger('input')
        })
    });

</script>

<?php

get_footer();