<?php
/*
Template Name:Customized Home Page
 */
$top_categories = get_option("top_plugin_categories");

if (!empty($top_categories) && count($top_categories) >= 5) {
    // Pick 5 random keys
    $random_keys = array_rand($top_categories, 5);

    // Get the corresponding values
    $random_items = array_map(function ($key) use ($top_categories) {
        return $top_categories[$key];
    }, $random_keys);
} else {
    // If fewer than 5 items, just use them all
    $random_items = $top_categories;
}
$_the_most_usefull_plugins_icons_total_category_plugin_count = get_option('_the_most_usefull_plugins_icons_total_category_plugin_count');
//dd($_the_most_usefull_plugins_icons_total_category_plugin_count);
$top_plugins_icons = $_the_most_usefull_plugins_icons_total_category_plugin_count["top_plugin_icons"];
$top_plugins_ids = $_the_most_usefull_plugins_icons_total_category_plugin_count["plugin_ids"];

if (!empty($top_plugins_icons) && count($top_plugins_icons) >= 12) {
    // Pick 5 random keys
    $random_keys = array_rand($top_plugins_icons, 12);

    // Get the corresponding values
    $random_items_plugin_icons = array_map(function ($key) use ($top_plugins_icons) {
        return $top_plugins_icons[$key];
    }, $random_keys);
} else {
    // If fewer than 5 items, just use them all
    $random_items_plugin_icons = $top_plugins_icons;
}

if (!empty($top_plugins_ids) && count($top_plugins_ids) >= 8) {
    // Pick 5 random keys
    $random_keys = array_rand($top_plugins_ids, 8);

    // Get the corresponding values
    $random_items_plugin_ids = array_map(function ($key) use ($top_plugins_ids) {
        return $top_plugins_ids[$key];
    }, $random_keys);
} else {
    // If fewer than 5 items, just use them all
    $random_items_plugin_ids = $top_plugins_ids;
}
$_chunk_plugin_ids = array_chunk($random_items_plugin_ids, 4);


$first_chunk_data = plugin_cpt_frontend_load::get_plugins_by_ids($_chunk_plugin_ids[0]);
$second_chunk_data = plugin_cpt_frontend_load::get_plugins_by_ids($_chunk_plugin_ids[1]);

get_header();
?>

<main>
    <section
        class="relative pt-16 md:pt-20 lg:pt-[18px] pb-[186px] w-full h-full bg-gradient-to-t from-[#A4E4FF] to-[#ffffff]">
        <div
            class="z-20 absolute -bottom-[0.4px] left-0 w-full h-[300px] bg-white [clip-path:polygon(0_100%,100%_1.5%,100%_100%,0_100%)]">
        </div>
        <div class="container">
            <div class="sectionWidth">
                <div class="relative">
                    <!--  Start: Find the best -->
                    <div
                        class="absolute left-0 lg:left-1/2 lg:-translate-x-1/2 bottom-[-22%] lg:-bottom-[42%] z-20 w-full lg:w-[993px] mx-auto">
                        <div
                            class="py-8 px-5 sm:px-9 lg:px-[60px] text-[var(--theme-color)] bg-[var(--theme-white)] shadow-[0_12px_24px_0_#1C39D21F] rounded-xl space-y-8">
                            <div class="relative max-w-[560px] mx-auto">
                                <div class="absolute bottom-[10px] sm:bottom-[14px] right-4 sm:right-[77px]">
                                    <img class="w-4 h-4"
                                        src="<?php echo asset_image_path_generator() . 'Vector.webp' ?>" alt="Vector" />
                                </div>
                                <h2 class="text-xl md:text-[22px] lg:text-[25px] text-center font-bold !leading-[120%]">
                                    Find the best WordPress plugins tailored to your needs
                                    with the power of AI.
                                </h2>
                            </div>

                            <div class="space-y-3">

                                <!-- Search Bar Wrapper -->
                                <div class="relative w-full search-wrapper">

                                    <!-- Search Bar -->
                                    <div
                                        class="flex justify-between space-x-3 py-2 lg:py-[15px] px-4 md:px-6 bg-[#F8F8F8] rounded-[24px] border border-[#EEEEEE]">

                                        <!-- Left: Only Input -->
                                        <div class="flex items-center w-full">
                                            <img src="<?php echo asset_image_path_generator() . 'search.svg' ?>"
                                                alt="Search Icon"
                                                class="w-5 h-5 opacity-100 home_fuzzy_search cursor-pointer" />
                                            <input id="searchInput" type="text" placeholder="Search wordpress plugins"
                                                class=" text-base bg-transparent outline-none border-none placeholder-black/25 text-black w-full" />
                                        </div>

                                        <!-- Right: Filter Icon -->
                                        <button>
                                            <img src="<?php echo asset_image_path_generator() . 'filter.svg' ?>"
                                                alt="Filter Icon"
                                                class="w-5 h-5 outline-none cursor-pointer opacity-100 hover:opacity-70 transition-opacity duration-300" />
                                        </button>
                                    </div>

                                    <!-- Suggestion Dropdown -->
                                    <div id="suggestionBox" class=" hidden absolute left-0 right-0 bg-white border border-gray-200 rounded-xl shadow-lg mt-1.5 z-50 
                                            overflow-y-auto max-h-64 scrollbarHide">
                                    </div>

                                </div>

                                <!-- <script>
                                    const searchInput = document.getElementById("searchInput");
                                    const suggestionBox = document.getElementById("suggestionBox");

                                    const suggestions = [
                                        { text: "wordpress seo plugin", url: "https://example.com/wordpress-seo-plugin" },
                                        { text: "woocommerce customize", url: "https://example.com/woocommerce-customize" },
                                        { text: "elementor addon", url: "https://example.com/elementor-addon" },
                                        { text: "contact form error fix", url: "https://example.com/contact-form-error-fix" },
                                        { text: "rank math sitemap", url: "https://example.com/rank-math-sitemap" },
                                        { text: "wordpress speed optimize", url: "https://example.com/wordpress-speed-optimize" },
                                        { text: "plugin development tutorial", url: "https://example.com/plugin-development-tutorial" }
                                    ];

                                    // Show suggestions on focus
                                    searchInput.addEventListener("focus", () => {
                                        renderSuggestionList(suggestions);
                                        suggestionBox.classList.remove("hidden");
                                    });

                                    // Filter suggestions while typing
                                    searchInput.addEventListener("input", () => {
                                        const q = searchInput.value.toLowerCase();
                                        const filtered = suggestions.filter(item => item.text.toLowerCase().includes(q));
                                        renderSuggestionList(filtered);
                                        suggestionBox.classList.toggle("hidden", filtered.length === 0);
                                    });

                                    // Render dropdown list
                                    function renderSuggestionList(list) {
                                        suggestionBox.innerHTML = list.map(item => `
                                            <a href="${item.url}" class="block px-4 py-3 hover:bg-gray-100 cursor-pointer text-sm">
                                                ${item.text}
                                            </a>
                                        `).join("");
                                    }

                                    // Hide on outside click
                                    document.addEventListener("click", (e) => {
                                        if (!e.target.closest(".search-wrapper")) {
                                            suggestionBox.classList.add("hidden");
                                        }
                                    });
                                </script> -->



                                <div class="flex items-center space-x-3 text-[13px] font-bold !leading-[120%]">
                                    <span class="text-[var(--theme-color)] font-normal">
                                        Suggestions:
                                    </span>
                                    <div
                                        class="scrollSliderBrand overflow-x-auto scrollbarHide flex gap-2 font-bold text-[var(--theme-color)]">
                                        <?php

                                        foreach ($random_items as $single) {
                                        ?>
                                        <a href="<?php echo $single["link"] ?>"
                                            class="shrink-0 p-[1px] group bg-[#EEEEEE] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full whitespace-nowrap">
                                            <span
                                                class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?php echo $single["name"] ?>
                                                <span
                                                    class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                        alt="icon"
                                                        class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                        <?php
                                        }
                                        ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--  End: Find the best -->
                    <div
                        class="flex lg:flex-row flex-col justify-between items-center space-y-8 lg:space-y-0 lg:space-x-10 xl:space-x-14">
                        <!-- left side banner -->
                        <div
                            class="w-full lg:w-[50%] text-center lg:text-start text-base text-[var(--theme-color)] space-y-5 md:space-y-6 lg:space-y-8">
                            <div class="relative">
                                <div class="absolute -top-14 left-[44.7%]">
                                    <img class="w-11 lg:min-w-[54px] h-11 lg:min-h-[54px]"
                                        src="<?php echo asset_image_path_generator() . '1-after.svg' ?>" alt="" />
                                </div>
                                <div class="absolute top-[33%] right-0 xl:right-[110px]">
                                    <img class="w-8 lg:min-w-[42px] h-8 lg:min-h-[42px]"
                                        src="<?php echo asset_image_path_generator() . '2-after.svg' ?>" alt="" />
                                </div>
                                <h1 class=" lg:w-[500px] text-4xl md:text-5xl lg:text-[61px] font-bold !leading-[120%]">
                                    Discover the perfect plugin instantly.
                                </h1>
                            </div>
                            <p class="font-normal leading-[160%]">
                                Find the best WordPress plugins tailored to your needs with
                                the power of AI.
                            </p>
                            <h4 class="font-bold leading-[160%]">
                                Which best describes your website?
                            </h4>
                            <?php include_once get_template_directory() . '/frontend/home-page-includes/industry.php'; ?>

                        </div>

                        <!-- right side banner -->
                        <?php include_once get_template_directory() . '/frontend/home-page-includes/page-right-side-banner.php'; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding mt-12 sm:mt-8 bg-[linear-gradient(180deg,#FFFFFF_36.3%,#A4E4FF_178.33%)]">
        <div class="container">
            <div class="max-w-[993px] mx-auto">
                <div class="space-y-8">
                    <h4 class="text-center text-[13px] font-normal !leading-[120%]">
                        Trusted by notable big name websites
                    </h4>
                    <div
                        class="scrollSliderBrand overflow-x-auto scrollbarHide flex items-center space-x-8 sm:space-x-12">
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/1.webp' ?>" alt="Brand 1" />
                        </div>
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/2.webp' ?>" alt="Brand 2" />
                        </div>
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/3.webp' ?>" alt="Brand 3" />
                        </div>
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/4.webp' ?>" alt="Brand 4" />
                        </div>
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/5.webp' ?>" alt="Brand 5" />
                        </div>
                        <div class="flex-1 min-w-[120px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/6.webp' ?>" alt="Brand 6" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php
    require get_template_directory() . '/frontend/home-page-includes/plugins-banner-section.php';
    ?>
    <?php
    require get_template_directory() . '/frontend/home-page-includes/faq.php';
    ?>
    <?php
    require get_template_directory() . '/frontend/home-page-includes/reviews.php';
    ?>


    <section class="sectionPaddingBottom">
        <div class="container">
            <div class="sectionWidth">
                <div
                    class="px-7 p-10 lg:p-[60px] flex lg:flex-row flex-col justify-between items-center text-center lg:text-start bg-[#A5E4FF] rounded-[32px] space-y-6  shadow-[0px_12px_24px_0px_#1C39D21F] lg:space-y-0 lg:space-x-8">
                    <div class="space-y-3">
                        <h2 class="text-3xl lg:text-[39px] font-bold !leading-[120%]">
                            Join thousands of wordpress enthusiasts
                        </h2>
                        <p class="text-base font-normal leading-[160%]">
                            Find the best WordPress plugins tailored to your needs with
                            the power of AI.
                        </p>
                    </div>
                    <a href="<?=site_url("/sign-up")?>"
                        class="py-4 lg:py-[21px] px-8 text-base leading-[160%] font-bold text-[var(--theme-white)] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-300 rounded-[54px] whitespace-nowrap">
                        Start Searching Now
                    </a>
                </div>
            </div>
        </div>
    </section>

    <?php
    require get_template_directory() . '/frontend/content-fuzzy-search.php';
    require get_template_directory() . '/frontend/user-dashboard-includes/plugin-search-modal-wizard.php';
    require get_template_directory() . '/frontend/user-dashboard-includes/shared_javascript.php';
    ?>
    <form action="<?= site_url('/plugin-recommendation') ?>" method="post" id="form_recommandation">
        <input type="hidden" name="type_website_building" id="type_website_building" value="">
        <input type="hidden" name="builder_theme_using" id="builder_theme_using" value="">
        <input type="hidden" name="features_need_in_site" id="features_need_in_site" value="">
        <input type="hidden" name="budget_level_plugins" id="budget_level_plugins" value="">
        <input type="hidden" name="monthly_traffic" id="monthly_traffic">
        <input type="hidden" name="comfortable_configuration_settings" id="comfortable_configuration_settings">
    </form>
    <script>
    jQuery(document).ready(function($) {
        // Check if the .scrollSlider elements exist before executing the script
        $(".scrollSliderBrand").each(function() {
            const slider = $(this);
            let isDown = false;
            let startX;
            let scrollLeft;

            // Only scroll if content is overflowing
            function canScrollHorizontally() {
                const el = slider[0];
                return el.scrollWidth > el.clientWidth;
            }

            // Drag to scroll
            slider.on("mousedown", function(e) {
                if (!canScrollHorizontally()) return;

                isDown = true;
                slider.addClass("dragging");
                startX = e.pageX - slider.offset().left;
                scrollLeft = slider.scrollLeft();
                e.preventDefault();
            });

            slider.on("mouseleave mouseup", function() {
                isDown = false;
                slider.removeClass("dragging");
            });

            slider.on("mousemove", function(e) {
                if (!isDown || !canScrollHorizontally()) return;

                const x = e.pageX - slider.offset().left;
                const walk = (x - startX) * 1.5; // scroll speed
                slider.scrollLeft(scrollLeft - walk);
            });

            // Scroll with mouse wheel
            slider.on("wheel", function(e) {
                const el = slider[0];
                if (!canScrollHorizontally()) return;

                const maxScroll = el.scrollWidth - el.clientWidth;
                const newScroll = el.scrollLeft + e.originalEvent.deltaY;

                // Only scroll if within bounds
                if (newScroll >= 0 && newScroll <= maxScroll) {
                    e.preventDefault(); // prevent default page scroll
                    el.scrollLeft = newScroll;
                }
            });
        });

    });
    </script>
</main>
<?php
get_footer();