<?php
/*
Template Name:Customized Fuzzy Search Page
 */



$search_text = $_GET['text'] ?? '';
$name = $search_text;

/**
 * ---------------------------------------
 * 1. Fuzzy search
 * ---------------------------------------
 */
$plugin_by_search = !empty($search_text)
    ? plugin_cpt_frontend_load::fuzzy_search_plugin_suggestions_with_category($search_text)
    : [];
//  dd($plugin_by_search);

$post_id_from_fuzzy = [];
$category_ids_from_fuzzy = [];

foreach ($plugin_by_search as $item) {
    if (!empty($item['post_id'])) {
        $post_id_from_fuzzy[] = $item['post_id'];
    }
    if (!empty($item['category_id'])) {
        $category_ids_from_fuzzy[] = (int) $item['category_id'];
    }
}

/**
 * ---------------------------------------
 * 2. Helper mappings
 * ---------------------------------------
 */
$rating_filter_mapping = Helpers::rating_filter_mapping();
$wps_score_filter_mapping = Helpers::wps_score_filter_mapping();
$_child_categories = Helpers::get_all_main_category_fuzzy($category_ids_from_fuzzy);
$last_updated_plugin_mapping = Helpers::last_updated_plugin_mapping();
$active_installation_plugin_mapping = Helpers::active_installation_plugin_mapping();
$support_quality_plugin_mapping = Helpers::support_quality_plugin_mapping();
$user_review_sentiment_plugin_mapping = Helpers::user_review_sentiment_plugin_mapping();
$performace_impact_plugin_mapping = Helpers::performace_impact_plugin_mapping();
$multilingual_support_plugin_mapping = Helpers::multilingual_support_plugin_mapping();
$sort_by_key_mapping = Helpers::sort_by_key_mapping();
$subcategory_chunk = array_chunk($_child_categories, 7);

$category_ids_array = [];
/**
 * ---------------------------------------
 * 3. CATEGORY ID PRIORITY (KEEP ARRAY)
 * ---------------------------------------
 */
/**
 * ---------------------------------------------------------
 * 1. Sanitize fuzzy categories
 * ---------------------------------------------------------
 */
$fuzzy_ids = !empty($category_ids_from_fuzzy)
    ? array_values(array_unique(array_filter(array_map('intval', $category_ids_from_fuzzy))))
    : [];

/**
 * ---------------------------------------------------------
 * 2. Apply GET filter if provided
 * ---------------------------------------------------------
 */
if (!empty($_GET['category_ids'])) {
    $get_ids = array_values(array_unique(array_filter(array_map('intval', explode(',', $_GET['category_ids'])))));

    // Keep only fuzzy IDs that exist in GET
    $category_ids_array = array_values(array_intersect($fuzzy_ids, $get_ids));
    $_all_child_tags = plugin_cpt_frontend_load::get_all_tags_by_category_ids($category_ids_array);
} else {
    // No GET → keep all fuzzy
    $category_ids_array = $fuzzy_ids;
    $_all_child_tags = plugin_cpt_frontend_load::get_all_tags_by_category_ids($category_ids_array);
}

$category_ids = implode(',', $category_ids_array);
// Alias used later
$taxonomy_ids = $category_ids_array;

// Operation of tags

// dd($_all_child_tags);
$tag_ids = $_GET['tag_ids'] ?? ''; //will use in the hidden name
$selected_tag_ids_array = $_GET['tag_ids'] ? explode(',', $_GET['tag_ids']) : [];
// First array with the first 25 elements
$first_chunk_tag = array_slice($_all_child_tags, 0, 20);

// Second array with the remaining elements
$second_chunk_tag = array_slice($_all_child_tags, 20);
/**
 * ---------------------------------------
 * 4. GET filter params
 * ---------------------------------------
 */
$rating = $_GET['rating'] ?? '';
$overall_wpscore = $_GET['overall_wpscore'] ?? '';
$last_update = $_GET['last_update'] ?? '';
$active_install = $_GET['active_install'] ?? '';
$support_quality = $_GET['support_quality'] ?? '';
$performace_impact = $_GET['performace_impact'] ?? '';
$user_review_sentiment = $_GET['user_review_sentiment'] ?? '';
$multilingual_support = $_GET['multilingual_support'] ?? '';
$sort_by = $_GET['sort_by'] ?? '';
/**
 * ---------------------------------------
 * 5. Dynamic filters
 * ---------------------------------------
 */
$filter_from_query_param = [];

if ($rating) {
    $map = Helpers::rating_filter_mapping($rating);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($overall_wpscore) {
    $map = Helpers::wps_score_filter_mapping($overall_wpscore);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($last_update) {
    $map = Helpers::last_updated_plugin_mapping($last_update);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($active_install) {
    $map = Helpers::active_installation_plugin_mapping($active_install);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($support_quality) {
    $map = Helpers::support_quality_plugin_mapping($support_quality);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($performace_impact) {
    $map = Helpers::performace_impact_plugin_mapping($performace_impact);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($user_review_sentiment) {
    $map = Helpers::user_review_sentiment_plugin_mapping($user_review_sentiment);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}

if ($multilingual_support) {
    $map = Helpers::multilingual_support_plugin_mapping($multilingual_support);
    if (!empty($map))
        $filter_from_query_param[] = $map;
}
$primary_order_post_ids = [];
/**
 * ---------------------------------------
 * 6. post_title IN (...) only if fuzzy exists
 * ---------------------------------------
 */
if (!empty($post_id_from_fuzzy)) {
    $primary_order_post_ids = array_values(array_unique($post_id_from_fuzzy));
    $filter_from_query_param[] = [
        'field' => 'wp_post_id',
        'operator' => 'in',
        'value' => $primary_order_post_ids,
    ];
}

/**
 * ---------------------------------------
 * 7. ORDER BY
 * ---------------------------------------
 */
$order_by = [
    ['field' => 'overall_wpscore', 'direction' => 'desc'],
];
$order_by = [
    ['field' => 'overall_wpscore', 'direction' => 'desc'],
];
if ($sort_by) {
    $sort_by_meta = Helpers::sort_by_key_mapping($sort_by);
    $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
    $order_by = array_reverse($order_by);
}
/**
 * ---------------------------------------
 * 8. FINAL QUERIES
 * ---------------------------------------
 */
$overall_wpscore_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
    $taxonomy_ids,
    limit_plugin_show,
    0,
    $filter_from_query_param,
    $order_by,
    'is_sponsored',
    1,
    $primary_order_post_ids,
    $selected_tag_ids_array
);

$is_sponsored_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
    $taxonomy_ids,
    30,
    0,
    $filter_from_query_param,
    $order_by,
    'is_sponsored',
    2,
    $primary_order_post_ids,
    $selected_tag_ids_array
);

get_header();
?>
<main>
    <?php
    $template = get_template_directory() . '/frontend/fuzzy-search-includes/header-part-fuzzy-search.php';

    if (file_exists($template)) {
        include $template;
    }
    ?>
    <section class="flex items-stretch h-full">
        <?php
        $template = get_template_directory() . '/frontend/fuzzy-search-includes/sidebar-part-fuzzy-search.php';

        if (file_exists($template)) {
            include $template;
        }
        ?>


        <!-- Right side  -->
        <div class="flex-1">
            <?php
            if (!empty($is_sponsored_plugin)) {
                $template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/sponsored-plugins.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
            if (!empty($overall_wpscore_plugin)) {
                $template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/all-plugins.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
            if (empty($is_sponsored_plugin) && empty($overall_wpscore_plugin)) {
                ?>
                <div class="flex justify-center items-center h-screen">No plugin found</div><?php
            }
            ?>
        </div>

    </section>
</main>
<form action="" method="get" id="filter_form">
    <input type="hidden" name="rating" value="<?php echo esc_attr($rating); ?>">
    <input type="hidden" name="overall_wpscore" value="<?php echo esc_attr($overall_wpscore); ?>">
    <input type="hidden" name="category_ids" value="<?php echo $category_ids; ?>">
    <input type="hidden" name="tag_ids" value="<?php echo $tag_ids; ?>">
    <input type="hidden" name="last_update" value="<?php echo $last_update; ?>">
    <input type="hidden" name="active_install" value="<?php echo $active_install; ?>">
    <input type="hidden" name="support_quality" value="<?php echo $support_quality; ?>">
    <input type="hidden" name="performace_impact" value="<?php echo $performace_impact; ?>">
    <input type="hidden" name="user_review_sentiment" value="<?php echo $user_review_sentiment; ?>">
    <input type="hidden" name="multilingual_support" value="<?php echo $multilingual_support; ?>">
    <input type="hidden" name="text" value="<?php echo $search_text; ?>">
    <input type="hidden" name="sort_by" value="<?php echo $sort_by; ?>">
</form>
<?php
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-basic-utility-control.php';
if (file_exists($template)) {
    include $template;
}
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-search-operations.php';
if (file_exists($template)) {
    include $template;
}



?>
<script>
    jQuery(function ($) {

        let isLoading = false;
        let offset = <?=limit_plugin_show?>;
        const limit = <?=limit_plugin_show?>;

        function loadMorePlugins() {

            if (isLoading) return;
            isLoading = true;
            $("#scroll_loader").removeClass("hidden");
            let data = {
                action: "load_more_plugins_fuzzy",
                fuzzy_post_ids: "<?php echo implode(',', $primary_order_post_ids) ?>",
                offset: offset,
                limit: limit
            };

            // 🔥 Automatically read all hidden inputs from filter form
            $("#filter_form input[type='hidden']").each(function () {
                let key = $(this).attr("name");
                let val = $(this).val();
                data[key] = val;
            });

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                type: "POST",
                data: data,
                success: function (response) {
                    $("#scroll_loader").addClass("hidden");
                    if ($.trim(response) !== "") {
                        $("#all_ajax_appear_here").append(response);
                        offset += limit;
                        isLoading = false;
                    } else {
                        // No more items
                        $(window).off("scroll");
                    }
                }
            });

        }

        // 🔥 Trigger load when scroll bottom
        $(window).on("scroll", function () {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 300) {
                loadMorePlugins();
            }
        });

        // Load first set automatically
        //loadMorePlugins();

    });
</script>

<?php
require get_template_directory() . '/frontend/content-fuzzy-search.php';
get_footer();
