<?php
/*
Template Name:Customized Dashboard
 */
if (!is_user_logged_in()) {
    // Redirect logged-in users to another page
    wp_redirect(home_url('/sign-up')); // Replace '/another-page' with the desired URL slug
    exit;
}    // Ensures the script stops after redirection

get_header();
?>
<main>
    <section class="border-y border-[#F2F2F2]">
        <div class="container">
            <div class="flex justify-between items-center">
                <div class="w-[calc(100%-90px)] sm:w-[calc(100%-107px)] flex justify-between items-center">
                    <!-- Tabs Dashboard -->
                    <div class="overflow-x-auto scrollbarHide">
                        <div class="inline-flex text-base text-[#A1A7B1] font-normal !leading-[160%]">
                            <button
                                class="tabBtnPlugin mr-8 py-3 sm:py-3.5 border-b-4 border-[#1A2DC9] text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors whitespace-nowrap duration-300"
                                data-tab="Dashboard">
                                Dashboard
                            </button>
                            <button
                                class="tabBtnPlugin mr-8 py-3 sm:py-3.5 border-b-4 border-transparent hover:text-[#1A1A1A] hover:border-[#1A2DC9] transition-colors whitespace-nowrap duration-300"
                                data-tab="accountSettings">
                                Account Settings
                            </button>
                        </div>
                    </div>

                    <div class="w-px self-stretch bg-[#F2F2F2]"></div>
                </div>

                <div class="flex items-center space-x-2 text-[13px] leading-[120%] font-bold">
                    <a href="<?php echo wp_logout_url(home_url('/sign-up')); ?>"
                        class="px-3 py-2 text-white inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
                        Sign out
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="py-[61px]">
        <div class="container">
            <div class="sectionWidth">
                <!-- Tab Contents Dashboard -->
                <div class="">
                    <?php
                    $template = get_template_directory() . '/frontend/user-dashboard-includes/dashboard.php';

                    if (file_exists($template)) {
                        include $template;
                    }

                    $template = get_template_directory() . '/frontend/user-dashboard-includes/account-settings.php';

                    if (file_exists($template)) {
                        include $template;
                    }
                    ?>


                </div>
            </div>
        </div>
    </section>

    <!-- Modal wizard start-->
    <?php
    $template = get_template_directory() . '/frontend/user-dashboard-includes/plugin-search-modal-wizard.php';

    if (file_exists($template)) {
        include $template;
    }
    ?>
    <form action="<?= site_url('/plugin-recommendation') ?>" method="post" id="form_recommandation">
        <input type="hidden" name="type_website_building" id="type_website_building" value="">
        <input type="hidden" name="builder_theme_using" id="builder_theme_using" value="">
        <input type="hidden" name="features_need_in_site" id="features_need_in_site" value="">
        <input type="hidden" name="budget_level_plugins" id="budget_level_plugins" value="">
        <input type="hidden" name="monthly_traffic" id="monthly_traffic" >
        <input type="hidden" name="comfortable_configuration_settings" id="comfortable_configuration_settings">
    </form>
    <!-- Modal wizard End-->
</main>
<?php
$template = get_template_directory() . '/frontend/user-dashboard-includes/shared_javascript.php';

if (file_exists($template)) {
    include $template;
}
?>

<?php
get_footer();
