<?php

global $wpdb;

global $wpdb;

// Dynamic variables (can be changed easily)
$post_type   = 'customer_review';
$post_status = 'publish';

// SQL query to fetch reviews with title, content, and excerpt only
$query = $wpdb->prepare("
    SELECT 
        p.ID,
        p.post_title,
        p.post_content,
        p.post_excerpt
    FROM 
        {$wpdb->posts} AS p
    WHERE 
        p.post_type = %s
        AND p.post_status = %s
    ORDER BY 
        p.menu_order ASC
", $post_type, $post_status);
// Execute the query
$reviews = $wpdb->get_results($query);
//dd($reviews);
$first_half = [];
$second_half = [];
if (!empty($reviews)) {
    // Split the array into two segments
    $half = ceil(count($reviews) / 2);
    $first_half = array_slice($reviews, 0, $half);
    $second_half = array_slice($reviews, $half);
}

?>
<section class="sectionPadding">
    <div class="container">
        <div class="sectionWidth">
            <div class="-m-3 lg:-m-4">
                <div class="flex flex-wrap justify-center">
                    <div
                        class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                        <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                            <img src="<?php echo asset_image_path_generator() . 'works/1.png' ?>" alt="" />
                        </div>
                        <div class="space-y-8 flex flex-col justify-center items-center">
                            <div class="relative">
                                <div class="w-12 min-w-12 h-12 object-contain object-center flex justify-center items-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                                    <span class="text-[25px] text-white !leading-[120%] font-bold">1</span>
                                </div>
                                <div class="hidden xl:block absolute top-1/2 left-[55px] w-[350px] h-px border border-dashed border-[#727C89]"></div>
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold !leading-[120%]">
                                    Search
                                </h2>
                                <p>
                                    Enter your need by filling the simple 3-steps wizard to
                                    make more personalized.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div
                        class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                        <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                            <img src="<?php echo asset_image_path_generator() . 'works/2.png' ?>" alt="" />
                        </div>
                        <div class="space-y-8 flex flex-col justify-center items-center">
                            <div class="relative">
                                <div class="w-12 min-w-12 h-12 object-contain object-center flex justify-center items-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                                    <span class="text-[25px] text-white !leading-[120%] font-bold">2</span>
                                </div>
                                <div class="hidden xl:block absolute top-1/2 left-[55px] w-[350px] h-px border border-dashed border-[#727C89]"></div>
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold !leading-[120%]">
                                    Discover
                                </h2>
                                <p>
                                    Let AI suggest the most relevant plugins for your
                                    website.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div
                        class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                        <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                            <img src="<?php echo asset_image_path_generator() . 'works/3.png' ?>" alt="" />
                        </div>
                        <div class="space-y-8 flex flex-col justify-center items-center">
                            <div>
                                <div class="w-12 min-w-12 h-12 object-contain object-center flex justify-center items-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                                    <span class="text-[25px] text-white !leading-[120%] font-bold">3</span>
                                </div>
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold !leading-[120%]">
                                    Download
                                </h2>
                                <p>
                                    Click through to WordPress.org for easy installation.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sectionPadding w-full h-full bg-gradient-to-b from-[#A4E4FF] to-[#ffffff]">
    <div class="space-y-10 lg:space-y-[60px]">
        <h2 class="text-3xl md:text-4xl lg:text-[49px] text-center font-bold leading-[120%] px-4">
            Everyone was happy
        </h2>

        <div class="space-y-6 lg:space-y-8 text-base font-normal leading-[160%]">
            <!-- top slider -->
            <div class="slider-wrapper w-full relative overflow-hidden">
                <div class="slider-track flex items-end space-x-6 lg:space-x-8 will-change-transform">
                    <?php
                    if (!empty($first_half)) {
                        foreach ($first_half as $single) {
                    ?>
                            <div class="slide">
                                <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                    <p>
                                        "<?php echo $single->post_content ?>"
                                    </p>
                                    <div class="flex space-x-3">
                                        <div
                                            class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#02AAF2] rounded-full overflow-hidden">
                                            <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                                src="<?php echo esc_url( get_the_post_thumbnail_url( $single->ID, 'full' ) ); ?>" alt="Profile-Image" />
                                        </div>

                                        <div class="space-y-2">
                                            <h2 class="font-bold"><?php echo $single->post_title ?></h2>
                                            <p class="text-[13px] leading-[120%]">
                                                <?php echo $single->post_excerpt ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>

            <!-- bottom slider -->
            <div class="slider-wrapper slider-wrapper2 w-full relative overflow-hidden">
                <div class="slider-track flex items-start space-x-6 lg:space-x-8 will-change-transform">
                    <?php if (!empty($second_half)) {
                        foreach ($second_half as $single) {
                    ?>
                            <div class="slide">
                                <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                    <p>
                                        "<?php echo $single->post_content ?>"
                                    </p>
                                    <div class="flex space-x-3">
                                        <div
                                            class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-gray-500 rounded-full overflow-hidden">
                                            <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                                src="<?php echo esc_url( get_the_post_thumbnail_url( $single->ID, 'full' ) ); ?>"
                                                alt="Profile-Image" />
                                        </div>

                                        <div class="space-y-2">
                                            <h2 class="font-bold"><?php echo $single->post_title ?></h2>
                                            <p class="text-[13px] leading-[120%]">
                                                <?php echo $single->post_excerpt ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php
                        }
                    } ?>

                </div>
            </div>
        </div>
    </div>
</section>