<?php
global $wpdb;

// Dynamic variables (you can change these)
$post_type = 'home_page_faq';
$post_status = 'publish';
$meta_key = '_home_page_faq_groups';

// Build the SQL query dynamically (safe & optimized)
$query = $wpdb->prepare("
    SELECT 
        p.post_title AS faq_title,
        pm.meta_value AS home_page_faq_groups
    FROM 
        {$wpdb->posts} AS p
    INNER JOIN 
        {$wpdb->postmeta} AS pm
        ON p.ID = pm.post_id
    WHERE 
        p.post_type = %s
        AND p.post_status = %s
        AND pm.meta_key = %s
    ORDER BY 
        p.menu_order ASC
", $post_type, $post_status, $meta_key);

// Execute the query
$faqs = $wpdb->get_results($query);



?>
<section>
    <div class="container">
        <div class="sectionWidth">
            <div
                class="px-4 sm:px-6 md:px-10 lg:px-[49px] py-9 md:py-12 lg:py-[53px] font-bold !leading-[120%] bg-[linear-gradient(90deg,#1C37D1_0%,#0E70DD_100%)] rounded-[32px] space-y-6 md:space-y-8 lg:space-y-10">
                <h2 class="text-center text-3xl md:text-4xl lg:text-[49px] text-white">
                    Why choose WPSearch.ai?
                </h2>

                <div id="accordion-flush-6" data-accordion="collapse" data-active-classes="border-b"
                    data-inactive-classes="border-b" class="space-y-10 homeFAQWPSearch">
                    <?php
                    if (!empty($faqs)) {
                        foreach ($faqs as $key => $single_faq) {
                            $home_page_faq_groups = unserialize($single_faq->home_page_faq_groups);
                            $index = $key + 1;
                    ?>
                            <!-- Q1 -->
                            <div class="">
                                <h2 id="accordion-flush-heading-<?php echo $index; ?>">
                                    <button type="button"
                                        class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                        data-accordion-target="#accordion-flush-body-<?php echo $index; ?>" aria-expanded="true"
                                        aria-controls="accordion-flush-body-<?php echo $index; ?>">
                                        <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold !leading-[120%]">
                                            <?= $single_faq->faq_title ?>
                                        </span>

                                        <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                            <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                                alt="Plus Icon" />
                                            <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                                alt="Minus Icon" />
                                        </div>
                                    </button>
                                </h2>

                                <div id="accordion-flush-body-<?php echo $index; ?>" aria-labelledby="accordion-flush-heading-<?php echo $index; ?>"
                                    class="text-sm font-normal !leading-[165%] bg-white hidden">
                                    <div
                                        class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                        <!-- left site -->
                                        <div
                                            class="px-1 sm:px-4 py-[38px] bg-[#E0E0E0] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                            <div class="">
                                                <img class="w-[174.45px] mx-auto"
                                                    src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                    alt="wpLogo" />
                                            </div>
                                            <div class="">
                                                <img class="aspect-[2.347] object-contain"
                                                    src="<?php echo $home_page_faq_groups[0]["image"] ?>"
                                                    alt="Frame-1" />
                                            </div>
                                            <div class="space-y-6">
                                                <h2
                                                    class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold !leading-[100%]">
                                                    <?php echo $home_page_faq_groups[0]["title"] ?>
                                                </h2>
                                                <p class="text-base font-bold leading-[145%]">
                                                    <?php echo $home_page_faq_groups[0]["textarea"] ?>
                                                </p>
                                            </div>
                                        </div>

                                        <!-- Right site -->
                                        <div
                                            class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                            <div class="">
                                                <img class="w-[227px] mx-auto"
                                                    src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                    alt="wpLogo" />
                                            </div>
                                            <div class="relative">
                                                <div class="absolute bottom-3 left-10 text-[13px] font-normal !leading-[120%]">
                                                    <a href=""
                                                        class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                        <img class="w-6 h-6"
                                                            src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                            alt="" />
                                                        <span>AI Suggestions</span>
                                                    </a>
                                                </div>
                                                <img class="aspect-[2.347] object-contain"
                                                    src="<?php echo $home_page_faq_groups[1]["image"] ?>"
                                                    alt="Frame-2" />
                                            </div>
                                            <div class="space-y-6">
                                                <h2
                                                    class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold !leading-[100%]">
                                                    <?php echo $home_page_faq_groups[1]["title"] ?>
                                                </h2>
                                                <p class="text-base font-bold leading-[145%]">
                                                    <?php echo $home_page_faq_groups[1]["textarea"] ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>