<a href="<?= esc_url(get_permalink($post_id)); ?>"
    class="group/card relative w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 xl:w-[calc(33.333333%-32px)] xl:m-4">

    <!-- <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]">
    </div> -->

    <div class="absolute top-3 right-3 h-8 w-8 min-w-8 flex items-center justify-center bg-black rounded-full">
        <img src="<?= esc_url(asset_image_path_generator() . '/angleUp.svg'); ?>" alt="icon"
            class="w-[10.67px] h-[10.37px] object-contain object-center" />
    </div>

    <div class="pt-[50px] flex flex-col justify-between space-y-4 lg:space-y-8 px-3 lg:px-6 py-8
                        text-black text-center text-base !leading-[120%] font-bold
                        bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">

        <!-- Icons -->
        <div class="flex justify-between max-w-[240px] mx-auto space-x-1 lg:space-x-3">
            <?php foreach ($icons_related as $single_icon): ?>
                <div class="w-[46px] min-w-[46px] h-[46px]
                                   sm:w-14 sm:min-w-14 sm:h-14
                                   lg:w-[72px] lg:min-w-[72px] lg:h-[72px]
                                   mx-auto
                                   bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)]
                                   rounded-xl lg:rounded-3xl
                                   flex items-center justify-center">

                    <img class="w-10 min-w-10 h-10
                                        sm:w-12 sm:min-w-12 sm:h-12
                                        lg:w-[65px] lg:min-w-[65px] lg:h-[65px]
                                        object-contain object-center
                                        rounded-xl sm:rounded-3xl" src="<?= esc_url($single_icon); ?>" alt="" />
                </div>
            <?php endforeach; ?>
        </div>

        <div class="h-px w-full self-stretch bg-[#F2F2F2]"></div>

        <!-- Title -->
        <div class="space-y-2 flex-grow">
            <p class="text-base !leading-[160%]">
                <?= esc_html(get_the_title()); ?>
            </p>
        </div>

    </div>
</a>