<?php
class AJAX_front_end_callback
{
    public static function load_plugin_modal_metric_modal_front_end()
    {
        global $wpdb;

        // Get allowed numeric fields
        $numeric_fields = array_values(Helpers::metric_information_attributes_mapping_db_keys());
        $numeric_fields[] = "overall_wpscore";
        $numeric_fields[] = "plugin_icon";
        // Build field list safely
        $fields_sql = implode(',', array_map('sanitize_key', $numeric_fields));

        // Table name
        $table = $wpdb->prefix . 'plugins_core_information'; // <-- change this

        // Sanitize plugin_id
        $plugin_id = isset($_POST['plugin_id']) ? intval($_POST['plugin_id']) : 0;

        // Query
        $metrice_data = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT $fields_sql FROM $table WHERE wp_post_id = %d",
                $plugin_id
            ),
            ARRAY_A
        );
        $metric_information_groups = Helpers::metric_information_groups();
        $attributes = Helpers::metric_information_attributes();
        $saved_rows = get_option('plugin_metric_settings', []);
        $metric_information_attributes_mapping_db_keys = Helpers::metric_information_attributes_mapping_db_keys();
        $metric_information_groups_image_icon = Helpers::metric_information_groups_image_icon();

        $template = get_template_directory() . '/frontend/single-plugin-includes/plugin-modal.php';

        if (file_exists($template)) {
            include $template;
        }
        exit;
    }
    public static function load_more_plugins()
    {
        $category_ids_array     = !empty($_POST['category_ids']) ? explode(',', $_POST['category_ids']) : [];
        $selected_tag_ids_array = !empty($_POST['tag_ids']) ? explode(',', $_POST['tag_ids']) : [];

        $rating                = $_POST['rating'] ?? '';
        $overall_wpscore        = $_POST['overall_wpscore'] ?? '';
        $last_update            = $_POST['last_update'] ?? '';
        $active_install         = $_POST['active_install'] ?? '';
        $support_quality        = $_POST['support_quality'] ?? '';
        $performace_impact      = $_POST['performace_impact'] ?? '';
        $user_review_sentiment  = $_POST['user_review_sentiment'] ?? '';
        $multilingual_support   = $_POST['multilingual_support'] ?? '';

        $page_category_id = $_POST['page_category_id'] ?? '';
        $search_text      = $_POST['search_text'] ?? '';
        $sort_by          = $_POST['sort_by'] ?? '';
        $offset           = intval($_POST['offset'] ?? 0);

        //$taxonomy_ids = array_merge($category_ids_array, $selected_tag_ids_array);
        $taxonomy_ids = $category_ids_array;
        $taxonomy_ids[] = $page_category_id;

        $filter_from_query_param = [];
        $fuzzy_post_ids          = $_POST['fuzzy_post_ids'] ?? '';
        $primary_order_post_ids  = [];

        /* ---------------- Filters ---------------- */

        if ($rating) {
            $map = Helpers::rating_filter_mapping($rating);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($overall_wpscore) {
            $map = Helpers::wps_score_filter_mapping($overall_wpscore);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($last_update) {
            $map = Helpers::last_updated_plugin_mapping($last_update);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($active_install) {
            $map = Helpers::active_installation_plugin_mapping($active_install);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($support_quality) {
            $map = Helpers::support_quality_plugin_mapping($support_quality);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($performace_impact) {
            $map = Helpers::performace_impact_plugin_mapping($performace_impact);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($user_review_sentiment) {
            $map = Helpers::user_review_sentiment_plugin_mapping($user_review_sentiment);
            if ($map) $filter_from_query_param[] = $map;
        }

        if ($multilingual_support) {
            $map = Helpers::multilingual_support_plugin_mapping($multilingual_support);
            if ($map) $filter_from_query_param[] = $map;
        }

        /* ---------------- Fuzzy ---------------- */

        if ($search_text && $fuzzy_post_ids) {
            $post_id_from_fuzzy = explode(',', $fuzzy_post_ids);

            if (!empty($post_id_from_fuzzy)) {
                $primary_order_post_ids = array_values(array_unique($post_id_from_fuzzy));
                $filter_from_query_param[] = [
                    'field'    => 'wp_post_id',
                    'operator' => 'in',
                    'value'    => $primary_order_post_ids,
                ];
            }
        }

        /* ---------------- Sorting ---------------- */

        $order_by = [
            ['field' => 'overall_wpscore', 'direction' => 'desc'],
        ];

        if ($sort_by) {
            $sort_by_meta = Helpers::sort_by_key_mapping($sort_by);
            $order_by[] = [
                'field'     => $sort_by_meta['field'],
                'direction' => $sort_by_meta['direction'],
            ];
            $order_by = array_reverse($order_by);
        }

        /* ---------------- Category cleanup ---------------- */

        if (!empty($category_ids_array)) {
            $taxonomy_ids = array_values(
                array_filter($taxonomy_ids, fn($v) => $v !== $page_category_id)
            );
        }

        /* ---------------- Query ---------------- */

        $overall_wpscore_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter(
            $taxonomy_ids,
            limit_plugin_show,
            $offset,
            $filter_from_query_param,
            $order_by,
            'is_sponsored',
            1,
            $primary_order_post_ids,
            $selected_tag_ids_array
        );

        /* ---------------- Render ---------------- */

        if (!empty($overall_wpscore_plugin)) {
            $template = get_template_directory() . '/frontend/content-single-plugin.php';

            if (file_exists($template)) {
                foreach ($overall_wpscore_plugin as $plugin) {
                    $single_plugin = $plugin;
                    include $template;
                }
            }
        }

        wp_die();
    }

    public static function load_more_plugins_fuzzy()
    {
        $category_ids_array = $_POST['category_ids'] ? explode(',', $_POST['category_ids']) : [];
        $selected_tag_ids_array = !empty($_POST['tag_ids']) ? explode(',', $_POST['tag_ids']) : [];
        $rating = $_POST['rating'] ?? '';
        $overall_wpscore = $_POST['overall_wpscore'] ?? '';
        $last_update = $_POST['last_update'] ?? '';
        $active_install = $_POST['active_install'] ?? '';
        $support_quality = $_POST['support_quality'] ?? '';
        $performace_impact = $_POST['performace_impact'] ?? '';
        $user_review_sentiment = $_POST['user_review_sentiment'] ?? '';
        $multilingual_support = $_POST['multilingual_support'] ?? '';
        $sort_by = $_POST['sort_by'] ?? '';
        $taxonomy_ids = $category_ids_array;
        $filter_from_query_param = [];
        if ($rating) {
            $filter_by_rating = Helpers::rating_filter_mapping($rating);
            if (!empty($filter_by_rating)) {
                $filter_from_query_param[] = $filter_by_rating;
            }
        }
        if ($overall_wpscore) {
            $filter_by_overall_wpscore = Helpers::wps_score_filter_mapping($overall_wpscore);
            if (!empty($filter_by_overall_wpscore)) {
                $filter_from_query_param[] = $filter_by_overall_wpscore;
            }
        }
        if ($last_update) {
            $filter_by_last_update = Helpers::last_updated_plugin_mapping($last_update);
            if (!empty($filter_by_last_update)) {
                $filter_from_query_param[] = $filter_by_last_update;
            }
        }
        if ($active_install) {
            $filter_by_active_install = Helpers::active_installation_plugin_mapping($active_install);
            if (!empty($filter_by_active_install)) {
                $filter_from_query_param[] = $filter_by_active_install;
            }
        }
        if ($support_quality) {
            $filter_by_support_quality = Helpers::support_quality_plugin_mapping($support_quality);
            if (!empty($filter_by_support_quality)) {
                $filter_from_query_param[] = $filter_by_support_quality;
            }
        }
        if ($performace_impact) {
            $filter_by_performace_impact = Helpers::performace_impact_plugin_mapping($performace_impact);
            if (!empty($filter_by_performace_impact)) {
                $filter_from_query_param[] = $filter_by_performace_impact;
            }
        }
        if ($user_review_sentiment) {
            $filter_by_user_review_sentiment = Helpers::user_review_sentiment_plugin_mapping($user_review_sentiment);
            if (!empty($filter_by_user_review_sentiment)) {
                $filter_from_query_param[] = $filter_by_user_review_sentiment;
            }
        }
        if ($multilingual_support) {
            $filter_by_multilingual_support = Helpers::multilingual_support_plugin_mapping($multilingual_support);
            if (!empty($filter_by_multilingual_support)) {
                $filter_from_query_param[] = $filter_by_multilingual_support;
            }
        }
        $post_id_from_fuzzy = explode(',', $_POST['fuzzy_post_ids']);
        $primary_order_post_ids = [];
        if (!empty($post_id_from_fuzzy)) {
            $primary_order_post_ids = array_values(array_unique($post_id_from_fuzzy));
            $filter_from_query_param[] = [
                'field' => 'wp_post_id',
                'operator' => 'in',
                'value' => $primary_order_post_ids,
            ];
        }
        $order_by = [
            ['field' => 'overall_wpscore', 'direction' => 'desc'],
        ];
        if ($sort_by) {
            $sort_by_meta = Helpers::sort_by_key_mapping($sort_by);
            $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
            $order_by = array_reverse($order_by);
        }
        $overall_wpscore_plugin = plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, limit_plugin_show, $_POST['offset'], $filter_from_query_param, $order_by, 'is_sponsored', 1, $primary_order_post_ids,$selected_tag_ids_array);
        if (!empty($overall_wpscore_plugin)) {

            foreach ($overall_wpscore_plugin as $plugin) {
                $single_plugin = $plugin; // rename variable for clarity
                $template = get_template_directory() . '/frontend/content-single-plugin.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
        }
        wp_die(); // important for AJAX
    }
    public static function get_plugin_category_suggestions()
    {

        $category_raw = sanitize_text_field($_POST['category'] ?? '');

        if (!$category_raw) {
            wp_send_json([]);
        }

        // Normalize input string
        $needle = strtolower(html_entity_decode($category_raw));

        $json_path = get_template_directory() . '/plugins-suggestions.json';

        if (!file_exists($json_path)) {
            wp_send_json([]);
        }

        $data = json_decode(file_get_contents($json_path), true);
        $results = [];

        foreach ($data as $item) {

            // Normalize JSON fields
            $title = strtolower(html_entity_decode($item['title']));
            $text = strtolower(html_entity_decode($item['text']));

            // ✅ SIMPLE STRING MATCH
            if (
                strpos($title, $needle) !== false ||
                strpos($text, $needle) !== false
            ) {
                $results[] = $item;
            }
        }

        wp_send_json($results);
    }

    public static function load_more_comparison_plugins()
    {
        $category_ids = isset($_POST['category_ids']) && $_POST['category_ids'] !== ''
            ? array_map('intval', explode(',', $_POST['category_ids']))
            : [];

        $search_text = isset($_POST['search_text'])
            ? sanitize_text_field($_POST['search_text'])
            : '';

        $offset = isset($_POST['offset']) ? (int) $_POST['offset'] : 0;

        $args = [
            'post_type' => 'plugin_comparison',
            'posts_per_page' => limit_plugin_show,      // ✅ LIMIT
            'offset' => $offset, // ✅ OFFSET
            'post_status' => 'publish',
            'no_found_rows' => true,   // ✅ better performance for AJAX
        ];

        // 🔎 Search text
        if ($search_text !== '') {
            $args['s'] = $search_text;
        }

        // 📂 Category filter (taxonomy)
        if (!empty($category_ids)) {
            $args['tax_query'] = [
                [
                    'taxonomy' => 'comparison_category',
                    'field' => 'term_id',
                    'terms' => $category_ids,
                    'operator' => 'IN',
                ],
            ];
        }

        // Run query
        $query = new WP_Query($args);
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();


                $post_id = get_the_ID();

                // Get icons
                $icons_csv_related = get_post_meta($post_id, '_comparison_plugin_icons', true);
                $icons_related = array_filter(array_map('trim', explode(',', (string) $icons_csv_related)));
                $template = get_template_directory() . '/frontend/content-single-plugin-comparison.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
            wp_reset_postdata();
        }
        wp_die();
    }
}
