document.addEventListener("DOMContentLoaded", function () {
  // -----------------------------
  // 🟦 Mobile menu open and close
  // -----------------------------
  const menuBtn = document.getElementById("mobileMenuBtn");
  const sidebar = document.getElementById("mobileSidebar");
  const closeBtn = document.getElementById("closeSidebar");
  const overlay = document.getElementById("overlay");

  if (menuBtn && sidebar && overlay) {
    function openSidebar() {
      sidebar.classList.remove("translate-x-full");
      overlay.classList.remove("hidden");
      setTimeout(() => (overlay.style.opacity = "1"), 10);
      document.body.style.overflow = "hidden";
    }

    function closeSidebar() {
      sidebar.classList.add("translate-x-full");
      overlay.style.opacity = "0";
      setTimeout(() => overlay.classList.add("hidden"), 500);
      document.body.style.overflow = "";
    }

    menuBtn.addEventListener("click", openSidebar);
    closeBtn?.addEventListener("click", closeSidebar);
    overlay.addEventListener("click", closeSidebar);

    // Submenu toggle
    document.querySelectorAll("[data-toggle='submenu']").forEach((btn) => {
      btn.addEventListener("click", () => {
        const submenu = btn.nextElementSibling;
        const arrow = btn.querySelector("svg");

        document
          .querySelectorAll("[data-toggle='submenu']")
          .forEach((other) => {
            if (other !== btn) {
              const otherSubmenu = other.nextElementSibling;
              const otherArrow = other.querySelector("svg");
              otherSubmenu?.classList.add("hidden");
              otherArrow?.classList.remove("rotate-180");
            }
          });

        submenu?.classList.toggle("hidden");
        arrow?.classList.toggle("rotate-180");
      });
    });

    // Auto-close sidebar on resize ≥ 1024px
    window.addEventListener("resize", () => {
      if (window.innerWidth >= 1024) {
        if (!sidebar.classList.contains("translate-x-full")) {
          closeSidebar();
        }
      }
    });
  } else {
    console.warn("⚠️ Mobile menu elements missing:", {
      menuBtn,
      sidebar,
      overlay,
    });
  }

  // ---------------------------------------------
  // 🟩 Slider 2 Top : Everyone was happy section
  // ---------------------------------------------
  const allWrappers = document.querySelectorAll(".slider-wrapper");
  if (allWrappers.length > 0) {
    allWrappers.forEach((wrapper) => {
      const track = wrapper.querySelector(".slider-track");
      if (!track) {
        console.warn("⚠️ Missing .slider-track inside wrapper:", wrapper);
        return;
      }

      let paused = false;
      let speed = 0.7;
      let position = 0;

      function ensureClones() {
        const wrapperWidth = wrapper.offsetWidth;
        let totalWidth = track.scrollWidth;
        while (totalWidth < wrapperWidth * 2) {
          track.innerHTML += track.innerHTML;
          totalWidth = track.scrollWidth;
        }
      }

      ensureClones();

      function animate() {
        if (!paused) {
          position -= speed;
          if (Math.abs(position) >= track.scrollWidth / 2) position = 0;
          track.style.transform = `translateX(${position}px)`;
        }
        requestAnimationFrame(animate);
      }

      wrapper.addEventListener("mouseenter", () => (paused = true));
      wrapper.addEventListener("mouseleave", () => (paused = false));

      window.addEventListener("resize", () => {
        position = 0;
        track.style.transform = "";
        const allSlides = track.querySelectorAll(".slide");
        const unique = Array.from(allSlides)
          .slice(0, allSlides.length / 2)
          .map((s) => s.outerHTML)
          .join("");
        track.innerHTML = unique;
        ensureClones();
      });

      animate();
    });
  } else {
    console.warn("⚠️ No .slider-wrapper elements found on this page.");
  }
});

// ------------------------------------------------------------
// 📱 Mobile menu open & close
// ------------------------------------------------------------
jQuery(function ($) {
  var $menuBtn = $("#mobileMenuBtn");
  var $menuIcon = $("#menuIcon");
  var $closeIcon = $("#closeIcon");
  var $drawer = $("#topDrawer");
  var $overlay = $("#menuOverlay");

  var $pluginCategoryBtn = $("#pluginCategoryBtn");
  var $mobileSubmenu = $("#mobileSubmenu");
  var $submenuBackBtn = $("#submenuBackBtn");
  var $mobileMenuMain = $("#mobileMenuMain");

  var menuOpen = false;
  var submenuOpen = false;

  function openMenu() {
    $drawer
      .removeClass("-translate-y-full")
      .addClass("translate-y-0 mobileDrawerOpen");

    $menuIcon.addClass("hidden");
    $closeIcon.removeClass("hidden");

    $overlay.removeClass("pointer-events-none").addClass("opacity-100");

    $("body").addClass("overflow-hidden");
    menuOpen = true;
  }

  function closeMenu() {
    $drawer
      .addClass("-translate-y-full")
      .removeClass("translate-y-0 mobileDrawerOpen");

    $menuIcon.removeClass("hidden");
    $closeIcon.addClass("hidden");

    $overlay.addClass("pointer-events-none").removeClass("opacity-100");

    $("body").removeClass("overflow-hidden");
    menuOpen = false;

    setTimeout(function () {
      closeSubmenu(true);
    }, 300);
  }

  function openSubmenu() {
    $mobileMenuMain.addClass("invisible pointer-events-none");

    $mobileSubmenu
      .removeClass("pointer-events-none -translate-y-full opacity-0")
      .addClass("translate-y-0 opacity-100");

    submenuOpen = true;
  }

  function closeSubmenu(instant = false) {
    if (instant) {
      $mobileSubmenu
        .addClass("-translate-y-full opacity-0 pointer-events-none")
        .removeClass("translate-y-0 opacity-100");

      $mobileMenuMain.removeClass("invisible pointer-events-none");
      submenuOpen = false;
      return;
    }

    $mobileSubmenu
      .removeClass("translate-y-0 opacity-100")
      .addClass("-translate-y-full opacity-0");

    setTimeout(function () {
      $mobileMenuMain.removeClass("invisible pointer-events-none");
      $mobileSubmenu.addClass("pointer-events-none");
      submenuOpen = false;
    }, 300);
  }

  // Plugin Category open/close
  $pluginCategoryBtn.on("click", function (e) {
    e.preventDefault();
    if (!submenuOpen) openSubmenu();
    else closeSubmenu();
  });

  // Submenu back button
  $submenuBackBtn.on("click", function (e) {
    e.preventDefault();
    if (submenuOpen) closeSubmenu();
  });

  // Main menu button
  $menuBtn.on("click", function () {
    if (!menuOpen) openMenu();
    else closeMenu();
  });

  // Overlay click closes menu
  $overlay.on("click", closeMenu);

  // Resize event
  $(window).on("resize", function () {
    if ($(window).width() >= 1024 && menuOpen) {
      closeMenu();
    }
  });

  // Init: ensure submenu hidden
  $mobileSubmenu.addClass("-translate-y-full opacity-0 pointer-events-none");
});

// ------------------------------------------------------------
// Footer Mobile Accordion js Start
// ------------------------------------------------------------
jQuery(function ($) {
  $(".accordionFooter").on("click", function () {
    if ($(window).width() >= 1024) return;

    let content = $(this).next(".accordionContentFooter");
    let icon = $(this).find("span");
    let isOpen =
      content.css("max-height") !== "0px" &&
      content.css("max-height") !== "none";

    // Close others
    $(".accordionContentFooter").not(content).css("max-height", "0");

    // Reset icons of others
    $(".accordionFooter span").not(icon).text("+").removeClass("active");

    // Toggle current
    if (isOpen) {
      content.css("max-height", "0");
      icon.text("+").removeClass("active");
    } else {
      content.css("max-height", content[0].scrollHeight + "px");
      icon.text("–").addClass("active");
    }
  });
});
///Menu end

jQuery(function ($) {
  $(document).on("click",".openModalBtn", function (event) {
    event.preventDefault();

    let pluginID = $(this).data("plugin_id");

    $.ajax({
      url: wpsearch_ajax.ajax_url, // WordPress automatically provides this in admin OR enqueue manually on frontend
      type: "POST",
      data: {
        action: "load_plugin_modal_metric_modal_front_end",
        plugin_id: pluginID,
      },
      success: function (response) {
        // demo output
        $("#infoModal").html(response);
        $("#infoModal").removeClass("hidden");
        $("body").addClass("overflow-hidden");
        const ratingButtons = document.querySelectorAll(
          "#infoModal .customAccordionToggle"
        );
        ratingButtons.forEach((btn) => {
          const content = btn.nextElementSibling;
          const icon = btn.querySelector("svg");
          if (!content || !icon) return;

          btn.addEventListener("click", () => {
            content.classList.toggle("hidden");
            icon.classList.toggle("rotate-[-90deg]");
          });
        });
        $("#closeModalBtnWPSScore").on("click", function () {
          $("#infoModal").addClass("hidden");
          $("body").removeClass("overflow-hidden");
        });
        // OR inject into modal:
        // $("#myModal .modal-body").html(response).show();
      },
      error: function () {
        alert("AJAX error!");
      },
    });
  });
});
