<?php
global $wpdb;

/**
 * Table definitions
 */
$cron_scraped_plugins_log_table = $wpdb->prefix . 'cron_scraped_plugins_log';
$cron_page_visits_table         = $wpdb->prefix . 'cron_page_visits_log';
$plugins_core_information_table = $wpdb->prefix . 'plugins_core_information';

/**
 * ----------------------------------------------
 * HANDLE FORM SUBMISSION
 * ----------------------------------------------
 */
if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    !empty($_POST['scrap_field']) &&
    isset($_POST['scrap_value'])
) {

    $field = sanitize_text_field($_POST['scrap_field']);
    $value = intval($_POST['scrap_value']);

    /**
     * Allowed columns (strict whitelist)
     */
    $allowed_fields = [
        'api_scrapped',
        'scrapped',
        'visited',
        'is_wps_score_field_set',
        'is_wps_score_calculated',
        'is_wps_metric_group_done', // NEW
    ];

    if (!in_array($field, $allowed_fields, true)) {
        echo '<p style="color:red;">Invalid field selected.</p></div>';
        return;
    }

    /**
     * Route update to correct table
     */
    if ($field === 'visited') {

        // cron_page_visits_log
        $sql = $wpdb->prepare(
            "UPDATE `{$cron_page_visits_table}` 
             SET `visited` = %d 
             WHERE 1",
            $value
        );
        $wpdb->query($sql);

    } elseif ($field === 'is_wps_metric_group_done') {

        // wp_plugins_core_information
        $sql = $wpdb->prepare(
            "UPDATE `{$plugins_core_information_table}` 
             SET `is_wps_metric_group_done` = %d 
             WHERE 1",
            $value
        );
        $wpdb->query($sql);

    } else {

        // cron_scraped_plugins_log
        $sql = $wpdb->prepare(
            "UPDATE `{$cron_scraped_plugins_log_table}` 
             SET `{$field}` = %d 
             WHERE 1",
            $value
        );
        $wpdb->query($sql);
    }

    echo '<p style="color:green;">Flag updated successfully!</p>';
}
?>

<!-- ----------------------------------------------
     DISPLAY FORM
---------------------------------------------- -->

<form method="POST" style="margin-top:20px; background:#fff; padding:20px; border-radius:6px; max-width:480px;">

    <h2>Select Field to Update</h2>

    <label><strong>Choose Column:</strong></label><br>
    <select name="scrap_field" required style="width:100%; margin-top:5px; margin-bottom:15px;">
        <option value="">-- Select Field --</option>

        <option value="api_scrapped">
            API Scraped Flag (cron_scraped_plugins_log)
        </option>

        <option value="scrapped">
            Scraped Flag (cron_scraped_plugins_log)
        </option>

        <option value="is_wps_score_field_set">
            WPS Score Field Set (cron_scraped_plugins_log)
        </option>

        <option value="is_wps_score_calculated">
            WPS Score Calculated (cron_scraped_plugins_log)
        </option>

        <option value="visited">
            Visited Flag (cron_page_visits_log)
        </option>

        <option value="is_wps_metric_group_done">
            WPS Metric Group Done (wp_plugins_core_information)
        </option>
    </select>

    <label><strong>Set Value:</strong></label><br>
    <select name="scrap_value" required style="width:100%; margin-top:5px; margin-bottom:20px;">
        <option value="">-- Select Status --</option>
        <option value="0">0 = Undone</option>
        <option value="1">1 = Done</option>
    </select>

    <button type="submit" class="button button-primary">
        Update Flag
    </button>

</form>

</div>
