<?php
$command = get_option('gemini_command_data_for_getting_meta');

?>
<div class="wrap">
    <h1 style="margin-bottom:10px;">WP Plugin JSON Template</h1>

    <form id="jsonForm" method="post" style="max-width:900px;">

        <!-- Plugin Meta Information FIELD -->
        <table class="form-table">
            <tr>
                <th scope="row"><label for="message1">Plugin Meta Information</label></th>
                <td>
                    <textarea id="message1" rows="14"
                        style="width:100%;font-family:monospace;background:#0b1620;color:#cbeef7;padding:16px;border-radius:6px;">
                     <?php echo $command['message_1'] ? $command['message_1'] : "" ?>
                    </textarea>
                    <button type="button" id="copyMessage1" class="button" style="margin-top:8px;">Copy Plugin Meta Information</button>
                </td>
            </tr>

            <!-- Generate Comparable Row of Plugins FIELD -->
            <tr>
                <th scope="row"><label for="message2">Generate Comparable Row of Plugins</label></th>
                <td>
                    <textarea id="message2" rows="14"
                        style="width:100%;font-family:monospace;background:#0b1620;color:#cbeef7;padding:16px;border-radius:6px;">
 <?php echo $command['message_2'] ? $command['message_2'] : "" ?>
                    </textarea>
                    <button type="button" id="copyMessage2" class="button" style="margin-top:8px;">Copy Generate Comparable Row of Plugins</button>
                </td>
            </tr>
        </table>

        <p style="display:flex;gap:10px;margin-top:18px;">
            <button id="submitBtn" type="submit" class="button button-primary" style="margin-left:auto;">Save via
                AJAX</button>
        </p>

        <div id="ajaxResponse" style="margin-top:15px;font-weight:bold;"></div>
    </form>
</div>

<script>
    (function ($) {

        const msg1 = $('#message1');
        const msg2 = $('#message2');

        const copy1 = $('#copyMessage1');
        const copy2 = $('#copyMessage2');

        const jsonForm = $('#jsonForm');
        const ajaxResponse = $('#ajaxResponse');

        // --- COPY Plugin Meta Information ---
        copy1.on('click', async () => {
            const text = msg1.val().trim();
            if (!text) return;

            try {
                await navigator.clipboard.writeText(text);
                copy1.text('Copied!');
            } catch (err) {
                msg1.select();
                document.execCommand('copy');
                copy1.text('Copied!');
            }

            setTimeout(() => copy1.text('Copy Plugin Meta Information'), 1500);
        });

        // --- COPY Generate Comparable Row of Plugins ---
        copy2.on('click', async () => {
            const text = msg2.val().trim();
            if (!text) return;

            try {
                await navigator.clipboard.writeText(text);
                copy2.text('Copied!');
            } catch (err) {
                msg2.select();
                document.execCommand('copy');
                copy2.text('Copied!');
            }

            setTimeout(() => copy2.text('Copy Generate Comparable Row of Plugins'), 1500);
        });

        // --- AJAX SAVE BOTH FIELDS ---
        jsonForm.on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'save_command_data_for_meta',
                    message_1: msg1.val().trim(),
                    message_2: msg2.val().trim()
                },
                success: function () {
                    ajaxResponse.css('color', '#008000').text('Saved Successfully!');
                },
                error: function () {
                    ajaxResponse.css('color', '#cc0000').text('Error saving data.');
                }
            });
        });

    })(jQuery);
</script>