<?php
// global $wpdb;
// $table_cron_page_visits = $wpdb->prefix . "cron_page_visits_log";
// $table_cron_scraped_plugins = $wpdb->prefix . "cron_scraped_plugins_log";
// $tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";

// $latest_last_visited_from_cron_page_visits_log = $wpdb->get_var(
//     "SELECT last_visited_at FROM {$table_cron_page_visits} ORDER BY last_visited_at DESC LIMIT 1"
// );

// $latest_last_scraped_at_from_cron_scraped_plugins_log = $wpdb->get_var(
//     "SELECT last_scraped_at FROM {$table_cron_scraped_plugins} ORDER BY last_scraped_at DESC LIMIT 1"
// );


?>
<style>
    /* Cron Job List – Full Screen Layout */
    .wrap {
        font-family: "Open Sans", Arial, sans-serif;
        width: 100%;
        max-width: none;
        /* 🔥 remove fixed width */
        margin: 20px 0;
        padding: 0;
    }

    /* Page title */
    .wrap h1 {
        margin: 0 0 25px 0;
        font-size: 24px;
        color: #23282d;
    }

    /* Table base */
    .wrap table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        border: 1px solid #ccd0d4;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    }

    /* Header */
    .wrap table thead {
        background: #f6f7f7;
    }

    .wrap table thead th {
        text-align: left;
        padding: 14px 16px;
        font-weight: 600;
        color: #23282d;
        border-bottom: 1px solid #ccd0d4;
        white-space: nowrap;
    }

    /* Table body rows */
    .wrap table tbody tr:nth-child(even) {
        background-color: #fbfbfb;
    }

    .wrap table tbody td,
    .wrap table tbody th {
        padding: 14px 16px;
        font-weight: 400;
        border-bottom: 1px solid #eee;
        vertical-align: middle;
    }

    /* Links */
    .wrap table a {
        color: #2271b1;
        text-decoration: none;
        font-weight: 500;
    }

    .wrap table a:hover {
        color: #135e96;
        text-decoration: underline;
    }

    /* "Run Now" button style */
    .wrap table tbody a {
        display: inline-block;
        background: #2271b1;
        color: #fff;
        padding: 7px 14px;
        border-radius: 4px;
        font-weight: 500;
        text-decoration: none;
        transition: background 0.2s ease;
    }

    .wrap table tbody a:hover {
        background: #135e96;
    }

    /* Improve readability on large screens */
    @media (min-width: 1400px) {

        .wrap table thead th,
        .wrap table tbody td,
        .wrap table tbody th {
            padding: 16px 20px;
            font-size: 14px;
        }
    }
</style>
<div class="wrap">
    <h1>Cron Job List</h1>

    <table class="widefat fixed striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Job Purpose</th>
                <th>Job Manual Link</th>
                <th>Job Last Run</th>
            </tr>
        </thead>

        <tbody>
            <?php
            $base_path = '/cron-management/';

            $cron_jobs = [
                [
                    'title'  => 'Update the plugin Active installation Work in Chunk data',
                    'file'   => 'wp-active-installation-count-json-chunk.php',
                    'option' => 'wp_active_install_short_des_chunk_job_last_run',
                ],
                [
                    'title'  => 'Checking Cron Flag, Update the Flag, Ensure every plugin Run Once in 7 days',
                    'file'   => 'wp-manage-scrapp-flag.php',
                    'option' => 'reset_cron_flag_job_run',
                ],
                [
                    'title'  => 'API scrapp and Web Scrapp Every Single Plugin',
                    'file'   => 'wp-plugin-directory-single-plugin-api-call.php',
                    'option' => 'wp_plugin_directory_single_plugin_api_call_job_last_run',
                ],
                [
                    'title'  => 'Update Plugin Last update day count and Age of the plugin',
                    'file'   => 'wp-plugin-age-calculation-job.php',
                    'option' => 'wp_plugin_age_calculation_job_last_run',
                ],
                [
                    'title'  => 'Update Plugin Package Size in KB plugin',
                    'file'   => 'wp-plugin-size-getting-job.php',
                    'option' => 'wp_plugin_size_getting_job_last_run',
                ],
                [
                    'title'  => 'Missing Feature Image',
                    'file'   => 'wp-plugin-missing-feature-image.php',
                    'option' => 'wp_plugin_missing_feature_image_last_run',
                ],
                [
                    'title'  => 'Generate AI description',
                    'file'   => 'wp-plugin-ai-description.php',
                    'option' => 'wp_plugin_ai_description_job_last_run',
                ],
                [
                    'title'  => 'WordPress Post Create',
                    'file'   => 'wp-generate-post.php',
                    'option' => 'wp_plugin_generate_post_last_run',
                ],
                [
                    'title'  => 'WordPress All Taxonomy Create from JSON',
                    'file'   => 'wp-create-taxonomy-from-json.php',
                    'option' => 'wp_create_taxonomy_from_json_last_run',
                ],
                [
                    'title'  => 'AI JSON category Saved to Option',
                    'file'   => 'import-json-cate-to-option-table.php',
                    'option' => 'pre_defined_ai_category_last_run',
                ],
                [
                    'title'  => 'Plugin Same Group Max Min Statistics',
                    'file'   => 'wp-create-same-group-plugin-metric-min-max.php',
                    'option' => 'create_same_group_plugin_metric_min_max_last_run',
                ],
                [
                    'title'  => 'WPS Score Field Set Job',
                    'file'   => 'wp-wps-score-field-set-job.php',
                    'option' => 'wps_score_field_set_job_last_run',
                ],
                [
                    'title'  => 'WPS Score Set Job',
                    'file'   => 'wp-wps-score-set-job.php',
                    'option' => 'wps_score_set_job_last_run',
                ],
                [
                    'title'  => 'AI Profile Meta for Plugin Recommendation',
                    'file'   => 'wp-ai-profile-generate.php',
                    'option' => 'wp_plugin_ai_profile_job_last_run',
                ],
                [
                    'title'  => 'Generate Plugin Comparison Data',
                    'file'   => 'wp-create-plugin-comparison.php',
                    'option' => 'wp_plugin_ai_comparison_job_last_run',
                ],
                [
                    'title'  => 'Generate Plugin Comparison Posts CPT(plugin_comparison)',
                    'file'   => 'wp-generate-comparison-plugins.php',
                    'option' => 'wp_comparison_plugin_create_job_last_run',
                ],
            ];

            $i = 1;
            foreach ($cron_jobs as $job) :
                $last_run = get_option($job['option']);
            ?>
                <tr>
                    <td><?php echo $i++; ?></td>

                    <td><?php echo esc_html($job['title']); ?></td>

                    <td>
                        <a target="_blank"
                            class="button button-secondary"
                            href="<?php echo esc_url(site_url($base_path . $job['file'])); ?>">
                            Run Now
                        </a>
                    </td>

                    <td>
                        <?php
                        echo $last_run
                            ? $last_run
                            : '<em>Never</em>';
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>