<!-- ✅ Bootstrap Modal -->
<div class="modal fade" id="editMetaFiled" tabindex="-1" aria-labelledby="editMetricLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" id="updateMetaForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="editMetricLabel">Edit Meta Field Information</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        <?php
                        // $numeric_fields = [
                        //     //'plugin_age_days',
                        //     'wps_installation_growth_score',
                        //     //'package_size_kb',
                        //     'wps_update_recency_score',
                        //     'wps_update_frequency_score',
                        //     'wps_compatibility_with_latest_wp_score',
                        //     'wps_support_responsiveness_score',
                        //     'wps_average_rating_score',
                        //     'wps_number_of_ratings_score',
                        //     'wps_maturity_score',
                        //     'wps_license_score',
                        //     'wps_has_lifetime_license_score',
                        //     'wps_performance_impact_score',
                        //     'wps_php_version_support_score',
                        //     'wps_multisite_support_score',
                        //     'wps_localization_languages_score',
                        //     'wps_developer_reputation_score',
                        //     'wps_documentation_quality_score',
                        //     'wps_youtube_tutorials_score',
                        //     'wps_community_page_score',
                        //     'overall_wpscore'
                        // ];
                        $select_fields = [

                            'license_type' => [
                                'free' => 'Free',
                                'freemium' => 'Freemium',
                                'paid' => 'Paid',
                                'unknown' => 'Unknown'
                            ],
                            'has_lifetime_license' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
                            'woocommerce_support' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
                            'has_agency_friendly_license' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
                            'is_multisite_support' => ['1' => 'Yes', '2' => 'No'],
                            'support_quality' => [
                                '1' => 'Excellent',
                                '2' => 'Good',
                                '3' => 'Fair',
                                '4' => 'Poor',
                            ],
                            'performance_impact' => [
                                '1' => 'Low',
                                '2' => 'Medium',
                                '3' => 'High',
                            ],
                            'user_review_sentiment' => [
                                '1' => 'Negative',
                                '2' => 'Neutral',
                                '3' => 'Positive',
                            ],
                            // 'seo_impact' => [
                            //     '1' => 'Positive',
                            //     '2' => 'Neutral',
                            //     '3' => 'Negative',
                            // ],
                            'is_sponsored' => [
                                '1' => 'Default',
                                '2' => 'Sponsored'
                            ],
                            'is_recreate_ai_post' => [
                                '0' => 'No',
                                '1' => 'Yes'
                            ],
                            'is_meta_information_from_ai_search' => [
                                '0' => 'No',
                                '1' => 'Yes'
                            ],
                            'is_wps_metric_group_done' => [
                                '0' => 'No',
                                '1' => 'Yes'
                            ],
                        ];
                        $text_fields = [
                            'best_youtube_tutorials_link',
                            'community_page_link',
                        ];
                        // foreach ($numeric_fields as $field) {
                        //     $value = esc_attr($plugin[$field] ?? '');
                        //     echo '
                        //         <div class="col-md-6">
                        //             <label class="form-label fw-semibold text-capitalize">' . str_replace('_', ' ', $field) . '</label>
                        //             <input type="number" step="any" name="' . esc_attr($field) . '" value="' . $value . '" class="form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '">
                        //         </div>';
                        // }
                        foreach ($text_fields as $field) {
                            $value = esc_attr($plugin[$field] ?? '');
                            echo '
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold text-capitalize">' . str_replace('_', ' ', $field) . '</label>
                                    <input type="text"  name="' . esc_attr($field) . '" value="' . $value . '" class="form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '">
                                </div>';
                        }
                        foreach ($select_fields as $field => $options) {
                            $current = $plugin[$field] ?? '';
                            echo '<div class="col-md-6">
                                    <label class="form-label fw-semibold text-capitalize">' . str_replace('_', ' ', $field) . '</label>
                                    <select name="' . esc_attr($field) . '" class="form-select">';
                            foreach ($options as $val => $label) {
                                printf('<option value="%s" %s>%s</option>', esc_attr($val), selected($current, $val, false), esc_html($label));
                            }
                            echo '</select></div>';
                        }

                        ?>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    (function ($) {
        $('#updateMetaForm').on('submit', function (e) {
            e.preventDefault();
            const formData = $(this).serialize() + '&action=update_plugin_meta&slug=<?php echo esc_js($slug); ?>';
            $.post(ajaxurl, formData, function (response) {
                if (response.success) {
                    alert('Meta updated successfully!');
                    location.reload();
                } else {
                    alert('Update failed: ' + response.data);
                }
            });
        });
    })(jQuery);
</script>
<?php
