<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<?php

    $parent_categories = get_plugin_parent_categories();

    $saved_rows_raw = get_option('plugin_comparison_map', []);
    $saved_rows     = [];
   // dd($saved_rows_raw); 
    foreach ($saved_rows_raw as $row) {

        $posts = [];

        foreach ($row['posts'] as $post_id) {
            $post = get_post($post_id);
            if ($post) {
                $posts[] = [
                    'id'   => $post_id,
                    'text' => str_replace(['&#8211;',' &amp;'], ['–','&'],$post->post_title), // ✅ required for Select2 preload
                ];
            }
        }

        $saved_rows[] = [
            'category_id' => (int) $row['category_id'],
            'posts'       => $posts,
        ];
    }
?>
<h1>Plugin Comparison Mapping</h1>
<div id="plugin-rows"></div>

<button type="button" id="add-row">➕ Add Row</button>
<button type="button" id="save-rows">💾 Save</button>

<script>
const SAVED_ROWS =                   <?php echo wp_json_encode($saved_rows); ?>;
const CATEGORIES =                   <?php
                       echo json_encode(array_map(fn($c) => [
                           'id'   => $c->term_id,
                           'text' => str_replace(
                    ['&#8211;','&amp;'], ['–','&'],
                    $c->name,
                ),
                   ], $parent_categories));
                   ?>;
</script>
<script>
jQuery(function ($) {

    function getSelectedPostIds() {
        let ids = [];
        $('.plugin-post-select').each(function () {
            ids.push(...($(this).val() || []));
        });
        return ids;
    }

    function createRow(data = {}) {

    let row = $(`
        <div class="plugin-row">
            <select class="plugin-category-select" style="width:30%"></select>
            <select class="plugin-post-select" multiple style="width:50%"></select>
            <button type="button" class="remove-row">✖</button>
        </div>
    `);

    $('#plugin-rows').append(row);

    // CATEGORY
    row.find('.plugin-category-select')
        .select2({ data: CATEGORIES })
        .val(data.category_id || null)
        .trigger('change');

    // POSTS
    let postSelect = row.find('.plugin-post-select').select2({
        maximumSelectionLength: 3
    });

    // 🔑 PRELOAD POSTS WITH TEXT
    if (data.posts) {
        data.posts.forEach(item => {
            let option = new Option(item.text, item.id, true, true);
            postSelect.append(option);
        });
        postSelect.trigger('change');
    }

    // CATEGORY CHANGE → AJAX LOAD
    row.find('.plugin-category-select').on('change', function () {

        let catId = $(this).val();

        postSelect.empty().trigger('change');

        if (!catId) return;

        $.post(ajaxurl, {
            action: 'get_posts_by_plugin_category',
            category_id: catId,
            exclude: getSelectedPostIds()
        }, function (res) {
            res.forEach(item => {
                postSelect.append(new Option(item.text, item.id, false, false));
            });
        });
    });

    row.find('.remove-row').on('click', () => row.remove());
}

    // PRELOAD SAVED ROWS
    if (SAVED_ROWS.length) {
        SAVED_ROWS.forEach(row => createRow(row));
    } else {
        createRow();
    }

    // ADD ROW
    $('#add-row').on('click', function () {
        createRow();
    });

    // SAVE
    $('#save-rows').on('click', function () {

        let rows = [];

        $('.plugin-row').each(function () {
            let cat = $(this).find('.plugin-category-select').val();
            let posts = $(this).find('.plugin-post-select').val();

            if (cat && posts?.length) {
                rows.push({
                    category_id: cat,
                    posts: posts
                });
            }
        });

        $.post(ajaxurl, {
            action: 'save_plugin_category_map',
            rows: rows
        }, function () {
            alert('Saved successfully');
        });
    });

});
</script>
