<style>
    /* Reset box-sizing for consistency */
    *,
    *::before,
    *::after {
        box-sizing: border-box;
    }

    /* Container with flex */
    .wpaisearch-row {
        display: flex;
        flex-wrap: wrap;
        margin-left: -0.5rem;
        margin-right: -0.5rem;
    }

    /* Base column styles */
    .wpaisearch-col-md-6,
    .wpaisearch-col-md-12 {
        padding-left: 0.5rem;
        padding-right: 0.5rem;
        width: 100%;
        box-sizing: border-box;
    }

    /* Medium screens and up - side by side */
    @media (min-width: 768px) {
        .wpaisearch-col-md-6 {
            width: 50%;
            max-width: 50%;
        }

        .wpaisearch-col-md-12 {
            width: 100%;
            max-width: 100%;
        }
    }

    /* Spacing */
    .wpaisearch-mb-3 {
        margin-bottom: 1rem;
    }

    .wpaisearch-g-3>* {
        margin-top: 1rem;
    }

    /* Form elements */
    .wpaisearch-form-label {
        margin-bottom: 0.5rem;
        display: block;
        font-weight: 600;
    }

    .wpaisearch-fw-semibold {
        font-weight: 600;
    }

    .wpaisearch-text-capitalize {
        text-transform: capitalize;
    }

    .wpaisearch-form-control,
    .wpaisearch-form-select {
        display: block;
        width: 100%;
        padding: 0.375rem 0.75rem;
        font-size: 1rem;
        font-weight: 400;
        line-height: 1.5;
        color: #212529;
        background-color: #fff;
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        box-sizing: border-box;
    }

    .wpaisearch-form-control:focus,
    .wpaisearch-form-select:focus {
        color: #212529;
        background-color: #fff;
        border-color: #86b7fe;
        outline: 0;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, .25);
    }

    .wpaisearch-form-control::placeholder {
        color: #6c757d;
        opacity: 1;
    }

    .wpaisearch-form-control:disabled,
    .wpaisearch-form-control[readonly] {
        background-color: #e9ecef;
        opacity: 1;
    }

    .wpaisearch-form-select {
        padding-right: 2.25rem;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
    }
    .textHeading {
        font-size: 30px !important;
        font-weight: 600 !important;
        margin-top: 20px !important;
        margin-bottom: 10px !important;
        padding: 0 !important;
    }
    .tableHeading {
        font-size: 16px;
        text-align: start;
        padding-bottom: 7px;
    }
    .tbodyContain .tbodyText {
        font-size: 16px;
        padding: 4px 6px;
    }
</style>
<?php
global $wpdb;
$table = $wpdb->prefix . 'plugins_core_information';
$plugin = $wpdb->get_row(
    $wpdb->prepare("SELECT * FROM $table WHERE wp_post_id = %d LIMIT 1", get_the_ID()),
    ARRAY_A
);

?>


<div class="wpaisearch-row wpaisearch-g-3">
    <?php
    $readonly_numeric = ["active_installs", "rating", "num_ratings", "support_threads", "support_threads_resolved", "plugin_age_days", "package_size_kb"];
    $numeric_fields = [
        //'plugin_age_days',
        'wps_installation_growth_score',
        //'package_size_kb',
        'wps_update_recency_score',
        'wps_update_frequency_score',
        'wps_compatibility_with_latest_wp_score',
        'wps_support_responsiveness_score',
        'wps_average_rating_score',
        'wps_number_of_ratings_score',
        'wps_maturity_score',
        'wps_license_score',
        'wps_has_lifetime_license_score',
        'wps_performance_impact_score',
        'wps_php_version_support_score',
        'wps_multisite_support_score',
        'wps_localization_languages_score',
        'wps_developer_reputation_score',
        'wps_documentation_quality_score',
        'wps_youtube_tutorials_score',
        'wps_community_page_score',
        'overall_wpscore'
    ];
    $select_fields = [

        'license_type' => [
            'free' => 'Free',
            'freemium' => 'Freemium',
            'paid' => 'Paid',
            'unknown' => 'Unknown'
        ],
        'has_lifetime_license' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
        'woocommerce_support' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
        'has_agency_friendly_license' => ['1' => 'Yes', '2' => 'No', '3' => 'Nothing'],
        'is_multisite_support' => ['1' => 'Yes', '2' => 'No'],
        'support_quality' => [
            '1' => 'Excellent',
            '2' => 'Good',
            '3' => 'Fair',
            '4' => 'Poor',
        ],
        'performance_impact' => [
            '1' => 'Low',
            '2' => 'Medium',
            '3' => 'High',
        ],
        'user_review_sentiment' => [
            '1' => 'Negative',
            '2' => 'Neutral',
            '3' => 'Positive',
        ],
        // 'seo_impact' => [
        //     '1' => 'Positive',
        //     '2' => 'Neutral',
        //     '3' => 'Negative',
        // ],
        'is_sponsored' => [
            '1' => 'Default',
            '2' => 'Sponsored'
        ],
        'is_recreate_ai_post' => [
            '0' => 'No',
            '1' => 'Yes'
        ],
        'is_meta_information_from_ai_search' => [
            '0' => 'No',
            '1' => 'Yes'
        ],
        'is_wps_metric_group_done' => [
            '0' => 'No',
            '1' => 'Yes'
        ],
    ];


    $plugin_icon = $plugin["plugin_icon"];
    $plugin_image = $plugin["plugin_feature_image"];
    $plugin_video = $plugin["plugin_video"];
    $plugin_author_name = $plugin["author_name"];
    $plugin_profile_url = $plugin["author_profile"];
    $plugin_tags = $plugin["plugin_tags"];
    $plugin_keywords = $plugin["plugin_feature_meta_key_word_ai"];

    $plugin_pro_version_link = $plugin["plugin_pro_version_link"];
    $plugin_docs_link = $plugin["plugin_docs_link"];
    $plugin_live_demo_link = $plugin["plugin_live_demo_link"];
    $plugin_downloaded = $plugin['downloaded'];
    $installation_growth = $plugin['installation_growth'];
    $best_youtube_tutorials_link = $plugin['best_youtube_tutorials_link'];
    $community_page_link = $plugin['community_page_link'];
    ?>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Icon</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_icon); ?>"
            placeholder="Image URL" readonly>
        <?php if ($plugin_icon): ?>
            <img src="<?php echo esc_url($plugin_icon); ?>"
                style="max-width:80px;margin-top:10px;border:1px solid #ddd;padding:4px;">
        <?php endif; ?>
    </div>

    <!-- Plugin Feature Image -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Image</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_image); ?>"
            placeholder="Image URL" readonly>
        <?php if ($plugin_image): ?>
            <img src="<?php echo esc_url($plugin_image); ?>"
                style="max-width:400px;margin-top:10px;border:1px solid #ddd;padding:4px;">
        <?php endif; ?>
    </div>

    <!-- Video -->
    <div class="wpaisearch-col-md-12 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Video (YouTube URL)</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_video); ?>"
            placeholder="YouTube URL" readonly>

        <?php if ($plugin_video):
            $yt_id = preg_replace('/^.*(youtu.be\/|v=)([^#\&\?]*).*/', '$2', $plugin_video);
            ?>
            <iframe style="width:100%;height:300px;border:1px solid #ddd;" src="<?php echo esc_url($plugin_video); ?>"
                allowfullscreen>
            </iframe>
        <?php endif; ?>
    </div>

    <!-- Ratings JSON -->
    <div class="wpaisearch-col-md-12 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Individual Ratings</label>
        <?php
        $json_ratings = json_decode($plugin['plugin_ratings_json'], true);
        if (!empty($json_ratings)) {
            foreach ($json_ratings as $k => $v) {
                ?>
                <p><?php echo $k ?> : <?php echo $v ?></p>
                <?php
            }
        }
        ?>
    </div>
    <!-- Plugin Downloaded -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Downloaded</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_downloaded); ?>"
            readonly>
    </div>

    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Downloaded JSON</label>
        <?php
        $installation_growth_array = $installation_growth ? json_decode($installation_growth, true) : [];
        if (!empty($installation_growth_array)) {
            foreach ($installation_growth_array as $k => $v) {
                ?>
                <p><?php echo $k ?> : <?php echo $v ?></p>
                <?php
            }
        }
        ?>
    </div>
    <!-- Plugin Author -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Author Name</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_author_name); ?>"
            readonly>
    </div>

    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Author Profile URL</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_profile_url); ?>"
            readonly>
    </div>

    <!-- Plugin Tags -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Tags (comma separated)</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_tags); ?>"
            placeholder="SEO, SEO Plugin, WP SEO" readonly>
    </div>

    <!-- Plugin Keyword AI -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Meta Keywords AI (comma
            separated)</label>
        <input type="text" class="wpaisearch-form-control" name="plugin_keywords"
            value="<?php echo esc_attr($plugin_keywords); ?>" placeholder="">
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Pro Version Link</label>
        <input type="url" class="wpaisearch-form-control" name="plugin_pro_version_link"
            value="<?php echo esc_url($plugin_pro_version_link); ?>" placeholder="">
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Documentation Link</label>
        <input type="url" class="wpaisearch-form-control" name="plugin_docs_link"
            value="<?php echo esc_url($plugin_docs_link); ?>" placeholder="">
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Live Demo Link</label>
        <input type="url" class="wpaisearch-form-control" name="plugin_live_demo_link"
            value="<?php echo esc_url($plugin_live_demo_link); ?>" placeholder="">
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin YouTube Tutorial Link</label>
        <input type="url" class="wpaisearch-form-control" name="best_youtube_tutorials_link"
            value="<?php echo esc_url($best_youtube_tutorials_link); ?>" placeholder="">
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Community Link</label>
        <input type="url" class="wpaisearch-form-control" name="community_page_link"
            value="<?php echo esc_url($community_page_link); ?>" placeholder="">
    </div>
    <?php
    foreach ($readonly_numeric as $field) {
        $value = esc_attr($plugin[$field] ?? '');
        echo '
         <div class="wpaisearch-col-md-6">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold wpaisearch-text-capitalize">' . str_replace('_', ' ', $field) . '</label>
        <input type="number" step="any" name="" value="' . $value . '" class="wpaisearch-form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '" readonly>
        </div>';
    }
    

    foreach ($select_fields as $field => $options) {
        $current = $plugin[$field] ?? '';
        echo '<div class="wpaisearch-col-md-6">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold wpaisearch-text-capitalize">' . str_replace('_', ' ', $field) . '</label>
        <select name="' . esc_attr($field) . '" class="wpaisearch-form-select">';
        foreach ($options as $val => $label) {
            printf('<option value="%s" %s>%s</option>', esc_attr($val), selected($current, $val, false), esc_html($label));
        }
        echo '</select></div>';
    }
    ?>
    <?php
    $plugin_scrap_log_details_url = add_query_arg([
        'page' => 'plugin-scrap-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    $plugin_faq_log_details_url = add_query_arg([
        'page' => 'plugin-faq-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    $plugin_review_log_details_url = add_query_arg([
        'page' => 'plugin-review-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    ?>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Log Details</label>
        <a href="<?php echo $plugin_scrap_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Faq Details</label>
        <a href="<?php echo $plugin_faq_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Review Details</label>
        <a href="<?php echo $plugin_review_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
</div>
<?php
require get_template_directory() . '/admin/metabox-html/plugins-cpt-meta-box-metric-form.php';
?>