<?php
global $post;
wp_nonce_field('_home_page_faq_groups_nonce_action', '_home_page_faq_groups_nonce');
$rows = get_post_meta($post->ID, '_home_page_faq_groups', true) ?: [];
?>

<style>
    #home_page_faq_meta_box iframe {
        height: 300px !important;
    }
</style>

<div id="custom-repeater-wrapper">
    <?php foreach ($rows as $i => $row): ?>
        <div class="custom-repeater-row" id="custom-repeater-row-<?php echo esc_attr($i); ?>">
            <input type="text"
                name="_home_page_faq_groups[<?php echo esc_attr($i); ?>][title]"
                value="<?php echo esc_attr($row['title'] ?? ''); ?>"
                placeholder="Title"
                style="width:100%; margin-bottom:10px;" />

            <div class="image-upload-wrap" style="margin-bottom: 10px;">
                <img src="<?php echo esc_url($row['image'] ?? ''); ?>"
                    class="image-preview"
                    id="image-preview-<?php echo esc_attr($i); ?>"
                    style="max-width: 100%; <?php echo !empty($row['image']) ? '' : 'display:none;'; ?>" />
                <input type="hidden"
                    name="_home_page_faq_groups[<?php echo esc_attr($i); ?>][image]"
                    class="image-url"
                    id="image-url-<?php echo esc_attr($i); ?>"
                    value="<?php echo esc_attr($row['image'] ?? ''); ?>" />
                <button type="button" class="button upload-image-button" data-index="<?php echo esc_attr($i); ?>">Upload Image</button>
                <button type="button" class="button remove-image-button"
                    id="remove-image-<?php echo esc_attr($i); ?>"
                    <?php echo !empty($row['image']) ? '' : 'style="display:none;"'; ?>>Remove</button>
            </div>

            <?php
            $editor_id = "repeater_editor_$i";
            wp_editor(
                $row['textarea'] ?? '',
                $editor_id,
                [
                    'textarea_name' => "_home_page_faq_groups[$i][textarea]",
                    'textarea_rows' => 10,
                    'media_buttons' => true,
                ]
            );
            ?>
            <button type="button" class="button remove-row">Remove</button>
            <hr>
        </div>
    <?php endforeach; ?>
</div>

<button type="button" class="button" id="add-repeater-row">Add Row</button>

<script>
jQuery(document).ready(function ($) {
    let index = <?php echo count($rows); ?>;

    $('#add-repeater-row').on('click', function () {
        const editorId = 'repeater_editor_' + index;
        const textareaName = `_home_page_faq_groups[${index}][textarea]`;

        const newRow = $(`
            <div class="custom-repeater-row" id="custom-repeater-row-${index}">
                <input type="text" name="_home_page_faq_groups[${index}][title]" placeholder="Title" style="width:100%; margin-bottom:10px;" />
                <div class="image-upload-wrap" style="margin-bottom: 10px;">
                    <img src="" class="image-preview" id="image-preview-${index}" style="max-width: 100%; display:none;" />
                    <input type="hidden" name="_home_page_faq_groups[${index}][image]" class="image-url" id="image-url-${index}" />
                    <button type="button" class="button upload-image-button" data-index="${index}">Upload Image</button>
                    <button type="button" class="button remove-image-button" id="remove-image-${index}" style="display:none;">Remove</button>
                </div>
                <div class="wp-editor-wrap">
                    <textarea id="${editorId}" name="${textareaName}"></textarea>
                </div>
                <button type="button" class="button remove-row">Remove</button>
                <hr>
            </div>
        `);

        $('#custom-repeater-wrapper').append(newRow);

        // ✅ Initialize real WordPress editor dynamically
        if (typeof wp.editor !== 'undefined') {
            wp.editor.initialize(editorId, {
                tinymce: {
                    wpautop: true,
                    toolbar1: 'bold italic underline | bullist numlist | link unlink',
                    plugins: 'lists link paste wordpress',
                },
                quicktags: true,
                mediaButtons: true,
            });
        }

        index++;
    });

    // ✅ Remove row (and editor cleanly)
    $('#custom-repeater-wrapper').on('click', '.remove-row', function () {
        const $row = $(this).closest('.custom-repeater-row');
        const textarea = $row.find('textarea');
        const editorId = textarea.attr('id');

        if (typeof wp.editor !== 'undefined') {
            try { wp.editor.remove(editorId); } catch (e) {}
        }

        $row.remove();
    });

    // ✅ Upload image
    $('#custom-repeater-wrapper').on('click', '.upload-image-button', function (e) {
        e.preventDefault();
        const index = $(this).data('index');
        const imagePreview = $('#image-preview-' + index);
        const imageInput = $('#image-url-' + index);
        const removeBtn = $('#remove-image-' + index);

        const mediaUploader = wp.media({
            title: 'Select Image',
            button: { text: 'Use this image' },
            multiple: false
        });

        mediaUploader.on('select', function () {
            const attachment = mediaUploader.state().get('selection').first().toJSON();
            imagePreview.attr('src', attachment.url).show();
            imageInput.val(attachment.url);
            removeBtn.show();
        });

        mediaUploader.open();
    });

    // ✅ Remove image
    $('#custom-repeater-wrapper').on('click', '.remove-image-button', function (e) {
        e.preventDefault();
        const id = $(this).attr('id');
        const index = id.replace('remove-image-', '');
        $('#image-preview-' + index).hide().attr('src', '');
        $('#image-url-' + index).val('');
        $(this).hide();
    });
});
</script>
