<?php

class Custom_table_creation
{
    public static function create_custom_table()
    {
        self::create_table_cron_page_visits_log();
        self::create_table_cron_scraped_plugins_log();
        self::create_table_core_plugins_informations();
        self::create_table_plugin_contributors();
        self::create_table_plugin_faqs();
        //self::create_table_plugin_all_versions();
        //self::create_table_comment_page_links();
        self::create_table_plugin_comments();
    }
    public static function create_table_cron_page_visits_log()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'cron_page_visits_log'; // your custom table name

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
        CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            page_number INT(10) UNSIGNED NOT NULL,
            endpoint VARCHAR(255) NOT NULL COMMENT 'API endpoint or query URL for this page',
            per_page INT(10) UNSIGNED DEFAULT NULL COMMENT 'Number of items per page',
            visited TINYINT(1) DEFAULT 0 COMMENT '0 = not visited, 1 = visited',
            visit_count INT(10) UNSIGNED DEFAULT 0 COMMENT 'How many times this page was visited',
            last_visited_at DATETIME DEFAULT NULL COMMENT 'Timestamp of last visit',
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY unique_page (page_number, endpoint)
        ) $charset_collate;
        ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_cron_scraped_plugins_log()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'cron_scraped_plugins_log'; // your custom table name

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
        CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            plugin_slug VARCHAR(191) NOT NULL COMMENT 'Unique plugin slug identifier from WordPress.org',
            plugin_name VARCHAR(255) DEFAULT NULL,
            plugin_icon VARCHAR(255) DEFAULT NULL,
            page_number INT(10) UNSIGNED DEFAULT NULL COMMENT 'From which page it was scraped',
            api_scrapped TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0 = not scraped yet, 1 = successfully scraped',
            scrapped TINYINT(1) DEFAULT 0 COMMENT '0 = not scraped yet, 1 = successfully scraped',
            scrape_attempts INT(10) UNSIGNED DEFAULT 0 COMMENT 'How many times scraping was attempted',
            last_scraped_at DATETIME DEFAULT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY unique_slug (plugin_slug)
        ) $charset_collate;
        ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_core_plugins_informations()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugins_core_information';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                slug VARCHAR(255) NOT NULL COMMENT 'Data From API',
                name VARCHAR(255) NOT NULL COMMENT 'Data From API',
                version VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                author_name VARCHAR(255) DEFAULT NULL COMMENT 'Data From API',
                author_profile VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                requires_plugins VARCHAR(255) DEFAULT NULL COMMENT 'Data From API',
                tested VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                requires_php VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                active_installs BIGINT DEFAULT NULL COMMENT 'Data From API',
                downloaded BIGINT DEFAULT NULL COMMENT 'Data From API',
                rating INT DEFAULT NULL COMMENT 'Data From API',
                num_ratings INT DEFAULT NULL COMMENT 'Data From API',
                support_threads INT DEFAULT NULL COMMENT 'Data From API',
                support_threads_resolved INT DEFAULT NULL COMMENT 'Data From API',
                short_description LONGTEXT COMMENT 'Data From API',
                description LONGTEXT COMMENT 'Data From API',
                description_stip_tag LONGTEXT COMMENT 'Data From API',
                homepage VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                download_link VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                donate_link VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                last_updated DATETIME DEFAULT NULL COMMENT 'Data From API',
                added DATE DEFAULT NULL COMMENT 'Data From API',
                plugin_tags VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                plugin_installation LONGTEXT DEFAULT NULL COMMENT 'Data From API',
                plugin_changelog LONGTEXT DEFAULT NULL COMMENT 'Data From API',
                plugin_feature_image VARCHAR(500) DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_video VARCHAR(500) DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_screenshots JSON DEFAULT NULL COMMENT 'Data From API',
                plugin_ratings_json JSON DEFAULT NULL COMMENT 'Data From API',
                version_release_count INT DEFAULT 0 COMMENT 'Data From API',
                version_json_link JSON DEFAULT NULL COMMENT 'Data From API',
                plugin_feature_meta_key_word LONGTEXT DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_open_ai_short_description LONGTEXT DEFAULT NULL COMMENT 'Data From AI',
                plugin_open_ai_long_description LONGTEXT DEFAULT NULL COMMENT 'Data From AI',
                plugin_open_ai_category JSON DEFAULT NULL COMMENT 'Data From AI',
              
                is_api_crawled TINYINT(1) DEFAULT 0,
                is_web_crawled TINYINT(1) DEFAULT 0,
                is_ai_short_description_done TINYINT(1) DEFAULT 0,
                is_ai_long_description_done TINYINT(1) DEFAULT 0,
                is_ai_meta_keywords_done TINYINT(1) DEFAULT 0,
                is_ai_tax_category_done TINYINT(1) DEFAULT 0,
           
                is_wp_post_created TINYINT(1) DEFAULT 0 COMMENT '1 = WP post created',
                is_wp_post_updated TINYINT(1) DEFAULT 0 COMMENT '1 = WP post updated',
                wp_post_id BIGINT DEFAULT NULL,
                last_update_days INT DEFAULT 0 COMMENT 'Days since last update',
                
                plugin_age_days INT DEFAULT 0 COMMENT 'Days since first release',
                
                package_size_mb FLOAT DEFAULT 0 COMMENT 'Download ZIP size in MB',
                
                localization_count INT DEFAULT 0 COMMENT 'Number of available translations',
                
              
              
                
               
               
                
                license_type ENUM('free','freemium','paid','unknown') DEFAULT 'unknown' COMMENT 'Detected pricing model',
                
                overall_wpscore FLOAT DEFAULT 0 COMMENT 'Aggregated plugin performance index',
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (id),
                UNIQUE KEY slug (slug),
                INDEX idx_api_crawled (is_api_crawled),
                INDEX idx_web_crawled (is_web_crawled)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

    }
    public static function create_table_plugin_contributors()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_contributors';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    name VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    profile_url VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    profile_image VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    PRIMARY KEY (id),
                    INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_plugin_faqs()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_faqs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                  id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                  plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                  question VARCHAR(255) NULL COMMENT 'Data From Scrap',
                  answer LONGTEXT NULL COMMENT 'Data From Scrap',
                  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                  updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                  PRIMARY KEY (id),
                  INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    // public static function create_table_plugin_all_versions()
    // {
    //     global $wpdb;
    //     $table_name = $wpdb->prefix . 'plugin_all_versions';
    //     $charset_collate = $wpdb->get_charset_collate();

    //     $sql = "
    //         CREATE TABLE IF NOT EXISTS $table_name (
    //               id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    //               plugin_slug VARCHAR(255) NULL COMMENT 'Data From API',
    //               version VARCHAR(255) NULL COMMENT 'Data From API',
    //               link VARCHAR(255) NULL COMMENT 'Data From API',
    //               created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    //               updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    //               PRIMARY KEY (id),
    //               INDEX idx_plugin_slug (plugin_slug)
    //         ) $charset_collate;
    //         ";

    //     require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    //     dbDelta($sql);
    // }
    public static function create_table_plugin_comments()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_comments';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_title VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_text LONGTEXT NULL COMMENT 'Data From Scrap',
                    commenter_name LONGTEXT NULL COMMENT 'Data From Scrap',
                    commenter_image_link VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    commenter_num_rating VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_date VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    no_of_reply VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    PRIMARY KEY (id),
                    INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function manage_add_management_page()
    {
        add_management_page(
            'Custom Table Sync',           // Page title
            'Custom Table Sync',           // Menu title
            'manage_options',       // Capability
            'custom-table-sync',           // Menu slug
            ['Custom_table_creation', 'custom_table_sync_management'] // Callback
        );
    }
    public static function manage_clear_scrap_flag_to_recrawl()
    {
        add_management_page(
            'Clear Scrap Flag',           // Page title
            'Clear Scrap Flag',           // Menu title
            'manage_options',       // Capability
            'clear-scrap-flag',           // Menu slug
            ['Custom_table_creation', 'clear_scrap_flag'] // Callback
        );
    }
    public static function clear_scrap_flag()
    {
        echo '<div class="wrap"><h1>Clear Scrap Flag Synchronization</h1>';

        if (!current_user_can('manage_options')) {
            echo '<p>You do not have permission to access this page.</p></div>';
            return;
        }
        require get_template_directory() . '/admin/theme-options/clear-flag.php';
    }

    public static function custom_table_sync_management()
    {
        echo '<div class="wrap"><h1>Custom Table Structure Synchronization</h1>';

        if (!current_user_can('manage_options')) {
            echo '<p>You do not have permission to access this page.</p></div>';
            return;
        }

        global $wpdb;
        $cron_scraped_plugins_log_table_name = $wpdb->prefix . 'cron_scraped_plugins_log';
        $core_plugins_information_table = $wpdb->prefix . 'plugins_core_information';

        // Helper function to check if a column exists
        $column_exists_cron_scraped_plugins_log_table = function ($column_name) use ($wpdb, $cron_scraped_plugins_log_table_name) {
            return $wpdb->get_var(
                $wpdb->prepare("SHOW COLUMNS FROM `$cron_scraped_plugins_log_table_name` LIKE %s", $column_name)
            );
        };

        $column_exists_core_plugins_information_table = function ($column_name) use ($wpdb, $core_plugins_information_table) {
            return $wpdb->get_var(
                $wpdb->prepare("SHOW COLUMNS FROM `$core_plugins_information_table` LIKE %s", $column_name)
            );
        };

        try {
            // Check and add active_installs column
            if (!$column_exists_cron_scraped_plugins_log_table('active_installs')) {
                $result = $wpdb->query("
            ALTER TABLE `$cron_scraped_plugins_log_table_name` 
            ADD `active_installs` BIGINT NULL DEFAULT NULL AFTER `plugin_icon`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            //    Check and add short_description column

            if (!$column_exists_cron_scraped_plugins_log_table('short_description')) {
                $result = $wpdb->query("
            ALTER TABLE `$cron_scraped_plugins_log_table_name` 
            ADD `short_description` LONGTEXT NULL DEFAULT NULL AFTER `active_installs`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            //  package_size_mb column alter to package_size_kb



            if (!$column_exists_core_plugins_information_table('error_log_open_ai')) {
                $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table` 
            ADD `error_log_open_ai` LONGTEXT NULL DEFAULT NULL AFTER `is_ai_tax_industry_done`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }
            if (!$column_exists_core_plugins_information_table('is_recreate_ai_post')) {
                $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table` 
            ADD `is_recreate_ai_post` TINYINT(1) DEFAULT 0 COMMENT '0 = not required, 1 = required' AFTER `is_wp_post_updated`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            $columns = [
                'post_title' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `overall_wpscore`",
                'post_short_descripton' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_title`",
                'post_long_descripton' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_short_descripton`",
                'post_meta_keywords' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_long_descripton`",
                //'post_taxonomy_ids' => "JSON NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_meta_keywords`",
                'support_quality' => "ENUM('1','2','3','4') DEFAULT '3' COMMENT '1=Excellent, 2=Good, 3=Fair, 4=Poor' AFTER `post_taxonomy_ids`",
                'performance_impact' => "ENUM('1','2','3') DEFAULT '3' COMMENT '1=Low, 2=Medium, 3=High' AFTER `support_quality`",
                'user_review_sentiment' => "ENUM('1','2','3') DEFAULT '2' COMMENT '1=Negative, 2=Neutral, 3=Positive' AFTER `performance_impact`",
                //'seo_impact' => "ENUM('1','2','3') DEFAULT '2' COMMENT '1=Positive, 2=Neutral, 3=Negative' AFTER `user_review_sentiment`",
                'is_sponsored' => "ENUM('1','2') DEFAULT '1' COMMENT '1=Default, 2=Sponsored' AFTER `seo_impact`",
                'plugin_icon' => "VARCHAR(255) DEFAULT NULL AFTER `name`",
                'plugin_docs_link' => "VARCHAR(255) DEFAULT NULL AFTER `plugin_icon`",
                'plugin_pro_version_link' => "VARCHAR(255) DEFAULT NULL AFTER `plugin_docs_link`",
                'plugin_live_demo_link' => "VARCHAR(255) DEFAULT NULL AFTER `plugin_pro_version_link`",
                'plugin_developememt_with_changelog' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From Scrapp' AFTER `plugin_changelog`",
                //'post_tag_ids' => "JSON NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_taxonomy_ids`",

                'has_lifetime_license' => "ENUM('1','2','3') DEFAULT '3' COMMENT '1=yes, 2=No, 3=Nothing' AFTER `post_tag_ids`",
                'woocommerce_support' => "ENUM('1','2','3') DEFAULT '3' COMMENT '1=yes, 2=No,3=Nothing' AFTER `has_lifetime_license`",
                'has_agency_friendly_license' => "ENUM('1','2','3') DEFAULT '3' COMMENT '1=yes, 2=No, 3=Nothing' AFTER `woocommerce_support`",
                'is_multisite_support' => "ENUM('1','2') DEFAULT '1' COMMENT '1=yes, 2=No' AFTER `has_agency_friendly_license`",
                'best_youtube_tutorials_link' => "VARCHAR(255) DEFAULT NULL AFTER `is_multisite_support`",
                'community_page_link' => "VARCHAR(255) DEFAULT NULL AFTER `best_youtube_tutorials_link`",
                'installation_growth' => "JSON NULL DEFAULT NULL COMMENT 'Data From API/making JSON' AFTER `community_page_link`",
                'wps_installation_growth_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `installation_growth`",
                'wps_update_recency_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_installation_growth_score`",
                'wps_update_frequency_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_update_recency_score`",
                'wps_compatibility_with_latest_wp_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_update_frequency_score`",
                'wps_support_responsiveness_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_compatibility_with_latest_wp_score`",
                'wps_average_rating_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_support_responsiveness_score`",
                'wps_number_of_ratings_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_average_rating_score`",
                'wps_maturity_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_number_of_ratings_score`",
                'wps_license_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_maturity_score`",
                'wps_has_lifetime_license_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_license_score`",
                'wps_performance_impact_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_has_lifetime_license_score`",
                'wps_php_version_support_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_performance_impact_score`",
                'wps_multisite_support_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_php_version_support_score`",
                'wps_localization_languages_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_multisite_support_score`",
                'wps_developer_reputation_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_localization_languages_score`",
                'wps_documentation_quality_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_developer_reputation_score`",
                'wps_youtube_tutorials_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_documentation_quality_score`",
                'wps_community_page_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_youtube_tutorials_score`",
                'is_meta_information_from_ai_search' => "TINYINT(1) DEFAULT 0 COMMENT '1 done 0 undone' AFTER `wps_community_page_score`",
                'documentation_quality' => "ENUM('1','2','3') DEFAULT '2' COMMENT '1=low, 2=moderate, 3=Good' AFTER `is_meta_information_from_ai_search`",
                'wps_active_install_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `documentation_quality`",
                'wps_woocommerce_support_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_active_install_score`",
                'wps_agency_license_score' => "FLOAT DEFAULT 0 COMMENT 'range of 1-10' AFTER `wps_woocommerce_support_score`",
                'wps_metric_group_info' => "JSON NULL DEFAULT NULL COMMENT 'Same Group Plugin' AFTER `wps_agency_license_score`",
                'is_wps_metric_group_done' => "TINYINT(1) DEFAULT 0 COMMENT '1 done 0 undone' AFTER `wps_metric_group_info`",
                'plugin_ai_profile' => "JSON NULL DEFAULT NULL COMMENT 'Data From AI' AFTER `is_sponsored`",
            ];

            foreach ($columns as $column => $definition) {
                if (!$column_exists_core_plugins_information_table($column)) {
                    $query = "ALTER TABLE `$core_plugins_information_table` ADD `$column` $definition;";
                    $result = $wpdb->query($query);

                    if ($result === false) {
                        throw new Exception("Failed to add column `$column`: " . $wpdb->last_error);
                    }
                }
            }
            $index_columns = [

                // Numeric columns → NORMAL INDEX
                'active_installs' => [
                    'type' => 'bigint',
                ],

                'overall_wpscore' => [
                    'type' => 'float',
                ],
                // 'rating_count' => [
                //     'type' => 'int',
                // ],

                // // Short text → FULLTEXT
                // 'plugin_name' => [
                //     'type' => 'varchar',
                // ],

                // 'plugin_slug' => [
                //     'type' => 'varchar',
                // ],

                // // Large text → FULLTEXT (use intentionally)
                // 'short_description' => [
                //     'type' => 'text',
                // ],

                // 'long_description' => [
                //     'type' => 'longtext',
                //     // 'index' => 'fulltext', // optional explicit override
                // ],
            ];
            // ✅ Add indexes for faster search (for LONGTEXT we use FULLTEXT)
            $fulltext_types = [
                'char',
                'varchar',
                'text',
                'mediumtext',
                'longtext',
            ];

            foreach ($index_columns as $column => $def) {

                if (empty($def['type'])) {
                    continue;
                }

                $type = strtolower($def['type']);

                // Decide index type (allow override)
                if (!empty($def['index'])) {
                    $index_type = strtoupper($def['index']);
                } else {
                    $index_type = in_array($type, $fulltext_types, true)
                        ? 'FULLTEXT'
                        : 'INDEX';
                }

                // Check if index already exists
                $index_exists = $wpdb->get_var(
                    $wpdb->prepare(
                        "SHOW INDEX FROM `$core_plugins_information_table`
                    WHERE Column_name = %s",
                        $column
                    )
                );

                if ($index_exists) {
                    continue;
                }

                // Build ALTER query
                if ($index_type === 'FULLTEXT') {
                    $sql = "
                    ALTER TABLE `$core_plugins_information_table`
                    ADD FULLTEXT (`$column`)
                ";
                } else {
                    $sql = "
                    ALTER TABLE `$core_plugins_information_table`
                    ADD INDEX (`$column`)
                ";
                }

                $result = $wpdb->query($sql);

                if ($result === false) {
                    throw new Exception(
                        sprintf(
                            'Failed to create %s index for `%s`: %s',
                            $index_type,
                            $column,
                            $wpdb->last_error
                        )
                    );
                }
            }

            //self::add_virtual_columns_for_json();
            echo '<p>Sync Done</p></div>';

        } catch (Exception $e) {
            echo '<p style="color: red;">Error: ' . esc_html($e->getMessage()) . '</p></div>';
        }
        self::column_defination_change();
        self::column_definition_change_for_cron_scraped_plugins_log();
        self::create_table_plugin_comparisons();
        self::create_table_personalized_plugin_recommendation();
    }
    public static function column_defination_change()
    {
        try {
            global $wpdb;
            $cron_scraped_plugins_log_table_name = $wpdb->prefix . 'cron_scraped_plugins_log';
            $core_plugins_information_table = $wpdb->prefix . 'plugins_core_information';

            $column_exists_core_plugins_information_table = function ($column_name) use ($wpdb, $core_plugins_information_table) {
                return $wpdb->get_var(
                    $wpdb->prepare("SHOW COLUMNS FROM `$core_plugins_information_table` LIKE %s", $column_name)
                );
            };

            if (!$column_exists_core_plugins_information_table('package_size_mb')) {
                throw new Exception('Column package_size_mb does not exist in the table.');
            } else {
                $result = $wpdb->query("
                    ALTER TABLE `$core_plugins_information_table`
                    CHANGE `package_size_mb` `package_size_kb` FLOAT DEFAULT 0 COMMENT 'Download ZIP size in KB'
                ");


                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }
            if (!$column_exists_core_plugins_information_table('plugin_feature_meta_key_word')) {
                throw new Exception('Column plugin_feature_meta_key_word does not exist in the table.');
            }

            // ✅ Column exists → rename it
            $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table`
            CHANGE `plugin_feature_meta_key_word` `plugin_feature_meta_key_word_ai` LONGTEXT NULL DEFAULT NULL COMMENT 'Data From AI'
        ");

            if ($result === false) {
                throw new Exception('Failed to alter table: ' . $wpdb->last_error);
            }
        } catch (Exception $e) {
            echo '<p style="color: red;">Error: ' . esc_html($e->getMessage()) . '</p></div>';
        }
    }
    public static function add_virtual_columns_for_json()
    {
        global $wpdb;

        $table = $wpdb->prefix . "plugins_core_information";

        // Check MySQL version
        $mysql_version = $wpdb->get_var("SELECT VERSION()");
        if (version_compare($mysql_version, '5.7', '<')) {
            error_log("MySQL version too old for JSON virtual columns.");
            return;
        }

        // -------------------------------
        // 1️⃣ post_taxonomy_ids_first
        $col_exists = $wpdb->get_var($wpdb->prepare("
        SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = %s
          AND COLUMN_NAME = 'post_taxonomy_ids_first'
    ", $table));

        if (!$col_exists) {
            $sql = "ALTER TABLE `$table`
                ADD COLUMN post_taxonomy_ids_first BIGINT
                GENERATED ALWAYS AS (JSON_UNQUOTE(JSON_EXTRACT(post_taxonomy_ids, '$[0]'))) STORED";
            $wpdb->query($sql);
            // Add index
            $wpdb->query("ALTER TABLE `$table` ADD INDEX idx_post_taxonomy_ids_first (post_taxonomy_ids_first)");
        }

        // -------------------------------
        // 2️⃣ post_tag_ids_first
        $col_exists = $wpdb->get_var($wpdb->prepare("
        SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = %s
          AND COLUMN_NAME = 'post_tag_ids_first'
    ", $table));

        if (!$col_exists) {
            $sql = "ALTER TABLE `$table`
                ADD COLUMN post_tag_ids_first BIGINT
                GENERATED ALWAYS AS (JSON_UNQUOTE(JSON_EXTRACT(post_tag_ids, '$[0]'))) STORED";
            $wpdb->query($sql);
            // Add index
            $wpdb->query("ALTER TABLE `$table` ADD INDEX idx_post_tag_ids_first (post_tag_ids_first)");
        }

        error_log("✅ Virtual BIGINT columns and indexes for JSON added successfully.");
    }
    public static function column_definition_change_for_cron_scraped_plugins_log()
    {
        try {
            global $wpdb;

            $cron_scraped_plugins_log = $wpdb->prefix . 'cron_scraped_plugins_log';

            // 🔍 Anonymous function to check column existence
            $column_exists_scraped_plugins_information_table = function ($column_name) use ($wpdb, $cron_scraped_plugins_log) {
                return $wpdb->get_var(
                    $wpdb->prepare("SHOW COLUMNS FROM `$cron_scraped_plugins_log` LIKE %s", $column_name)
                );
            };

            $columns = [
                'is_wps_score_field_set' => "TINYINT(1) DEFAULT 0 COMMENT '1 done 0 undone' AFTER `scrape_attempts`",
                'is_wps_score_calculated' => "TINYINT(1) DEFAULT 0 COMMENT '1 done 0 undone' AFTER `is_wps_score_field_set`",

            ];

            // ----------------------------------
            // LOOP THROUGH & ADD MISSING COLUMNS
            // ----------------------------------
            foreach ($columns as $column => $definition) {
                if (!$column_exists_scraped_plugins_information_table($column)) {

                    $query = "ALTER TABLE `$cron_scraped_plugins_log` ADD `$column` $definition;";
                    $result = $wpdb->query($query);

                    if ($result === false) {
                        throw new Exception("Failed to add column `$column`: " . $wpdb->last_error);
                    }
                }
            }

        } catch (Exception $e) {
            echo '<p style="color: red;">Error: ' . esc_html($e->getMessage()) . '</p>';
        }
    }
    public static function create_table_plugin_comparisons()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'plugin_comparisons';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
    CREATE TABLE {$table_name} (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,

        comparison_title VARCHAR(255) DEFAULT NULL COMMENT 'Comparison Name',
        plugin_comparison LONGTEXT NULL COMMENT 'Comparison content or data',

        plugin_slugs VARCHAR(255) NOT NULL COMMENT 'Comma-separated plugin slugs',
        plugin_names VARCHAR(255) NOT NULL COMMENT 'Comma-separated plugin names',

        plugin_slugs_key VARCHAR(255) NOT NULL COMMENT 'avoid duplication',

        wp_post_id BIGINT(20) UNSIGNED NULL COMMENT 'Related WordPress post ID',
        is_ai_comparison_json_done TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0 = not created, 1 = created',
        is_post_created TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0 = not created, 1 = created',

        plugin_category_id BIGINT(20) UNSIGNED NULL COMMENT 'Related WordPress category ID',
        `error_log_open_ai` LONGTEXT NULL DEFAULT NULL,
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

        PRIMARY KEY  (id),

        UNIQUE KEY plugin_slugs_key_unique (plugin_slugs_key)
    ) {$charset_collate};
    ";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }
    public static function create_table_personalized_plugin_recommendation()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'personalized_plugin_recommendation';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
    CREATE TABLE {$table_name} (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,

        user_id BIGINT(20) UNSIGNED NOT NULL,

        recommendation_title VARCHAR(255) NULL,
        user_questions JSON NULL,
        questions_hash VARCHAR(255) NULL,
        recommended_plugins JSON NULL,
         
        is_pinned TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0 = not pinned, 1 = pinned',

        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

        PRIMARY KEY (id),
        KEY user_id (user_id),
        KEY is_pinned (is_pinned)
    ) {$charset_collate};
    ";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }

}