<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package wpsearch
 */

get_header();
?>

<main id="primary" class="site-main">

	<section class="error-404 not-found sectionPadding bg-[linear-gradient(180deg,#FFFFFF_36.3%,#A4E4FF_178.33%)]">
		<div class="container">
			<div class="flex items-center justify-center mb-10">
				<div class="text-center">
					<!-- Big 404 number -->
					<h1 class="text-[6rem] sm:text-[10rem] md:text-[12rem] font-extrabold bg-gradient-to-r from-[#1650D7] to-[#0EF0AA] bg-clip-text text-transparent tracking-widest">404</h1>

					<!-- Message -->
					<p class="text-2xl md:text-3xl font-semibold text-gray-700">
						Oops! Page not found
					</p>

					<p class="mt-4 text-gray-500">
						The page you are looking for doesn’t exist or has been moved.
					</p>

					<!-- Buttons -->
					<div class="mt-6 flex justify-center space-x-2">
						<a href="index.php" class="py-2.5 px-8 text-base leading-[160%] font-bold text-[var(--theme-white)] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-300 rounded-[54px] whitespace-nowrap">
							Go Home
						</a>
						<a href="javascript:history.back()" class="py-2.5 px-8 text-base leading-[160%] font-bold text-gray-700 bg-gray-200 hover:opacity-80 duration-300 rounded-[54px] whitespace-nowrap">
							Go Back
						</a>
					</div>
				</div>
			</div>
		</div>
	</section><!-- .error-404 -->

</main><!-- #main -->

<?php
get_footer();
