<?php
get_header();
$post_id = get_the_id();
global $wpdb;
$tbl = $wpdb->prefix . "plugins_core_information";
$tbl_plugin_faqs = $wpdb->prefix . "plugin_faqs";
$terms_table = $wpdb->prefix . "term_relationships";
$tbl_plugin_contributors = $wpdb->prefix . "plugin_contributors";

$object_ids = $wpdb->get_col($wpdb->prepare(
    "SELECT term_taxonomy_id FROM {$terms_table} WHERE object_id = %d",
    $post_id
));
// dd($object_ids);

$sql = "Select *from $tbl where wp_post_id = $post_id";
$the_plugin_information = $wpdb->get_row($sql);

$all_level = get_plugin_category_hierarchy($object_ids);
$sql = "Select *from $tbl_plugin_faqs where plugin_slug = '$the_plugin_information->slug'";
$plugin_faqs = $wpdb->get_results($sql);


$sql = "Select *from $tbl_plugin_contributors where plugin_slug = '$the_plugin_information->slug'";
$plugin_contributors = $wpdb->get_results($sql);
//dd($all_level);
$based_on_active_install = plugin_cpt_frontend_load::get_plugins_with_category_id_filter_exclude(
    $all_level[0]['id'],
    $the_plugin_information->id,
    6,
    0,
    [],
    null,
    null
);
$all_comments=plugin_cpt_frontend_load::get_the_plugin_comments($the_plugin_information->slug);

//dd($the_plugin_information->plugin_changelog);
?>
<main>
    <section class="pb-3 sm:pb-1">
        <div class="container">
            <div>
                <div class="flex flex-wrap items-center text-[13px] font-normal leading-[120%] text-[#A1A7B1]">
                    <div>
                        <a href="<?php echo site_url() ?>" class="px-1 py-1 sm:py-3 inline-block">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?php echo asset_image_path_generator() . 'category-page/home.svg' ?>"
                                alt="Home-image" />
                        </a>
                    </div>
                    <div class="px-1 space-x-3">
                        <span>/</span>
                        <a href="#" class="py-1 sm:py-3 inline-block hover:text-black duration-300">Plugin Category</a>
                    </div>
                    <?php
                    foreach ($all_level as $single_level) {
                    ?>
                        <div class="px-1 space-x-3">
                            <span>/</span>
                            <a href="<?php echo $single_level['link'] ?>"
                                class="py-1 sm:py-3 inline-block hover:text-black duration-300"><?php echo $single_level['name'] ?></a>
                        </div>
                    <?php
                    }
                    ?>

                    <div class="px-1 space-x-3">
                        <span>/</span>
                        <a href="#"
                            class="py-1 sm:py-3 inline-block hover:text-black duration-300"><?= $the_plugin_information->post_title ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="pb-8">
        <div class="container text-black">
            <div class="flex flex-col xl:flex-row space-y-6 xl:space-y-0 xl:space-x-8">
                <?php
                $template = get_template_directory() . '/frontend/single-plugin-includes/left-side-information.php';

                if (file_exists($template)) {
                    include $template;
                }
                $template = get_template_directory() . '/frontend/single-plugin-includes/right-side-information.php';
                if (file_exists($template)) {
                    include $template;
                }
                ?>
            </div>
        </div>
    </section>

    <section class="sectionPadding">
        <div class="container">
            <div class="space-y-3">
                <div>
                    <h4 class="text-xl lg:text-[25px] font-bold leading-[120%] text-black">
                        Other plugins you might like
                    </h4>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <?php
                        foreach ($based_on_active_install as $plugin) {
                            $single_plugin = $plugin; // rename variable for clarity
                            $template = get_template_directory() . '/frontend/content-single-plugin.php';

                            if (file_exists($template)) {
                                include $template;
                            }
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // -----------------------------
        // 🟥 YouTube embed & MP4 modal
        // -----------------------------
        const videoTrigger = document.getElementById("videoTrigger");
        const videoModal = document.getElementById("videoModal");
        const closeModal = document.getElementById("closeModal");
        const videoFrame = document.getElementById("videoFrame");
        const videoURL =
            "<?php echo $the_plugin_information->plugin_video ?>";

        if (videoTrigger && videoModal && closeModal && videoFrame && videoURL) {
            videoTrigger.addEventListener("click", (e) => {
                e.preventDefault();
                videoModal.classList.remove("hidden");
                videoFrame.src = videoURL;
            });

            closeModal.addEventListener("click", () => {
                videoModal.classList.add("hidden");
                videoFrame.src = "";
            });

            videoModal.addEventListener("click", (e) => {
                if (e.target === videoModal) {
                    videoModal.classList.add("hidden");
                    videoFrame.src = "";
                }
            });
        } else {
            console.warn("⚠️ Missing elements for video modal:", {
                videoTrigger,
                videoModal,
                closeModal,
                videoFrame,
            });
        }
    })
</script>
<?php get_footer(); ?>