<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package wpsearch
 */

get_header();
?>

<main id="primary" class="container">
	<section class="sectionPadding">
		<div class="container">
			<div class="sectionWidth">
				<div class="text-black text-sm font-normal !leading-[165%]
[&_a]:underline
[&_a]:hover:opacity-65
[&_a]:duration-300
[&>*]:mb-5
[&>*:last-child]:mb-0
[&_h2]:mt-8
[&_h2:first-child]:mt-0
[&_h1]:mb-5
[&_h1]:text-2xl
sm:[&_h1]:text-3xl
md:[&_h1]:text-4xl
lg:[&_h1]:text-[49px]
[&_h1]:font-semibold
[&_h1:first-child]:mt-0
[&_h2]:text-lg
md:[&_h2]:text-[28px]
[&_img]:w-full
[&_img]:aspect-[7/4]
[&_img]:object-cover
[&_img]:object-center
[&_ul]:space-y-2.5
[&_ul]:pl-8
[&_li]:list-disc">
					<?php
					while (have_posts()) :
						the_post();

						get_template_part('template-parts/content', 'page');

						// If comments are open or we have at least one comment, load up the comment template.
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
			</div>
		</div>
	</section>

</main><!-- #main -->

<?php
get_footer();
