<div class="container">
    <div class="w-full max-w-[587px] mx-auto">
        <div class="space-y-6 lg:space-y-8 p-6 bg-white border border-[#F2F5FA] rounded-xl">

            <div
                class="mx-auto w-16 min-w-16 h-16 lg:w-[72px] lg:min-w-[72px] lg:h-[72px] flex justify-center items-center bg-gradient-to-b from-white to-[#02AAF2]/25 rounded-full">
                <img class="icon w-8 min-8 h-8 lg:w-10 lg:min-10 lg:h-10 object-contain object-center"
                    src="<?php echo asset_image_path_generator() ?>/ConfirmEmail.svg" alt="ConfirmEmail">
            </div>
            <h1 class="text-3xl md:text-4xl text-center font-bold !leading-[120%]">
                <?php _e("Confirm your email", "IKY") ?>
            </h1>

            <div class="text-center">
                <strong><?php _e("Go check your email!", "IKY") ?></strong>
                <p class="px-6 text-[#727C89] text-center text-base font-normal leading-[160%]">
                    <?php if (!empty($email)): ?>
                    <p>
                        We sent a magic link to your email
                        <span id="email_user_showing" class="font-medium text-black"><?php echo esc_html($email); ?></span>.
                        The link expires in <strong class="text-red-500" id="time_count" data-time_limit="<?=$expiration?>"></strong>, so be sure to use it.
                    </p>
                <?php endif; ?>
                </p>
            </div>
            <button
                class="mx-auto flex justify-center items-center px-2.5 py-1.5 text-[#727C89] bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300"
                type="button" id="again_email_sent">
                <img class="mr-1" src="<?php echo asset_image_path_generator() ?>/sendAgainBtnIcon.svg" alt="">
                <?php _e("Send again", "IKY") ?>
            </button>

            <form action="" id="magic_link_resubmit">
                <input type="hidden" name="email" value="<?= $email ?>">
            </form>

        </div>
    </div>
</div>