<?php
$type_website_building = multistep_plugin_select_wizard::type_website_building();
$builder_theme_using = multistep_plugin_select_wizard::builder_theme_using();
$features_need_in_site = multistep_plugin_select_wizard::features_need_in_site();
$budget_level_plugins = multistep_plugin_select_wizard::budget_level_plugins();
$monthly_traffic = multistep_plugin_select_wizard::monthly_traffic();
$comfortable_configuration_settings = multistep_plugin_select_wizard::comfortable_configuration_settings();

?>
<!-- Modal wizard start-->
<section>
    <div id="blogModal" class="fixed inset-0 opacity-0 pointer-events-none transition-opacity duration-300 z-[999]">
        <!-- fullscreen modal container -->
        <div class="w-full h-full bg-[linear-gradient(180deg,#FFFFFF_36.3%,#A4E4FF_178.33%)] flex flex-col">
            <!-- sticky header -->
            <div class="py-[26px] sticky top-0 bg-white z-10">
                <div class="container">
                    <div class="flex flex-wrap items-center lg:flex-nowrap">
                        <a href="<?= site_url() ?>" class="order-1 inline-block outline-none">
                            <img class="w-[192px] lg:max-w-[226.99px] object-cover object-center"
                                src="<?php echo asset_image_path_generator() ?>/logo.webp" alt="Logo Images" />
                        </a>

                        <div class="mt-6 lg:mt-0 order-3 lg:order-2 w-full flex items-center lg:justify-center space-x-3">
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="1"></button>
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="2"></button>
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="3"></button>
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="4"></button>
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="5"></button>
                            <button
                                class="wizard-link outline-none w-full lg:w-[10%] h-1.5 inline-block bg-[#EEEEEE] rounded-[54px]"
                                data-wizard="6"></button>
                        </div>

                        <button class="order-2 lg:order-3 p-2 ml-auto" id="blogRecommandationModalClose">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?php echo asset_image_path_generator() ?>/close-fill.svg">
                        </button>
                    </div>
                </div>
            </div>

            <!-- scrollable content -->
            <div class="flex-1 overflow-y-auto scrollbarHide">
                <div class="py-[60px]">
                    <div class="container">
                        <div class="sectionwidthWizard">
                            <!-- wizard 1 -->
                            <div id="wizard-1" class="space-y-[60px] wizard-content">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    What type of website are you building (or managing)?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                    <?php
                                    foreach ($type_website_building as $k1 => $v1) {
                                    ?>
                                        <a href="#" data-type_website_building="<?= $k1 ?>"
                                            class="type_website_building p-px group rounded-full bg-[#EEEEEE] hover:bg-gradient-to-r group-[.active]:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block <?= (isset($user['type_website_building']) && $user['type_website_building'] == $k1) ? 'active' : '' ?>">
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] hover:pr-2 group-[.active]:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?= $v1 ?>
                                                <span
                                                    class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 group-[.active]:ml-2 opacity-0 group-hover:opacity-100 group-[.active]:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <!-- wizard 2 -->
                            <div id="wizard-2" class="space-y-[60px] wizard-content hidden">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    Which builder or theme are you using?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">

                                    <?php
                                    foreach ($builder_theme_using as $k1 => $v1) {
                                    ?>
                                        <a href="#" data-builder_theme_using="<?= $k1 ?>"
                                            class="builder_theme_using p-px group rounded-full bg-[#EEEEEE] hover:bg-gradient-to-r group-[.active]:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block <?= (isset($user['builder_theme_using']) && $user['builder_theme_using'] == $k1) ? 'active' : '' ?>">
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] hover:pr-2 group-[.active]:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?= $v1 ?>
                                                <span
                                                    class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 group-[.active]:ml-2 opacity-0 group-hover:opacity-100 group-[.active]:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <!-- wizard 3 -->
                            <div id="wizard-3" class="space-y-[60px] wizard-content hidden">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    What are the most important features your site needs?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                    <?php
                                    foreach ($features_need_in_site as $k3 => $v3) {
                                    ?>
                                        <label for="<?= $k3 ?>"
                                            class="toggleButton relative inline-block rounded-full p-[1px] overflow-hidden cursor-pointer border border-[#EEEEEE]"
                                            data-features_need_in_site="<?= $k3 ?>">
                                            <!-- Outer gradient background -->
                                            <span
                                                class="absolute inset-0 bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] rounded-full opacity-0 transition-opacity duration-300 outerBorder"></span>

                                            <!-- Inner button -->
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] py-1 min-h-[46px] bg-[var(--theme-white)] rounded-full relative buttonContent">
                                                <span
                                                    class="absolute left-1.5 right-1 h-8 w-8 flex items-center justify-center opacity-0 translate-x-full bg-[var(--theme-color)] rounded-full transition-all duration-300 tickMark">
                                                    <img class="white_filter w-[13px] h-[9px] object-contain object-center"
                                                        src="<?= asset_image_path_generator() ?>/category-page/TickMark.svg"
                                                        alt="TickMark" />
                                                </span>
                                                <span class="buttonText transition-all duration-300"><?= $v3 ?></span>
                                            </span>
                                        </label>
                                    <?php
                                    }
                                    ?>


                                </div>
                            </div>

                            <!-- wizard 4 -->
                            <div id="wizard-4" class="space-y-[60px] wizard-content hidden">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    What’s your preferred budget level for plugins?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                    <?php
                                    foreach ($budget_level_plugins as $k4 => $v4) {
                                    ?>
                                        <a href="#"
                                            class="budget_level_plugins p-px group rounded-full bg-[#EEEEEE] hover:bg-gradient-to-r group-[.active]:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block <?= (isset($user['budget_level_plugins']) && $user['budget_level_plugins'] == $k4) ? 'active' : '' ?>"
                                            data-budget_level_plugins="<?= $k4 ?>">
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] hover:pr-2 group-[.active]:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?= $v4 ?>
                                                <span
                                                    class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 group-[.active]:ml-2 opacity-0 group-hover:opacity-100 group-[.active]:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    <?php
                                    }
                                    ?>



                                </div>
                            </div>

                            <!-- wizard 5 -->
                            <div id="wizard-5" class="space-y-[60px] wizard-content hidden">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    How much traffic does your site receive monthly?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                    <?php
                                    foreach ($monthly_traffic as $k5 => $v5) {
                                    ?>
                                        <a href="#"
                                            class="p-px group rounded-full bg-[#EEEEEE] hover:bg-gradient-to-r group-[.active]:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block monthly_traffic <?= (isset($user['monthly_traffic']) && $user['monthly_traffic'] == $k5) ? 'active' : '' ?>"
                                            data-monthly_traffic="<?= $k5 ?>">
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] hover:pr-2 group-[.active]:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?= $k5 ?>
                                                <span
                                                    class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 group-[.active]:ml-2 opacity-0 group-hover:opacity-100 group-[.active]:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    <?php
                                    }
                                    ?>

                                </div>
                            </div>

                            <!-- wizard 6 -->
                            <div id="wizard-6" class="space-y-[60px] wizard-content hidden">
                                <h1 class="text-center text-3xl md:text-4xl lg:text-[49px] font-bold !leading-[120%]">
                                    How comfortable are you with plugin configuration and
                                    settings?
                                </h1>

                                <div
                                    class="flex justify-center flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                    <?php

                                    foreach ($comfortable_configuration_settings as $k6 => $v6) {

                                    ?>
                                        <a href="#"
                                            class="wizard-btn p-px group rounded-full bg-[#EEEEEE] hover:bg-gradient-to-r group-[.active]:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block comfortable_configuration_settings <?= (isset($user['comfortable_configuration_settings']) && $user['comfortable_configuration_settings'] == $k6) ? 'active' : '' ?>"
                                            data-comfortable_configuration_settings="<?= $k6 ?>">
                                            <span
                                                class="flex items-center pl-[30px] pr-[30px] hover:pr-2 group-[.active]:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                                <?= $v6 ?>
                                                <span
                                                    class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 group-[.active]:ml-2 opacity-0 group-hover:opacity-100 group-[.active]:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    <?php
                                    }

                                    ?>
                                </div>
                            </div>

                            <!-- wizard 7 -->
                            <div id="wizard-7"
                                class="wizard-content hidden fixed inset-0 flex items-center justify-center bg-[rgb(255_255_255_/_19%)] z-[9999]">
                                <div class="p-4 w-full max-w-[392px] mx-auto">
                                    <div
                                        class="p-6 flex justify-center items-center space-x-3 text-sm font-bold text-[#14243B] bg-white border border-[#F2F5FA] rounded-xl">
                                        <img class="animate-spin" src="assets/images/loader.svg" alt="loader" />
                                        <p>Processing...</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-center items-center space-x-2">
                <!-- sticky bottom button -->
                <div id="sticky-button-prev" class="sticky bottom-0 py-4">
                    <button
                        class="mx-auto block px-3.5 py-3.5 bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full duration-300 hover:opacity-75">
                        <img class="w-4 h-4 rotate-180"
                            src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                            alt="Arrow-Right" />
                    </button>
                </div>
                <div id="sticky-button" class="hidden sticky bottom-0 py-4">
                    <button
                        class="mx-auto block px-12 py-3.5 text-base text-white bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] font-bold rounded-full duration-300 hover:opacity-75">
                        Continue
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Modal wizard End-->