<?php
$is_clear_button_show = false;
?>
<div class="flex flex-wrap lg:flex-nowrap justify-between items-center lg:space-x-7">
    <?php
    if (!is_tax('plugin_category')) {
        ?>
        <!-- Filter section start -->
        <div class="w-[calc((100%-2px)/3)] lg:w-[82px] order-1">
            <div class="flex justify-center items-center border-y border-[#F2F2F2] lg:border-0">
                <button id="filterBtnLg"
                    class="group w-full p-3 lg:p-0 lg:py-2.5 lg:space-x-3 outline-none hidden lg:flex flex-col lg:flex-row items-center text-[10px] text-center lg:text-base text-black !leading-[120%] lg:!leading-[160%] font-bold duration-500 hover:opacity-70 relative"
                    type="button">
                    <span class="relative w-5 h-5 inline-block">
                        <img class="group-[.active]:opacity-0 opacity-100 absolute inset-0 w-5 h-5 object-contain transition-opacity duration-200"
                            src="<?php echo asset_image_path_generator() ?>filter.svg" alt="filter-image" />
                        <img class="group-[.active]:opacity-100 opacity-0 absolute inset-0 w-5 h-5 object-contain transition-opacity duration-200"
                            src="<?php echo asset_image_path_generator() ?>close-fill.svg" alt="filter-image" />
                    </span>
                    <p>Filters</p>
                </button>
                <button id="filterBtnMd"
                    class="w-full p-3 lg:p-0 lg:space-x-3 outline-none flex lg:hidden flex-col lg:flex-row items-center text-[10px] text-center lg:text-base text-black !leading-[120%] lg:!leading-[160%] font-bold duration-500 hover:opacity-70 relative"
                    type="button" data-drawer-target="leftSidebarMd" data-drawer-show="leftSidebarMd"
                    data-drawer-placement="bottom" aria-controls="leftSidebarMd">
                    <span class="relative w-5 h-5 inline-block">
                        <img id="filterShow" class="block w-5 h-5 object-contain transition-opacity duration-200"
                            src="<?php echo asset_image_path_generator() ?>filter.svg" alt="filter-image" />
                        <img id="filterClose" class="hidden w-5 h-5 object-contain transition-opacity duration-200"
                            src="<?php echo asset_image_path_generator() ?>close-fill.svg" alt="filter-image" />
                    </span>
                    <p>Filters</p>
                </button>
            </div>
        </div>
        <!-- Filter section End -->




        <div class="mt-[18px] lg:mt-0 w-full lg:w-[340px] order-6 lg:order-2">
            <div class="flex font-bold space-x-2">
                <div class="relative w-[calc(100%-74.583px)] lg:w-[78.24%]">
                    <div
                        class="absolute right-0 top-0 h-full w-5 z-10 bg-[linear-gradient(270deg,#FFFFFF_0%,rgba(255,255,255,0)_100%)]">
                    </div>
                    <div class="scrollSlider overflow-auto flex space-x-2 pr-20 scrollbarHide">
                        <?php
                        $supported_keys = ["rating", "overall_wpscore", "last_update", "active_install", "support_quality", "performace_impact", "user_review_sentiment", "multilingual_support"];
                        foreach ($supported_keys as $k) {
                            if (!empty($_GET[$k])) {
                                $is_clear_button_show = true;
                                ?>
                                <a href="#"
                                    class="px-3 py-1.5 flex justify-center items-center space-x-2 text-[10px] leading-[120%] bg-[#F2F2F2] border border-[#F2F2F2] rounded-full duration-300 hover:opacity-80">
                                    <p class="whitespace-nowrap flex gap-1">
                                        <?php echo $_GET[$k] ?>
                                        <?php if ($k == "rating") {
                                            ?>
                                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_9306_5431)">
                                                    <path
                                                        d="M6.0003 9.13L2.47357 11.1041L3.26124 7.13995L0.293945 4.3959L4.30747 3.92003L6.0003 0.25L7.6931 3.92003L11.7066 4.3959L8.73935 7.13995L9.527 11.1041L6.0003 9.13ZM6.0003 7.984L8.12365 9.17255L7.6494 6.78585L9.43595 5.1337L7.0195 4.84717L6.0003 2.63751L4.98107 4.84717L2.5646 5.1337L4.35115 6.78585L3.87691 9.17255L6.0003 7.984Z"
                                                        fill="#727C89"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_9306_5431">
                                                        <rect width="12" height="12" fill="white"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                            <?php
                                        }

                                        ?>

                                    </p>
                                    <span class="close_header_select" data-field="<?php echo $k ?>">
                                        <img class="w-4 min-w-4 h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() ?>close-line.svg" alt="close-line" />
                                    </span>
                                </a>

                                <?php
                            }
                        }
                        if (!empty($category_ids_array)) {
                            $is_clear_button_show = true;
                            //dd($_child_categories);
                            foreach ($_child_categories as $item) {
                                if (in_array($item['id'], $category_ids_array)) {
                                    ?>
                                    <a href="#"
                                        class="px-3 py-1.5 flex justify-center items-center space-x-2 text-[10px] leading-[120%] bg-[#F2F2F2] border border-[#F2F2F2] rounded-full duration-300 hover:opacity-80">
                                        <p class="whitespace-nowrap"><?php echo $item['name'] ?></p>
                                        <span class="close_header_select" data-cat_id_remove="<?php echo $item['id'] ?>">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?php echo asset_image_path_generator() ?>close-line.svg" alt="close-line" />
                                        </span>
                                    </a>

                                    <?php
                                }
                            }
                        }
                        if (!empty($selected_tag_ids_array)) {
                            $is_clear_button_show = true;
                            //dd($_child_categories);
                            foreach ($_all_child_tags as $item) {
                                if (in_array($item['id'], $selected_tag_ids_array)) {
                                    ?>
                                    <a href="#"
                                        class="px-3 py-1.5 flex justify-center items-center space-x-2 text-[10px] leading-[120%] bg-[#F2F2F2] border border-[#F2F2F2] rounded-full duration-300 hover:opacity-80">
                                        <p class="whitespace-nowrap"><?php echo $item['name'] ?></p>
                                        <span class="close_header_select" data-tag_id_remove="<?php echo $item['id'] ?>">
                                            <img class="w-4 min-w-4 h-4 object-contain object-center"
                                                src="<?php echo asset_image_path_generator() ?>close-line.svg" alt="close-line" />
                                        </span>
                                    </a>

                                    <?php
                                }
                            }
                        }
                        ?>

                    </div>
                </div>
                <?php
                if ($is_clear_button_show) {
                    ?>
                    <a href="#"
                        class="clear_all_filter px-3 py-1.5 flex justify-center items-center space-x-2 text-[10px] leading-[120%] border bg-white border-[#F2F2F2] rounded-full duration-300 hover:opacity-80">
                        <p class="whitespace-nowrap">Clear All</p>
                    </a>
                    <?php
                }
                ?>

            </div>
        </div>

        <div class="w-px self-stretch bg-[#F2F2F2] order-2 lg:order-3"></div>
        <?php
    }
    ?>
    <!-- search section start -->
    <div
        class="<?php echo (!is_tax('plugin_category')) ? "w-[calc((100%-2px)/3)] lg:w-[calc(46.89%-8px)] xl:w-full order-3 lg:order-4" : "w-[calc((100%-2px)/2)] lg:w-full order-3 lg:order-4" ?>">
        <div>
            <div class="flex items-center justify-center border-y border-[#F2F2F2] lg:border-0">
                <label class="hidden lg:block relative w-full" for="search">
                    <span class="absolute top-1/2 -translate-y-1/2 left-0 w-5 min-w-5 h-5">
                        <img class="w-full object-contain object-center home_fuzzy_search"
                            src="<?php echo asset_image_path_generator() ?>search.svg" alt="search-image" />
                    </span>
                    <button class="absolute top-1/2 -translate-y-1/2 right-0 w-5 min-w-5 h-5">
                        <img class="w-full object-contain object-center close_icon"
                            src="<?php echo asset_image_path_generator() ?>close-circle.svg" alt="close-circle-image" />
                    </button>
                    <input id="searchInput" type="text"
                        class=" w-full px-8 py-[14.8px] text-base font-normal leading-[160%] border-none placeholder:text-[#A1A7B1]"
                        value="<?php echo $search_text ?>" placeholder="Search plugins" />
                    <!-- Suggestion Dropdown -->
                    <div id="suggestionBox" class=" hidden absolute left-0 right-0 bg-white border border-gray-200 rounded-xl shadow-lg mt-1.5 z-50 
                                            overflow-y-auto max-h-64 scrollbarHide">
                    </div>
                </label>
                <button id="openSearch" class="w-full p-3 lg:hidden">
                    <img class="mx-auto w-5 min-w-5 h-5 object-contain object-center"
                        src="<?php echo asset_image_path_generator() ?>search.svg" alt="search-image" />
                    <p class="text-center text-[10px] leading-[120%] font-bold">
                        Search
                    </p>
                </button>
            </div>


        </div>
        <!-- Search Bottom Mobile Drawer -->
        <div>
            <div id="searchOverlay"
                class="lg:hidden fixed inset-0 bg-black/40 hidden opacity-0 transition-opacity duration-300 z-40">
            </div>
            <div id="searchSheet"
                class="lg:hidden fixed bottom-0 left-0 w-full bg-white rounded-t-xl translate-y-full transition-all duration-300 z-50">
                <div
                    class="py-9 px-[18px] flex justify-between items-center text-xl text-black border-b border-[#F2F2F2]">
                    <h3>Search</h3>
                    <button id="closeSearch">
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                            src="<?php echo asset_image_path_generator() ?>close-fill.svg" alt="" />
                    </button>
                </div>

                <div class="overflow-y-auto scrollbarHide">
                    <div class="max-h-[310px] py-9 px-[18px]">
                        <div class="border-b border-[#F2F2F2]">
                            <label class="relative w-full">
                                <span class="absolute top-1/2 -translate-y-1/2 left-0 w-5 min-w-5 h-5">
                                    <img class="w-5 min-w-5 h-5 object-contain object-center home_fuzzy_search"
                                        src="<?php echo asset_image_path_generator() ?>search.svg" alt="search-image" />
                                </span>
                                <button class="absolute top-1/2 -translate-y-1/2 right-0 w-5 min-w-5 h-5">
                                    <img class="w-5 min-w-5 h-5 object-contain object-center close_icon"
                                        src="<?php echo asset_image_path_generator() ?>close-circle.svg"
                                        alt="close-circle-image" />
                                </button>
                                <input type="text" id="searchInputM"
                                    class="w-full px-8 py-[14.8px] text-base font-normal leading-[160%] border-none placeholder:text-[#A1A7B1]"
                                    placeholder="Search Plugins" value="<?= $search_text ?>" />
                                <div id="suggestionBoxM" class=" hidden absolute left-0 right-0 bg-white border border-gray-200 rounded-xl shadow-lg mt-1.5 z-50 
                                                    overflow-y-auto max-h-64 scrollbarHide">
                                </div>
                            </label>
                        </div>

                        <!-- History -->
                        <div class="leading-[120%] pb-8">
                            <h3 class="py-8 text-[10px] font-bold">History</h3>

                            <div class="space-y-6 text-[13px] text-[#A1A7B1] font-normal" id="search_history_div_show">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- search section end -->

    <div class="w-px self-stretch bg-[#F2F2F2] order-4 lg:order-5"></div>

    <!-- Sort By section Start -->
    <div
        class="<?php echo (!is_tax('plugin_category')) ? "w-[calc((100%-2px)/3)] lg:w-[127px] lg:min-w-[127px] flex items-center justify-center order-5 lg:order-6 border-y border-[#F2F2F2] lg:border-0" : "w-[calc((100%-2px)/2)] lg:w-[127px] lg:min-w-[127px] flex items-center justify-center order-5 lg:order-6 border-y border-[#F2F2F2] lg:border-0" ?> ">
        <div class="group relative w-full">
            <button id="sortBtn" class="w-full p-3 lg:p-0 lg:py-1 lg:flex items-center lg:space-x-3 outline-none">
                <img class="mx-auto lg:mx-0 w-5 min-w-5 h-5 object-contain object-center"
                    src="<?php echo asset_image_path_generator() ?>category-page/filter.svg" alt="filter-image" />
                <div class="space-y-1.5 leading-none">
                    <p
                        class="flex items-center lg:justify-start justify-center text-[10px] font-bold lg:font-normal leading-[120%] text-[#000000] lg:text-[#727C89] whitespace-nowrap">
                        Sort <span class="hidden lg:block ml-0.5"> by:</span>
                    </p>
                    <div class="hidden lg:flex space-x-1.5">
                        <h4 class="text-base font-bold leading-[160%] text-[#000000]">
                            Relevance
                        </h4>
                        <img class="duration-500 group-hover:rotate-[-90deg]"
                            src="<?php echo asset_image_path_generator() ?>category-page/arrowDown.svg"
                            alt="arrowDown" />
                    </div>
                </div>
            </button>

            <!-- Dropdown Bottom Mobile Drawer -->
            <div id="mobileOverlay"></div>
            <div id="sortMenu"
                class="hidden absolute right-0 w-full lg:w-52 bg-white z-40 lg:z-20 text-[13px] leading-[120%] font-bold rounded-t-xl lg:rounded-none border border-[#f2f2f2]">
                <div
                    class="lg:hidden py-9 px-[18px] flex justify-between items-center text-xl text-black border-b border-[#F2F2F2]">
                    <h3>Sort by</h3>
                    <button>
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                            src="<?php echo asset_image_path_generator() ?>close-fill.svg" alt="" />
                    </button>
                </div>

                <div class="overflow-y-auto scrollbarHide h-[310px]">
                    <div class="py-6 px-[18px] space-y-2 text-[#727C89]">
                        <!-- OPTION TEMPLATE -->
                        <?php
                        foreach ($sort_by_key_mapping as $key => $value) {
                            ?>

                            <label for="sort_<?=$key?>" data-short_item="<?php echo $value["front_end"] ?>"
                                class="sortItem w-full flex items-center px-3 py-2.5 bg-[#F8F8F8] duration-300 rounded-full cursor-pointer outline-none <?php echo $sort_by == $value["front_end"] ? "active" : null ?>">
                                <img class="w-[13px] min-w-[13px] h-[9px] object-contain object-center"
                                    src="<?php echo asset_image_path_generator() ?>category-page/TickMark.svg"
                                    alt="TickMark" />
                                <span><?php echo $value["front_end"] ?></span>
                            </label>
                            <?php
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Sort By section end -->
</div>