<div class="w-full sm:w-[190px] sm:min-w-[190px]">
    <div class="xl:sticky xl:top-[85px]">
        <div
            class="px-3 py-[18px] space-y-1 font-bold bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] rounded-t-[30px] overflow-hidden">
            <div class="flex justify-between items-center">
                <h5 class="text-base leading-[160%] text-[#14243B3D] uppercase">
                    WPS
                </h5>
                <img class="openModalBtn w-4 h-4 min-w-4 object-contain object-center cursor-pointer duration-300 hover:opacity-60" data-plugin_id="<?= get_the_ID() ?>"
                    src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>" alt="Exclamation-Image" />
            </div>
            <div class="text-[#1A2DC9] space-y-1">
                <h2 class="text-[39px] leading-[120%]">
                    <?php echo $the_plugin_information->overall_wpscore; ?>
                </h2>
                <p class="text-base leading-[160%]">
                    <?php echo wps_score_description($the_plugin_information->overall_wpscore); ?>
                </p>
            </div>
        </div>
    </div>
    <div class="px-4 py-[18px] border border-[#F2F2F2] rounded-b-[30px] overflow-hidden space-y-[18px]">
        <div class="rounded-full">
            <a href="<?= $the_plugin_information->plugin_pro_version_link ? $the_plugin_information->plugin_pro_version_link : "#" ?>"
                class="w-full flex justify-center items-center py-[7.3px] px-1 text-base font-bold leading-[160%] text-white bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 hover:opacity-80 space-x-2.5 rounded-full">
                <span>Pro version</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M6.66667 4V5.33333H3.33333V12.6667H10.6667V9.33333H12V13.3333C12 13.7015 11.7015 14 11.3333 14H2.66667C2.29848 14 2 13.7015 2 13.3333V4.66667C2 4.29848 2.29848 4 2.66667 4H6.66667ZM14 2V7.33333H12.6667L12.6666 4.27533L7.4714 9.4714L6.52859 8.5286L11.7233 3.33333H8.66667V2H14Z"
                        fill="white" />
                </svg>
            </a>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>" alt="Star-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>Ratings</p>
                <span class="flex items-center">
                    <?php
                    $rating = percent_to_rating($the_plugin_information->rating)
                    ?>
                    <?php echo render_star_rating($rating) ?>
                </span>
                <strong class="text-[13px]">
                    <?= $rating ?> out of 5 |
                    <span class="text-[#1C37D1]"><?= $the_plugin_information->num_ratings ?></span>
                </strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'plugin-page/history-line.svg' ?>" alt="History-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>Version</p>
                <strong class="text-[13px]"><?= $the_plugin_information->version ?></strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'plugin-page/calendar-schedule-line.svg' ?>"
                alt="calendar-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>Last updated</p>
                <strong class="text-[13px]"><?= get_time_since_update($the_plugin_information->last_updated) ?></strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . '/bannerSlider/downlot.svg' ?>" alt="Star-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>Active installations</p>
                <strong class="text-[13px]"><?= number_format($the_plugin_information->active_installs) ?>+</strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>" alt="Star-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>WordPress version</p>
                <strong class="text-[13px]"><?= $the_plugin_information->tested ?> or higher</strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'plugin-page/php-line.svg' ?>" alt="php-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>PHP version</p>
                <strong class="text-[13px]"><?= $the_plugin_information->requires_php ?> or higher</strong>
            </div>
        </div>

        <div class="flex items-center space-x-3">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() . 'plugin-page/translate.svg' ?>" alt="translate-Image" />
            <div class="text-[10px] font-normal leading-[120%]">
                <p>Languages</p>
                <strong class="text-[13px]"><?= $the_plugin_information->localization_count ?></strong>
            </div>
        </div>

        <div class="text-[10px] font-normal leading-[120%]">
            <p class="mb-1">Tags</p>
            <strong class="text-[13px] break-words">
                <?= $the_plugin_information->plugin_tags ?>
            </strong>
        </div>
    </div>
</div>