<?php
/*
Template Name:Customized Plugin Recommendation
 */

// if (!is_user_logged_in()) {
//   // Redirect logged-in users to another page
//   wp_redirect(home_url('/sign-up')); // Replace '/another-page' with the desired URL slug
//   exit;
// }    // Ensures the script stops after redirection

if (empty($_POST)) {
  wp_redirect(home_url('/')); // Replace '/another-page' with the desired URL slug
  exit;
}
$user = [
  "type_website_building" => $_POST["type_website_building"],
  "builder_theme_using" => $_POST["builder_theme_using"],
  "features_need_in_site" => $_POST["features_need_in_site"],
  "budget_level_plugins" => $_POST["budget_level_plugins"],
  "monthly_traffic" => $_POST["monthly_traffic"],
  "comfortable_configuration_settings" => $_POST["comfortable_configuration_settings"]
];
$plugins = multistep_plugin_select_wizard::get_plugin_slug_for_recommandation($user);
$message = multistep_plugin_select_wizard::generate_recommendation_message_compact($user, $plugins);
$from_builder_notices = multistep_plugin_select_wizard::get_three_unique_ai_notices($user['builder_theme_using']);
if (is_user_logged_in()) {
$recommandation_row = multistep_plugin_select_wizard::save_date_personalized_plugin_recommendation($user, $message, $_POST["recommandation_id"]);
}else
{
    $guest_payload = [
        'user'    => $user,
        'message' => $message,
        'time'    => time()
    ];

    $encoded = base64_encode(json_encode($guest_payload));

    // Keep for 3 days
    setcookie(
        'wps_ai_guest_recommendation',
        $encoded,
        time() + (3 * DAY_IN_SECONDS),
        COOKIEPATH,
        COOKIE_DOMAIN,
        is_ssl(),
        true // HttpOnly
    );

    // wp_send_json_success([
    //     'guest_saved' => true,
    //     'signup_required' => true
    // ]);
}

// exit;
get_header()
  ?>
<main>
    <section class="sticky top-[72px] lg:top-[85.59px] z-10 border-y border-[#F2F2F2] bg-white">
        <div class="container">
            <div class="flex justify-between items-center space-x-3 md:space-x-5 xl:space-x-[30px]">
                <div class="space-x-3 md:space-x-5 xl:space-x-[30px] flex justify-start items-center">
                    <div class="">
                        <a href="<?= site_url() ?>">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?= asset_image_path_generator() ?>/home.svg" alt="home" />
                        </a>
                    </div>

                    <div class="w-px self-stretch bg-[#F2F2F2]"></div>
                    <?php
                    if (is_user_logged_in()) {
                        ?>
                    <div class="flex items-center justify-start space-x-3 md:space-x-5 xl:space-x-[30px]">
                        <div class="relative z-[999] w-full">
                            <input type="text" id="title_rename"
                                class="border-none break-all line-clamp-1 text-base font-bold !leading-[160%]"
                                value="<?php echo $recommandation_row ? $recommandation_row['recommendation_title'] : $message['title'] ?>">
                            <!-- Dropdown Bottom Mobile Drawer -->
                            <div id="mobileOverlay" class="z-[900]"></div>
                            <div id="sortMenu"
                                class="hidden absolute left-0 lg:mt-0.5 w-full lg:min-w-[528px] h-[52vh] lg:h-64 bg-white z-[1000] lg:z-20 text-[13px] lg:text-base !leading-[160%] font-bold rounded-t-xl lg:rounded-md overflow-hidden shadow-[0px_12px_12px_0px_#3941491F] lg:shadow-none">
                                <div
                                    class="lg:hidden py-[34px] px-[18px] flex justify-between items-center text-xl text-black border-b border-[#F2F2F2]">
                                    <h3 class="text-xl !leading-[120%]">Saved wizard</h3>
                                    <button>
                                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/close-fill.svg" alt="" />
                                    </button>
                                </div>

                                <div class="overflow-y-auto scrollbarHide h-[40vh] lg:h-64">
                                    <div class="lg:px-6 lg:!pb-0 py-6">
                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                E-commerce website email marketing plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/check-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Corporate website SEO and performance plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span> E-commerce website security plugins </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>

                                        <a href="#"
                                            class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                                            <div
                                                class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                                    src="<?= asset_image_path_generator() ?>/history-fill.svg"
                                                    alt="image-fill" />
                                            </div>
                                            <span>
                                                Blog website analytics and security plugins
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <a href="javascript:void(0)"
                            class="rename_the_title px-3 py-[7px] text-[13px] !leading-[120%] font-bold text-black bg-white hover:bg-[#F2F2F2] inline-block border border-[#F2F2F2] rounded-[54px] hover:opacity-80 duration-500 whitespace-nowrap">
                            Rename
                        </a>
                    </div>
                    <?php
                    }
                    ?>

                </div>

                <div class="flex items-center space-x-3 md:space-x-5 xl:space-x-[30px]">
                    <div class="w-px min-h-[50px] self-stretch bg-[#F2F2F2]"></div>
                    <div
                        class="hidden lg:flex items-center space-x-5 xl:space-x-[30px] text-[13px] text-black !leading-[120%] font-bold">
                        <p class="line-clamp-1">Created at
                            <?php echo $recommandation_row ? date('M d, Y', strtotime($recommandation_row["created_at"])) : date('M d, Y'); ?>
                        </p>
                        <div class="w-px self-stretch bg-[#F2F2F2]"></div>
                        <div class="flex min-h-[50px] items-center space-x-2">
                            <?php
                          if(is_user_logged_in())
                          {
                            ?>
                            <a href="javascript:void(0)"
                                class="px-3 py-[7px] text-black bg-white hover:bg-[#F2F2F2] inline-block border border-[#F2F2F2] rounded-[54px] hover:opacity-80 duration-500 whitespace-nowrap delete"
                                data-id="<?= $recommandation_row["id"] ?>">
                                Delete
                            </a>

                            <?php
                          }
                          ?>

                            <a href="javascript:void(0)" id="openModal"
                                class="px-3 py-2 text-white inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
                                Change my answer
                            </a>
                        </div>
                    </div>
                    <div class="lg:hidden">
                        <a href="javascript:void(0)" class="hover:opacity-60 duration-500">
                            <img class="w-5 min-w-5 h-5 object-contain object-center"
                                src="<?= asset_image_path_generator() ?>/information-2-line.svg" alt="exclamation" />
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section
        class="relative pt-20 pb-28 md:pt-[120px] md:pb-[150px] lg:pt-[145px] lg:pb-[248px] bg-gradient-to-t from-[#A4E4FF] to-[#ffffff]">
        <div
            class="z-[1] absolute -bottom-[0.4px] left-0 w-full h-[100px] md:h-[160px] lg:h-[208px] bg-white [clip-path:polygon(0_100%,100%_1.5%,100%_100%,0_100%)]">
        </div>
        <div class="container">
            <div class="max-w-[790px] mx-auto">
                <div class="text-center space-y-6 lg:space-y-8 text-base !leading-[160%] font-bold">
                    <div class="relative">
                        <div class="absolute -top-12 left-[7%]">
                            <img class="w-11 lg:min-w-[54px] h-11 lg:min-h-[54px]"
                                src="<?= asset_image_path_generator() ?>/1-after.svg" alt="" />
                        </div>
                        <div class="absolute top-[67%] sm:top-[33%] lg:top-[25%] right-0 xl:-right-1.5">
                            <img class="w-8 lg:min-w-[42px] h-8 lg:min-h-[42px]"
                                src="<?= asset_image_path_generator() ?>/2-after.svg" alt="" />
                        </div>
                        <h1 class="text-4xl md:text-5xl lg:text-[61px] !leading-[120%]">
                            Let’s take your
                            <span
                                class="bg-gradient-to-r from-[#1650D7] to-[#0EF0AA] bg-clip-text text-transparent"><?= multistep_plugin_select_wizard::type_website_building()[$user["type_website_building"]] ?></span>
                            website to the next level
                        </h1>
                    </div>

                    <p class="">
                        <?= $message["message"] ?>
                    </p>
                    <div class="flex justify-center items-center">
                        <a href="#resultSection"
                            class="px-8 py-5 text-white inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
                            Show me the result
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding bg-gradient-to-b from-white to-[#A4E4FF]">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <div class="max-w-[800px] mx-auto text-center">
                        <h2 class="text-3xl md:text-4xl lg:text-[49px] !leading-[120%] font-bold">
                            Before continue, is your
                            <span
                                class="bg-gradient-to-r from-[#1650D7] to-[#0EF0AA] bg-clip-text text-transparent">corporate</span>
                            website experiencing any of these challenges?
                        </h2>
                    </div>

                    <div class="-m-3 lg:-m-4">
                        <div class="flex flex-wrap justify-center">
                            <?php
              foreach ($from_builder_notices as $k => $v) {
                ?>

                            <div
                                class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] lg:w-[calc(33.33333%-32px)] m-3 lg:m-4 md:px-6 text-center space-y-6 lg:space-y-8 text-black">
                                <div
                                    class="flex justify-center items-center mx-auto w-12 min-w-12 h-12 object-contain object-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                                        src="<?= asset_image_path_generator() ?>/<?= $v["icon"] ?>" alt="times" />
                                </div>
                                <div class="space-y-2">
                                    <h3 class="text-xl md:text-[22px] lg:text-[25px] font-bold !leading-[120%]">
                                        <?= $v["title"] ?>
                                    </h3>
                                    <p class="text-base !leading-[160%] font-normal">
                                        <?= $v["text"] ?>
                                    </p>
                                </div>
                            </div>

                            <?php
              }

              ?>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding pb-10 md:pb-12 lg:!pb-[60px]">
        <div class="container">
            <div class="">
                <div class="max-w-[800px] mx-auto text-center">
                    <h2 class="text-3xl md:text-4xl lg:text-[49px] !leading-[120%] font-bold">
                        If yes, here are some plugins that align perfectly with your

                        <span
                            class="bg-gradient-to-r from-[#1650D7] to-[#0EF0AA] bg-clip-text text-transparent"><?= $user['type_website_building'] ?></span>
                        website
                    </h2>
                </div>
            </div>
        </div>
    </section>
    <?php
  $template = get_template_directory() . '/frontend/plugin-recommandation-includes/result.php';

  if (file_exists($template)) {
    include $template;
  }
  ?>




    <!-- sign in modal start -->
    <section>
        <div id="openModalBtnSingIn" class="fixed inset-0 bg-black/60 flex items-center justify-center hidden z-50">
            <div class="mx-4 max-w-[392px] w-full max-h-[90vh]">
                <div class="overflow-y-auto flex-1">
                    <div class="">
                        <form action="">
                            <div class="space-y-9 p-6 bg-white border border-[#F2F5FA] rounded-xl">
                                <div
                                    class="flex justify-center items-center mx-auto w-12 min-w-12 h-12 object-contain object-center bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] rounded-full">
                                    <!-- <img
                        class="w-6 min-w-6 h-6 object-contain object-center"
                        src="<?= asset_image_path_generator() ?>/times.svg"
                        alt="times"
                      /> -->
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M7 10H20C20.5523 10 21 10.4477 21 11V21C21 21.5523 20.5523 22 20 22H4C3.44772 22 3 21.5523 3 21V11C3 10.4477 3.44772 10 4 10H5V9C5 5.13401 8.13401 2 12 2C14.7405 2 17.1131 3.5748 18.2624 5.86882L16.4731 6.76344C15.6522 5.12486 13.9575 4 12 4C9.23858 4 7 6.23858 7 9V10ZM10 15V17H14V15H10Z"
                                            fill="white" />
                                    </svg>
                                </div>
                                <h1 class="text-xl lg:text-[25px] text-center font-bold !leading-[120%]">
                                    Please sign in to see the results
                                </h1>

                                <div class="text-base text-[#14243B] font-bold !leading-[160%] space-y-1.5">
                                    <a href="<?= site_url() ?>"
                                        class="w-full px-6 sm:px-9 py-[15px] space-x-2.5 sm:space-x-[18px] outline-none flex items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300">
                                        <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/facebook.svg"
                                            alt="Facebook Image" />
                                        <span>Sign in with Facebook</span>
                                    </a>

                                    <a href="<?= site_url() ?>"
                                        class="w-full px-6 sm:px-9 py-[15px] space-x-2.5 sm:space-x-[18px] outline-none flex items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300">
                                        <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/google.svg" alt="Facebook Image" />
                                        <span>Sign in with Google</span>
                                    </a>

                                    <a href="<?= site_url() ?>"
                                        class="w-full px-6 sm:px-9 py-[15px] space-x-2.5 sm:space-x-[18px] outline-none flex items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300">
                                        <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                                            src="<?= asset_image_path_generator() ?>/wordPress.svg"
                                            alt="Facebook Image" />
                                        <span>Sign in with WordPress.com</span>
                                    </a>
                                </div>

                                <label
                                    class="flex space-x-3 text-[#727C89] text-[10px] font-normal leading-[120%] cursor-pointer">
                                    <input type="checkbox"
                                        class="w-6 h-6 text-lg text-blue-600 outline-none rounded-md" />
                                    <p>
                                        By continuing, you agree that you will receive emails
                                        from us (which you can opt-out anytime) and to our
                                        <a href="#" class="text-[#1A2DC9]">
                                            Terms & Conditions, Cookie Policy
                                        </a>
                                        &
                                        <a href="#" class="text-[#1A2DC9]"> Privacy Policy </a>.
                                    </p>
                                </label>

                                <div class="space-y-[18px]">
                                    <div class="flex items-center space-x-2.5">
                                        <span class="w-full h-px bg-[#F2F5FA]"></span>
                                        <p class="text-sm font-medium leading-[100%]">Or</p>
                                        <span class="w-full h-px bg-[#F2F5FA]"></span>
                                    </div>

                                    <div class="relative">
                                        <div class="absolute top-1/2 -translate-y-1/2 left-4">
                                            <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                                                src="<?= asset_image_path_generator() ?>/email.svg" alt="" />
                                        </div>
                                        <input id="email" type="email" name="email" placeholder="Enter your email"
                                            class="w-full py-[15px] pl-10 pr-12 text-black outline-none border border-[#F2F5FA] placeholder-[#727C89] rounded-md duration-300" />
                                        <div class="absolute top-1/2 -translate-y-1/2 right-[3px] z-10">
                                            <button
                                                class="group px-[9px] py-[13px] bg-[linear-gradient(180deg,#F2F5FA_0%,rgba(248,249,249,0.5)_100%)] outline-none rounded-md hover:bg-[#075fec] duration-300">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    class="group-hover:fill-white" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"
                                                        fill="#1A2DC9" />
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <p class="px-6 py-[19px] text-[#727C89] text-center text-base font-normal !leading-[160%]">
                            Not a member?
                            <a href="#" class="text-[#1A2DC9]">Register now</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- sign in modal end -->

    <?php
  $template = get_template_directory() . '/frontend/user-dashboard-includes/plugin-search-modal-wizard.php';

  if (file_exists($template)) {
    include $template;
  }
  ?>
    <form action="<?= site_url('/plugin-recommendation') ?>" method="post" id="form_recommandation">
        <input type="hidden" name="type_website_building" id="type_website_building"
            value="<?= isset($user['type_website_building']) ? esc_attr($user['type_website_building']) : '' ?>">
        <input type="hidden" name="builder_theme_using" id="builder_theme_using"
            value="<?= isset($user['builder_theme_using']) ? esc_attr($user['builder_theme_using']) : '' ?>">
        <input type="hidden" name="features_need_in_site" id="features_need_in_site"
            value="<?= isset($user['features_need_in_site']) ? esc_attr($user['features_need_in_site']) : '' ?>">
        <input type="hidden" name="budget_level_plugins" id="budget_level_plugins"
            value="<?= isset($user['budget_level_plugins']) ? esc_attr($user['budget_level_plugins']) : '' ?>">
        <input type="hidden" name="monthly_traffic" id="monthly_traffic"
            value="<?= isset($user['monthly_traffic']) ? esc_attr($user['monthly_traffic']) : '' ?>">
        <input type="hidden" name="comfortable_configuration_settings" id="comfortable_configuration_settings"
            value="<?= isset($user['comfortable_configuration_settings']) ? esc_attr($user['comfortable_configuration_settings']) : '' ?>">
        <?php
            if (is_user_logged_in()) {
              ?>
        <input type="hidden" name="recommandation_id" id="recommandation_id" value="<?= $recommandation_row["id"] ?>">
        <?php
            }
            ?>

    </form>
</main>
<?php
$template = get_template_directory() . '/frontend/user-dashboard-includes/shared_javascript.php';

if (file_exists($template)) {
  include $template;
}
if(!is_user_logged_in())
{
    ?>
<script>
jQuery(function($) {
    const signupNotice = `
<div class="fixed inset-0 bg-black/60 flex items-center justify-center z-50">
    <div class="bg-white w-full max-w-md rounded-xl shadow-lg p-6 relative text-center">

        <button id="closeSignupNotice" class="absolute top-3 right-3 text-gray-500 hover:text-black text-xl">&times;</button>

        <h2 class="text-xl font-semibold mb-3">Save Your Results</h2>

        <p class="text-gray-600 mb-6">
            Please sign up to save your recommendations and access them anytime from your dashboard.
        </p>

        <div class="flex flex-col gap-3">
            <a href="<?=site_url('/sign-up')?>" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg text-center">
                Sign Up
            </a>

            <button id="continueWithoutSignup" 
                class="text-gray-500 hover:text-black underline">
                Continue without saving
            </button>
        </div>

    </div>
</div>
`;

    $("#infoModal").html(signupNotice).removeClass("hidden");
    $("body").addClass("overflow-hidden");
    // Close handlers
    $(document).on("click", "#closeSignupNotice, #continueWithoutSignup", function() {
        $("#infoModal").addClass("hidden").html("");
        $("body").removeClass("overflow-hidden");
    });
})
</script>
<?php
}
?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
jQuery(function($) {
    $(".rename_the_title").on('click', function(e) {
        e.preventDefault();


        /* ---------------------------
         * AJAX submit
         * --------------------------- */
        Swal.showLoading();



        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>', // WordPress safe
            type: "POST",
            dataType: 'json',
            data: {
                action: "rename_the_title",
                title: $("#title_rename").val(),
                id: $("#recommandation_id").val()
            },
            success: function(data) {

                Swal.fire({
                    // position: 'top-end',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 2500
                })
            }
        });
    })
    $(document).on("click", ".delete", function(e) {
        e.preventDefault();

        const id = $(this).data("id");

        Swal.fire({
            title: "Are you sure?",
            text: "This will permanently delete this entry.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, delete it",
            cancelButtonText: "Cancel",
            confirmButtonColor: "#d33",
        }).then((result) => {

            if (!result.isConfirmed) return;

            Swal.showLoading();

            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: "POST",
                dataType: "json",
                data: {
                    action: "delete_recommendation",
                    id: id
                },
                success: function(response) {

                    if (response.success) {

                        // 🔥 Remove from DOM with animation

                        Swal.fire({
                            icon: "success",
                            title: "Deleted!",
                            text: "Entry has been removed.",
                            timer: 2000,
                            showConfirmButton: false
                        });
                        location.replace("<?= site_url('/dashboard') ?>");

                    } else {
                        Swal.fire("Error", response.data || "Delete failed",
                            "error");
                    }
                },
                error: function() {
                    Swal.fire("Error", "Server error occurred", "error");
                }
            });

        });
    });
});
</script>
<?php
get_footer();