<?php
/*
Template Name:Customized Sign up
 */
if (is_user_logged_in()) {
  // Redirect logged-in users to another page
  wp_redirect(home_url('/')); // Replace '/another-page' with the desired URL slug
  exit; // Ensures the script stops after redirection
}
get_header();
?>
<main>
  <section
    class="min-h-[calc(100vh-72px)] lg:min-h-[calc(100vh-85.59px)] sectionPadding bg-[linear-gradient(180deg,#FFFFFF_36.3%,#A4E4FF_178.33%)]"
    id="resubmit_magic_link_load_here">
    <div class="container">
      <div class="w-full max-w-[392px] mx-auto">
        <div class="space-y-3">
          <form action="" id="login_signup_form">
            <div class="space-y-7 lg:space-y-9 p-6 bg-white border border-[#F2F5FA] rounded-xl">
              <div
                class="mx-auto w-16 min-w-16 h-16 lg:w-[72px] lg:min-w-[72px] lg:h-[72px] flex justify-center items-center bg-gradient-to-b from-white to-[#02AAF2]/25 rounded-full">
                <img class="w-8 min-8 h-8 lg:w-10 lg:min-10 lg:h-10 object-contain object-center"
                  src="<?= asset_image_path_generator() ?>/signIn.svg" alt="signIn" />
              </div>

              <h1 class="text-3xl md:text-4xl lg:text-[49px] text-center font-bold leading-[120%]">
                Sign in
              </h1>

              <label class="hidden flex space-x-3 text-[#727C89] text-[10px] font-normal leading-[120%] cursor-pointer">
                <input type="checkbox" class="w-6 h-6 text-lg text-blue-600 outline-none rounded-md"
                  id="checkbox_check_confirm" />
                <p>
                  By continuing, you agree that you will receive emails from
                  us (which you can opt-out anytime) and to our
                  <a href="<?= site_url('/terms-conditions') ?>" class="text-[#1A2DC9]">
                    Terms & Conditions, Cookie Policy
                  </a>
                  &
                  <a href="<?= site_url('/privacy-policy') ?>" class="text-[#1A2DC9]"> Privacy Policy </a>.
                </p>
              </label>

              <div class="space-y-4">
                <div class="relative">
                  <div class="absolute top-1/2 -translate-y-1/2 left-4">
                    <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                      src="<?= asset_image_path_generator() ?>/email.svg" alt="" />
                  </div>
                  <input id="email" type="email" name="email" placeholder="Enter your email"
                    class="noAutofillBg w-full p-[15px] !pl-10 text-black outline-none border border-[#F2F5FA] placeholder-[#727C89] rounded-md duration-300 focus:!border-blue-500 focus:!ring-0 focus:!ring-blue-500 focus:!ring-offset-0" />
                </div>

                <button
                  class="w-full px-5 lg:px-6 py-3 lg:py-[14px] text-white bg-blue-700 inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
                  Continue
                </button>
              </div>

              <div class="flex items-center space-x-2.5">
                <span class="w-full h-px bg-[#F2F5FA]"></span>
                <p class="text-sm font-medium leading-[100%]">Or</p>
                <span class="w-full h-px bg-[#F2F5FA]"></span>
              </div>

              <div class="flex justify-center items-center space-x-1.5">
                <a href="javascript:void(0)"
                  class="w-12 min-w-12 h-12 flex justify-center items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300 hover:border hover:border-blue-600">
                  <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                    src="<?= asset_image_path_generator() ?>/facebook.svg" alt="Facebook Image" />
                </a>

                <a href="<?php echo User_login_registration::create_google_login_callback() ?>"
                  class="w-12 min-w-12 h-12 flex justify-center items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300 hover:border hover:border-blue-600">
                  <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                    src="<?= asset_image_path_generator() ?>/google.svg" alt="Facebook Image" />
                </a>

                <a href="javascript:void(0)"
                  class="w-12 min-w-12 h-12 flex justify-center items-center bg-[linear-gradient(180deg,_#F2F5FA_0%,_rgba(248,249,249,0.5)_100%)] rounded-full hover:shadow-[0px_12px_24px_0px_#1C39D21F] duration-300 hover:border hover:border-blue-600">
                  <img class="w-[18px] min-[18px] h-[18px] object-contain object-center"
                    src="<?= asset_image_path_generator() ?>/wordPress.svg" alt="Facebook Image" />
                </a>
              </div>
            </div>
          </form>

          <p class="hidden px-6 py-[19px] text-[#727C89] text-center text-base font-normal leading-[160%]">
            Not a member?
            <a href="#" class="text-[#1A2DC9]">Register now</a>
          </p>
        </div>
      </div>
    </div>
  </section>

</main>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  jQuery(function ($) {
    function isValidEmail(email) {
      // Basic email regex pattern
      const pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return pattern.test(email);
    }
    function startCountdown(unixTime) {
      const timerEl = document.getElementById('time_count');

      function updateTimer() {
        const now = Math.floor(Date.now() / 1000); // current time in seconds
        let remaining = unixTime - now;

        if (remaining <= 0) {
          timerEl.textContent = '00:00';
          clearInterval(interval);
          return;
        }

        const minutes = Math.floor(remaining / 60);
        const seconds = remaining % 60;

        timerEl.textContent =
          String(minutes).padStart(2, '0') + ':' +
          String(seconds).padStart(2, '0');
      }

      updateTimer(); // initial call
      const interval = setInterval(updateTimer, 1000);
    }
    $("#login_signup_form").on("submit", function (e) {
      e.preventDefault();

      /* ---------------------------
       * Checkbox validation
       * --------------------------- */
      // if (!$("#checkbox_check_confirm").is(":checked")) {
      //   Swal.fire({
      //     icon: "warning",
      //     text: "Please confirm by checking the checkbox",
      //     showConfirmButton: false,
      //     timer: 2500
      //   });
      //   return;
      // }

      /* ---------------------------
       * Email validation
       * --------------------------- */
      if (!isValidEmail($("#email").val())) {
        Swal.fire({
          icon: "warning",
          text: "Correct email required",
          showConfirmButton: false,
          timer: 2500
        });
        return;
      }

      /* ---------------------------
       * AJAX submit
       * --------------------------- */
      Swal.showLoading();

      const formData = $(this).serialize();

      $.ajax({
        url: '<?php echo admin_url('admin-ajax.php'); ?>', // WordPress safe
        type: "POST",
        data: {
          action: "create_magic_link_login_registration",
          formData: formData,
        },
        success: function (data) {
          Swal.close();
          $("#resubmit_magic_link_load_here").html(data);
          startCountdown($("#time_count").data("time_limit"));
        }
      });

    });

    $(document).on("click", "#again_email_sent", function (e) {
      e.preventDefault();
      $("#magic_link_resubmit").trigger("submit");
    });

    // Submit magic link resend form
    $(document).on("submit", "#magic_link_resubmit", function (e) {
      e.preventDefault();

      Swal.showLoading();

      const formData = $(this).serialize();

      $.ajax({
        url: '<?php echo admin_url('admin-ajax.php'); ?>', // WordPress safe
        type: "POST",
        data: {
          action: "create_magic_link_login_registration",
          formData: formData,
        },
        success: function (data) {
          Swal.close();

          // Append instead of replace
          $("#resubmit_magic_link_load_here").html(data);
          startCountdown($("#time_count").data("time_limit"));
        }
      });
    });
  })



  // 🔹 Example usage


</script>
<?php
get_footer();
