<?php
class User_login_registration
{
   public static function create_magic_link_login_registration()
   {
      $formdata = [];
      parse_str($_POST['formData'], $formdata);

      $email = isset($formdata['email']) ? sanitize_email($formdata['email']) : '';

      if (!is_email($email)) {
         return new WP_Error('invalid_email', 'Invalid email address.');
      }

      $user = get_user_by('email', $email);

      if (!$user) {
         // Create a new user if not exists
         $username = sanitize_user($email);
         $password = wp_generate_password();
         $user_id = wp_create_user($username, $password, $email);

         if (is_wp_error($user_id)) {
            return $user_id;
         }

         $user = get_user_by('id', $user_id);
      }

      // Generate a unique token and expiration
      $token = wp_generate_password(32, false);
      $expiration = time() + magic_link_validate_time * MINUTE_IN_SECONDS; // 15 minutes

      // Save to user meta
      update_user_meta($user->ID, 'magic_login_token', $token);
      update_user_meta($user->ID, 'magic_login_expires', $expiration);

      // Build login URL
      $login_url = add_query_arg([
         'magic_login' => '1',
         'email' => rawurlencode($email),
         'token' => $token,
      ], site_url());

      add_filter('wp_mail_content_type', function () {
         return 'text/html';
      });
      $magic_link_validate_time = magic_link_validate_time;
      // Send the email
      $subject = 'Your Magic Login Link';
      $message = "
    <p>Click the button below to log in. This link will expire in {$magic_link_validate_time} minutes.</p>
    <a href='$login_url' style='
        display: inline-block;
        padding: 10px 20px;
        font-size: 16px;
        color: white;
        background-color: #0073aa;
        text-decoration: none;
        border-radius: 5px;
    '>Log In Now</a>
";

      wp_mail($email, $subject, $message);

      // Reset content type to avoid affecting other emails
      remove_filter('wp_mail_content_type', 'set_html_content_type');

      $template = get_template_directory() . '/frontend/user-dashboard-includes/resend-magic-link.php';

      if (file_exists($template)) {
         include $template;
      }
      wp_die();
   }

   public static function handle_magic_login()
   {

      if (!isset($_GET['magic_login']) || $_GET['magic_login'] != '1') {
         return;
      }

      $email = isset($_GET['email']) ? sanitize_email($_GET['email']) : '';
      $token = isset($_GET['token']) ? sanitize_text_field($_GET['token']) : '';

      $user = get_user_by('email', $email);
      if (!$user) {
         wp_die('Invalid user.');
      }

      $saved_token = get_user_meta($user->ID, 'magic_login_token', true);
      $expires = (int) get_user_meta($user->ID, 'magic_login_expires', true);

      if (!$saved_token || !$expires || time() > $expires) {
         wp_die('This login link has expired.');
      }

      if (!hash_equals($saved_token, $token)) {
         wp_die('Invalid token.');
      }

      // Clean up
      delete_user_meta($user->ID, 'magic_login_token');
      delete_user_meta($user->ID, 'magic_login_expires');

      // Log the user in manually
      wp_set_current_user($user->ID);
      wp_set_auth_cookie($user->ID, true); // true = remember me

      update_user_meta($user->ID, 'login_type', "Magic Link");
      // 🔥 Fire login-related hooks manually
      do_action('wp_login', $user->user_login, $user);
      do_action('user_login', $user->user_login, $user); // optional
      do_action('login_form'); // if you want to simulate login_form behavior

      // Redirect after login
      wp_redirect(home_url('/dashboard')); // or your own redirect
      exit;
   }
   public static function create_google_login_callback()
   {
      $client_id = get_option('google_client_id');
      $redirect_uri = home_url('/?google_login=1');

      if (empty($client_id)) {
         error_log('Google OAuth: client_id not configured');
         return '#';
      }

      return "https://accounts.google.com/o/oauth2/v2/auth?" . http_build_query([
         'client_id' => $client_id,
         'redirect_uri' => $redirect_uri,
         'response_type' => 'code',
         'scope' => 'email profile',
         'access_type' => 'offline',
         'prompt' => 'select_account'
      ]);
   }
   public static function save_remote_profile_image($image_url, $user_id)
   { // Get WordPress upload directory info

      $profile_image_from_iky = get_user_meta($user_id, 'profile_image_from_iky', true);
      if ($profile_image_from_iky) {
         return;
      }

      $upload_dir = wp_upload_dir();
      $upload_path = $upload_dir['path'] . '/';
      $filename = 'profile_' . $user_id . '.webp'; // Final WebP filename
      $new_file_path = $upload_path . $filename;

      // Get old relative path and unlink if it exists
      $old_relative_path = get_user_meta($user_id, 'profile_image', true);
      if ($old_relative_path) {
         // Ensure there's exactly one slash between basedir and subdir
         $old_file_path = trailingslashit($upload_dir['basedir']) . ltrim($old_relative_path, '/');

         if (file_exists($old_file_path)) {
            unlink($old_file_path);
         }
      }

      // Download image to a temp file first
      $image_data = file_get_contents($image_url);
      if (!$image_data) {
         return;
      }

      $temp_file = $upload_path . 'temp_profile_image_' . $user_id;
      file_put_contents($temp_file, $image_data);

      // Get mime type
      $file_info = getimagesize($temp_file);
      if (!$file_info) {
         unlink($temp_file);
         return;
      }

      $file_type = $file_info['mime'];

      switch ($file_type) {
         case 'image/jpeg':
            $image = imagecreatefromjpeg($temp_file);
            break;
         case 'image/png':
            $image = imagecreatefrompng($temp_file);
            break;
         case 'image/gif':
            $image = imagecreatefromgif($temp_file);
            break;
         case 'image/webp':
            $image = imagecreatefromwebp($temp_file);
            break;
         default:
            unlink($temp_file);
            return;
      }

      // Convert and save as WebP
      if ($image && imagewebp($image, $new_file_path, 80)) {
         imagedestroy($image);
         unlink($temp_file);

         // Save relative URL to user meta
         $relative_path = $upload_dir['subdir'] . '/' . $filename;
         update_user_meta($user_id, 'profile_image', $relative_path);
         // update_user_meta($user_id, 'profile_image_from_iky', 1);
      } else {
         imagedestroy($image);
         unlink($temp_file);
      }

   }
   public static function save_user_settings()
   {
      $formdata = [];
      parse_str($_POST['formData'], $formdata);
      $name = $formdata['name'];
      $name_in_arr = explode(' ', $name);
      $first_name = trim($name_in_arr[0]);
      $last_name = trim($name_in_arr[1]);
      $user_id = $formdata['user_id'];
      update_user_meta($user_id, 'first_name', $first_name);
      update_user_meta($user_id, 'last_name', $last_name);
      if (isset($formdata['subscribe_to_newslatter'])) {

         update_user_meta($user_id, 'subscribe_to_newslatter', true);
      } else {
         delete_user_meta($user_id, 'subscribe_to_newslatter');
      }
      echo json_encode([
         'success' => true,
         'completing_preferences_information' => $_POST['_completing_preferences_information'] == 0 ? true : false
         //'account_tab_first_time_complete'=>true
      ]);
      exit;
   }
   public static function wps_ai_guest_recommendation($user_login, $user)
   {

      if (empty($_COOKIE['wps_ai_guest_recommendation'])) {
         return;
      }

      $data = json_decode(base64_decode($_COOKIE['wps_ai_guest_recommendation']), true);

      if (!is_array($data) || empty($data['user']) || empty($data['message'])) {
         return;
      }

      multistep_plugin_select_wizard::save_date_personalized_plugin_recommendation(
         $data['user'],
         $data['message'],
         null
      );

      // Destroy cookie after successful save
      setcookie('wps_ai_guest_recommendation', '', time() - 3600, COOKIEPATH, COOKIE_DOMAIN);
   }
   public static function handle_google_login()
   {
      // CRITICAL: Only proceed if this is a Google OAuth callback
      // Check for the google_login parameter first
      if (!isset($_GET['google_login']) || $_GET['google_login'] != '1') {
         return; // Not a Google callback, exit immediately
      }

      // Now check for the authorization code
      if (!isset($_GET['code'])) {
         error_log('Google OAuth: No authorization code received');
         self::handle_oauth_error('Authorization code not received from Google.');
         return;
      }

      // Start output buffering to prevent "headers already sent" errors
      if (!headers_sent()) {
         ob_start();
      }

      // Log that we're processing Google login
      error_log('Google OAuth: Processing login callback');

      $client_id = get_option('google_client_id');
      $client_secret = get_option('google_client_secret');
      $redirect_uri = home_url('/?google_login=1');
      $code = sanitize_text_field($_GET['code']);

      // Validate configuration
      if (empty($client_id) || empty($client_secret)) {
         error_log('Google OAuth: Missing client_id or client_secret');
         self::handle_oauth_error('Google OAuth is not properly configured.');
         return;
      }

      // Exchange code for access token
      $response = wp_remote_post('https://oauth2.googleapis.com/token', [
         'timeout' => 30,
         'body' => [
            'code' => $code,
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'redirect_uri' => $redirect_uri,
            'grant_type' => 'authorization_code'
         ]
      ]);

      if (is_wp_error($response)) {
         error_log('Google OAuth: Token exchange error - ' . $response->get_error_message());
         self::handle_oauth_error('Error contacting Google.');
         return;
      }

      $body = json_decode(wp_remote_retrieve_body($response), true);

      if (!isset($body['access_token'])) {
         $error_msg = isset($body['error_description']) ? $body['error_description'] : 'Unknown error';
         error_log('Google OAuth: No access token - ' . $error_msg);
         self::handle_oauth_error('Failed to get access token.');
         return;
      }

      $access_token = $body['access_token'];

      // Get user info from Google
      $user_info_response = wp_remote_get('https://www.googleapis.com/oauth2/v1/userinfo?alt=json', [
         'timeout' => 30,
         'headers' => ['Authorization' => 'Bearer ' . $access_token]
      ]);

      if (is_wp_error($user_info_response)) {
         error_log('Google OAuth: User info fetch error - ' . $user_info_response->get_error_message());
         self::handle_oauth_error('Error fetching user info.');
         return;
      }

      $user_info = json_decode(wp_remote_retrieve_body($user_info_response), true);

      if (!isset($user_info['email'])) {
         error_log('Google OAuth: No email in response');
         self::handle_oauth_error('Could not retrieve email from Google.');
         return;
      }

      $email = sanitize_email($user_info['email']);
      $name = sanitize_text_field($user_info['name']);
      $picture = isset($user_info['picture']) ? $user_info['picture'] : '';

      // Check if user exists
      $user = get_user_by('email', $email);

      if (!$user) {
         // Create new user
         $username = sanitize_user($email);
         $password = wp_generate_password(20, true, true);
         $user_id = wp_create_user($username, $password, $email);

         if (is_wp_error($user_id)) {
            error_log('Google OAuth: User creation failed - ' . $user_id->get_error_message());
            self::handle_oauth_error('Could not create user account.');
            return;
         }

         $user = get_user_by('ID', $user_id);

         // Set user name
         $parts_of_name = explode(' ', $name, 2);
         update_user_meta($user->ID, 'first_name', $parts_of_name[0]);

         if (isset($parts_of_name[1])) {
            update_user_meta($user->ID, 'last_name', $parts_of_name[1]);
         }

         // Set display name
         wp_update_user([
            'ID' => $user->ID,
            'display_name' => $name
         ]);

         // Save profile image
         if (!empty($picture)) {
            self::save_remote_profile_image($picture, $user->ID);
         }

         // Set login type
         update_user_meta($user->ID, 'login_type', 'Gmail');

         // Log the user in
         wp_set_current_user($user->ID);
         wp_set_auth_cookie($user->ID, true);

         // Fire login hooks
         do_action('wp_login', $user->user_login, $user);

         error_log('Google OAuth: New user logged in - ' . $email);

         // Clean output buffer before redirect
         if (ob_get_length()) {
            ob_end_clean();
         }

         // Redirect after login
         wp_safe_redirect(home_url('/dashboard'));
         exit;
      }

      // Existing user - update login type and profile image
      update_user_meta($user->ID, 'login_type', 'Gmail');

      // Update profile image
      if (!empty($picture)) {
         self::save_remote_profile_image($picture, $user->ID);
      }

      // Log the user in
      wp_set_current_user($user->ID);
      wp_set_auth_cookie($user->ID, true);

      // Fire login hooks
      do_action('wp_login', $user->user_login, $user);

      error_log('Google OAuth: Existing user logged in - ' . $email);

      // Clean output buffer before redirect
      if (ob_get_length()) {
         ob_end_clean();
      }

      // Redirect after login
      wp_safe_redirect(home_url('/dashboard'));
      exit;
   }
   private static function handle_oauth_error($message)
   {
      // Clean output buffer
      if (ob_get_length()) {
         ob_end_clean();
      }

      // Redirect to login with error message
      $redirect_url = add_query_arg([
         'login_error' => 'google_oauth',
         'error_message' => urlencode($message)
      ], wp_login_url());

      wp_safe_redirect($redirect_url);
      exit;
   }
}