<?php

class Rewrite_rules
{
    public static function add_rewrite_rules_search($rules)
    {
        $current_lang = function_exists('icl_get_current_language') ? icl_get_current_language() : 'en'; // Default to English if WPML is not available

        // Define the base path for recipes
        $base_path = 'search';

        // Create the rewrite rules for both the default language and any other languages
        $newrules = [];

        // Default language rule (without any language prefix)
        $newrules["^$base_path/([^/]*)/?$"] = 'index.php?pagename=' . $base_path . '&category=$matches[1]';

        // Spanish language rule (with /es/ as the language prefix)
        if ($current_lang === 'es') {
            $newrules["^es/$base_path/([^/]*)/?$"] = 'index.php?pagename=' . $base_path . '&category=$matches[1]';
        }

        // Merge the new rules with the existing ones
        $rules = $newrules + $rules;

        return $rules;
    }
    public static function add_rewrite_rules_saved_plugin_recommendation($rules)
    {
        $current_lang = function_exists('icl_get_current_language') ? icl_get_current_language() : 'en'; // Default to English if WPML is not available

        // Define the base path for recipes
        $base_path = 'saved-plugin-recommendation';

        // Create the rewrite rules for both the default language and any other languages
        $newrules = [];

        // Default language rule (without any language prefix)
        $newrules["^$base_path/([^/]*)/?$"] = 'index.php?pagename=' . $base_path . '&category=$matches[1]';

        // Spanish language rule (with /es/ as the language prefix)
        if ($current_lang === 'es') {
            $newrules["^es/$base_path/([^/]*)/?$"] = 'index.php?pagename=' . $base_path . '&category=$matches[1]';
        }

        // Merge the new rules with the existing ones
        $rules = $newrules + $rules;

        return $rules;
    }

    public static function handle_adminbar()
    {
        if (! current_user_can('administrator')) {
            show_admin_bar(false);
        }
    }

}
