<?php
class multistep_plugin_select_wizard
{
    public static function type_website_building($front_end = null)
    {
        return [
            'e-commerce' => 'E-Commerce',
            'blog' => 'Blog',
            'portfolio' => 'Portfolio',
            'business' => 'Business',
            'forum' => 'Forum',
            'educational' => 'Educational',
            'entertainment' => 'Entertainment',
            'other' => 'Other',
        ];
    }
    public static function builder_theme_using($front_end = null)
    {
        return [
            //'e-commerce' => 'E-Commerce',
            'gutenberg-default' => 'Gutenberg (Default)',
            'elementor' => 'Elementor',
            'divi' => 'Divi',
            'wpbakery' => 'WPBakery',
            'other-custom' => 'Other / Custom',
        ];
    }
    public static function features_need_in_site()
    {
        return [
            'seo' => 'SEO',
            'performance' => 'Performance',
            'security' => 'Security',
            'backup-restore' => 'Backup/Restore',
            'analytics' => 'Analytics',
            'forms' => 'Forms',
            'e-commerce' => 'E-commerce',
            'email-marketing' => 'Email marketing',
            'translation' => 'Translation',
            'membership' => 'Membership',
            'page-builder' => 'Page Builder',
            'crm' => 'CRM',
            'payments' => 'Payments',
            'shipping' => 'Shipping',
            'events' => 'Events',
        ];
    }
    public static function monthly_traffic($front_end = null)
    {
        return [
            '0–1k' => "0-1000",
            '1–10k' => "1000-10000",
            '10–50k' => "10000-50000",
            '50k+' => "50000-50000000",
        ];
    }
    public static function comfortable_configuration_settings($front_end = null)
    {
        return [
            'beginner' => "Beginner",
            'intermediate' => "Intermediate",
            'expert' => "Advanced",
        ];
    }
    public static function budget_level_plugins($front_end = null)
    {
        return [
            'free-only' => 'Free only',
            'freemium-free-and-paid' => 'Freemium (mix of free & paid)',
            'willing-to-purchase-premium' => 'Willing to purchase premium plugins',
        ];
    }
    private static function find_mapping(array $mapping, $front_end)
    {
        if ($front_end === null) {
            return $mapping;
        }

        foreach ($mapping as $item) {
            if ($item["front_end"] === $front_end) {
                return $item;
            }
        }

        return null;
    }
    public static function get_plugin_slug_for_recommandation($user)
    {
        // -------------------------------------------
        // Website type → required features mapping
        // -------------------------------------------
        $website_type_to_required_features = [
            'e-commerce' => [
                'performance',
                'e-commerce',
                'payments',
                'shipping',
                'seo',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'blog' => [
                'performance',
                'seo',
                'analytics',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'portfolio' => [
                'performance',
                'seo',
                'forms',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'business' => [
                'performance',
                'seo',
                'crm',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'forum' => [
                'performance',
                'seo',
                'membership',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'educational' => [
                'lms',
                'performance',
                'seo',
                'events',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'entertainment' => [
                'performance',
                'seo',
                'analytics',
                'email-smtp',
                'security',
                'additional-management',
            ],
            'other' => [
                'performance',
                'seo',
                'email-smtp',
                'security',
                'additional-management',
            ],
        ];

        // -------------------------------------------
        // User input
        // -------------------------------------------
        $selected_features = array_map('trim', explode(',', $user['features_need_in_site']));
        $selected_website = $user['type_website_building'];
        $builder = $user['builder_theme_using'] ?? null;

        // -------------------------------------------
        // Add required features for website type
        // -------------------------------------------
        $required_features = $website_type_to_required_features[$selected_website] ?? [];

        foreach ($required_features as $feature) {
            if (!in_array($feature, $selected_features, true)) {
                $selected_features[] = $feature;
            }
        }

        // -------------------------------------------
        // Builder-specific feature handling (STRICT)
        // -------------------------------------------

        // Elementor → add elementor extensions
        if ($builder === 'elementor') {
            $selected_features[] = 'elementor-extensions';
        }

        // Divi → add divi extensions
        if ($builder === 'divi') {
            $selected_features[] = 'divi-extensions';
        }

        // Remove page-builder unless Gutenberg or Other
        if (!in_array($builder, ['gutenberg-default', 'other-custom'], true)) {
            $selected_features = array_filter(
                $selected_features,
                fn($feature) => $feature !== 'page-builder'
            );
        }

        // Ensure uniqueness
        $selected_features = array_values(array_unique($selected_features));

        // -------------------------------------------
        // Load AI feature → plugin dataset
        // -------------------------------------------
        $plugins_from_ai = ABSPATH . 'cron-management/updated_multistep_wizard_final_v2.json';

        if (file_exists($plugins_from_ai)) {
            $json = file_get_contents($plugins_from_ai);
            $ai_data = json_decode($json, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $ai_data = [];
            }
        } else {
            $ai_data = [];
        }

        // -------------------------------------------
        // Match features to plugin slugs
        // -------------------------------------------
        $matched = [];

        foreach ($ai_data['features'] ?? [] as $featureBlock) {
            $feature = $featureBlock['feature'];
            $feature_slug = $feature['feature_slug'];

            if (!in_array($feature_slug, $selected_features, true)) {
                continue;
            }

            $slugs = [];

            foreach ($feature['plugins'] as $plugin) {
                $slugs[] = $plugin['slug'];
            }

            if (!empty($slugs)) {
                $matched[$feature_slug] = [
                    'feature_name' => $feature['name'],
                    'slugs' => $slugs,
                ];
            }
        }

        // -------------------------------------------
        // Parse plugins with AI scoring
        // -------------------------------------------
        $final_result = [];

        foreach ($matched as $feature_slug => $feature_data) {
            $parsed_plugins = self::parsed_with_others_information(
                $feature_slug,
                $user,
                $feature_data['slugs']
            );

            $final_result[] = [
                'feature_slug' => $feature_slug,
                'feature_name' => $feature_data['feature_name'],
                'plugins_recommanded' => $parsed_plugins,
            ];
        }

        $feature_priority = self::get_feature_priority_map($user, $builder);

        usort($final_result, function ($a, $b) use ($feature_priority) {
            $priorityA = $feature_priority[$a['feature_slug']] ?? 900;
            $priorityB = $feature_priority[$b['feature_slug']] ?? 900;

            if ($priorityA === $priorityB) {
                return strcmp($a['feature_slug'], $b['feature_slug']);
            }

            return $priorityA <=> $priorityB;
        });

        return $final_result;
    }
    private static function get_feature_priority_map($user, $builder)
    {
        $site_type = $user['type_website_building'] ?? 'other';

        // -------------------------------------------
        // Website-type → PRIMARY core feature
        // (derived from type_website_building)
        // -------------------------------------------
        $website_core_feature = [
            'e-commerce'    => 'e-commerce',
            'blog'          => 'seo',
            'portfolio'     => 'seo',
            'business'      => 'crm',
            'forum'         => 'membership',
            'educational'   => 'lms',        // system feature (OK)
            'entertainment' => 'events',
            'other'         => 'seo',
        ];

        // -------------------------------------------
        // Priority map (ONLY valid feature keys)
        // -------------------------------------------
        $priority = [

            // Core features (default level)
            'seo'            => 10,
            'e-commerce'     => 10,
            'membership'     => 10,
            'crm'            => 10,
            'events'         => 10,
            'lms'            => 10, // system-level feature

            // Builder layer
            'page-builder'          => 20,
            'elementor-extensions'  => 20,
            'divi-extensions'       => 20,

            // Foundation
            'performance'    => 30,
            'security'       => 40,
            'backup-restore' => 45,

            // Monetization
            'payments'       => 50,
            'shipping'       => 60,

            // Growth
            'analytics'      => 70,

            // Communication
            'email-marketing' => 80,

            // Content / UX
            'forms'          => 90,
            'translation'    => 100,

            // Utilities (ABSOLUTE LAST)
            'additional-management' => 9999,
        ];

        // -------------------------------------------
        // Promote PRIMARY core feature
        // -------------------------------------------
        if (isset($website_core_feature[$site_type])) {
            $primary = $website_core_feature[$site_type];
            $priority[$primary] = 0; // 🔥 always first
        }

        // -------------------------------------------
        // Builder-specific handling
        // -------------------------------------------
        if ($builder === 'elementor') {
            $priority['elementor-extensions'] = 15;
        } elseif ($builder === 'divi') {
            $priority['divi-extensions'] = 15;
        } else {
            unset($priority['elementor-extensions'], $priority['divi-extensions']);
        }

        return $priority;
    }



    public static function parsed_with_others_information($feature_slug, $user, $slugs)
    {
        // Get plugin information by slugs
        $_plugin_information_by_slugs = self::get_plugin_information_by_slugs($slugs);
        $plugins_json_container = [];

        // Monthly traffic mapping
        $monthly_traffic_map = self::monthly_traffic();

        // Traffic impact score (lower = better)
        $traffic_impact_score = [
            'High' => 0,
            'Moderate' => 1,
            'Low' => 2,
        ];

        // User inputs
        $user_traffic = $user['monthly_traffic'];
        $user_expertise = $user['comfortable_configuration_settings'];
        $user_budget_level = $user['budget_level_plugins'];

        // Resolve traffic range
        $traffic_range = $monthly_traffic_map[$user_traffic] ?? '';

        // Expertise priority (lower = better)
        $expertise_priority = [];

        switch ($user_expertise) {
            case 'expert':
                $expertise_priority = [
                    'expert' => ['High' => 0, 'Moderate' => 1, 'Low' => 2],
                    'intermediate' => ['High' => 3, 'Moderate' => 4, 'Low' => 5],
                    'beginner' => ['High' => 6, 'Moderate' => 7, 'Low' => 8],
                ];
                break;

            case 'intermediate':
                $expertise_priority = [
                    'intermediate' => ['High' => 0, 'Moderate' => 1, 'Low' => 2],
                    'beginner' => ['High' => 3, 'Moderate' => 4, 'Low' => 5],
                    'expert' => ['High' => 6, 'Moderate' => 7, 'Low' => 8],
                ];
                break;

            case 'beginner':
            default:
                $expertise_priority = [
                    'beginner' => ['High' => 0, 'Moderate' => 1, 'Low' => 2],
                    'intermediate' => ['High' => 3, 'Moderate' => 4, 'Low' => 5],
                    'expert' => ['High' => 6, 'Moderate' => 7, 'Low' => 8],
                ];
                break;
        }

        // Iterate plugins
        foreach ($_plugin_information_by_slugs as $plugin) {

            $plugin_info = [
                'plugin_icon' => $plugin['plugin_icon'],
                'license_type' => $plugin['license_type'],
                'name' => $plugin['name'],
                'slug' => $plugin['slug'],
                'active_installs' => $plugin['active_installs'],
                'rating' => $plugin['rating'],
                'num_ratings' => $plugin['num_ratings'],
                'tested' => $plugin['tested'],
                'author_name' => $plugin['author_name'],
                'author_profile' => $plugin['author_profile'],
                'overall_wpscore' => $plugin['overall_wpscore'],
                'wp_post_id' => $plugin['wp_post_id'],
                'plugin_ai_profile' => json_decode($plugin['plugin_ai_profile'], true),
            ];

            // Budget filter (keep)
            if (
                $user_budget_level === 'free-only' &&
                !in_array($plugin_info['license_type'], ['free', 'freemium'], true)
            ) {
                continue;
            }

            /*
             * ============================
             * Monthly Traffic Scoring
             * ============================
             */
            $plugin_traffic = $plugin_info['plugin_ai_profile']['monthly_traffic'][$traffic_range] ?? 'Low';
            $plugin_info['traffic_match_score'] = $traffic_impact_score[$plugin_traffic] ?? 3;

            /*
             * ============================
             * Expertise Match Scoring
             * ============================
             */
            $expertise_match_score = 999;

            // Check all expertise levels and find the best (lowest) score
            foreach ($expertise_priority as $level => $intensity_scores) {
                if (isset($plugin_info['plugin_ai_profile']['comfortable_configuration_settings'][$level])) {
                    $plugin_level = $plugin_info['plugin_ai_profile']['comfortable_configuration_settings'][$level];
                    if (isset($intensity_scores[$plugin_level])) {
                        // Find the minimum score across all levels
                        $expertise_match_score = min($expertise_match_score, $intensity_scores[$plugin_level]);
                    }
                }
            }

            $plugin_info['expertise_match_score'] = $expertise_match_score;

            $plugins_json_container[] = $plugin_info;
        }

        // Fallback if empty (still respects budget)
        if (empty($plugins_json_container)) {
            foreach ($_plugin_information_by_slugs as $plugin) {

                if (
                    $user_budget_level === 'free-only' &&
                    !in_array($plugin['license_type'], ['free', 'freemium'], true)
                ) {
                    continue;
                }

                $plugin_info = [
                    'plugin_icon' => $plugin['plugin_icon'],
                    'license_type' => $plugin['license_type'],
                    'name' => $plugin['name'],
                    'slug' => $plugin['slug'],
                    'active_installs' => $plugin['active_installs'],
                    'rating' => $plugin['rating'],
                    'num_ratings' => $plugin['num_ratings'],
                    'tested' => $plugin['tested'],
                    'author_name' => $plugin['author_name'],
                    'author_profile' => $plugin['author_profile'],
                    'overall_wpscore' => $plugin['overall_wpscore'],
                    'wp_post_id' => $plugin['wp_post_id'],
                    'plugin_ai_profile' => json_decode($plugin['plugin_ai_profile'], true),
                    'traffic_match_score' => 3,
                    'expertise_match_score' => 999,
                ];

                $plugins_json_container[] = $plugin_info;
            }
        }

        /*
         * ============================
         * Final Sorting
         * ============================
         * 1. WP Score (DESC)
         * 2. Traffic suitability (ASC)
         * 3. Expertise match (ASC)
         */
        usort($plugins_json_container, function ($a, $b) {
            $expertise = $a['expertise_match_score'] <=> $b['expertise_match_score'];
            if ($expertise !== 0) {
                return $expertise;
            }

            $traffic = $a['traffic_match_score'] <=> $b['traffic_match_score'];
            if ($traffic !== 0) {
                return $traffic;
            }

            return $b['overall_wpscore'] <=> $a['overall_wpscore'];
        });

        // Cleanup temp scores
        foreach ($plugins_json_container as &$plugin) {
            unset($plugin['traffic_match_score'], $plugin['expertise_match_score']);
        }
        unset($plugin);

        // Return top 5
        return array_slice($plugins_json_container, 0, 5);
    }

    public static function get_plugin_information_by_slugs($slugs)
    {
        global $wpdb;
        $tbl = $wpdb->prefix . "plugins_core_information";

        if (empty($slugs)) {
            return [];
        }

        // Sanitize slugs
        $slugs = array_map('sanitize_text_field', $slugs);

        // Create placeholders like %s,%s,%s
        $placeholders = implode(',', array_fill(0, count($slugs), '%s'));

        $sql = $wpdb->prepare(
            "SELECT
            plugin_icon,
            license_type,
            name,
            slug,
            overall_wpscore,
            plugin_ai_profile,
            active_installs,
            rating,
            num_ratings,
            tested,
            author_name,
            author_profile,
            wp_post_id
         FROM {$tbl}
         WHERE slug IN ($placeholders) and wp_post_id > 0",
            $slugs
        );

        return $wpdb->get_results($sql, ARRAY_A);
    }
    public static function generate_recommendation_message_compact($user, $recommendations = null)
    {
        // Get recommendations if not provided
        if ($recommendations === null) {
            $recommendations = self::get_plugin_slug_for_recommandation($user);
        }

        // Get all the mapping arrays from existing functions
        $builders = self::builder_theme_using();
        $expertise_levels = self::comfortable_configuration_settings();
        $budget_levels = self::budget_level_plugins();

        // Map expertise levels to user-friendly descriptions
        $expertise_descriptions = [
            'beginner' => 'beginner-friendly',
            'intermediate' => 'suitable for intermediate users',
            'expert' => 'advanced and feature-rich',
        ];

        // Map budget levels to descriptions
        $budget_descriptions = [
            'free-only' => 'using only free plugins',
            'freemium-free-and-paid' => 'with a balanced mix of free and premium options',
            'willing-to-purchase-premium' => 'including premium solutions for maximum capability',
        ];

        // Get user selections
        $builder = $user['builder_theme_using'] ?? 'gutenberg-default';
        $expertise = $user['comfortable_configuration_settings'] ?? 'beginner';
        $budget = $user['budget_level_plugins'] ?? 'free-only';

        // Get friendly names
        $builder_name = $builders[$builder] ?? 'your page builder';
        $expertise_desc = $expertise_descriptions[$expertise] ?? 'beginner-friendly';
        $budget_desc = $budget_descriptions[$budget] ?? 'using only free plugins';

        // Get the current WordPress user
        $current_user = wp_get_current_user();
        $user_name = $current_user->display_name ?? 'User';

        // Get the current date
        $current_date = date('Y-m-d');
        $website_type = self::type_website_building()[$user['type_website_building']] ?? "your website";
        // Build the plain text title
        $title = "Optimize Your {$website_type} with the Best Plugin Stack - {$current_date} for {$user_name}";

        // Build feature list with top plugin
        $feature_plugin_list = [];

        if (!empty($recommendations) && is_array($recommendations)) {
            foreach ($recommendations as $feature_recommendation) {
                $feature_name = $feature_recommendation['feature_name'] ?? '';
                $plugins = $feature_recommendation['plugins_recommanded'] ?? [];

                if (!empty($plugins) && is_array($plugins)) {
                    // Sort plugins by overall_wpscore to get the top plugin
                    usort($plugins, function ($a, $b) {
                        return $b['overall_wpscore'] <=> $a['overall_wpscore'];
                    });

                    // Get the top plugin (first one after sorting)
                    $top_plugin = $plugins[0]['name'] ?? '';

                    // Only add to list if top plugin is found
                    if (!empty($top_plugin)) {
                        $feature_plugin_list[] = esc_html($feature_name) . ' (' . esc_html($top_plugin) . ')';
                    }
                }
            }
        }

        // Create feature string
        $feature_string = '';
        if (count($feature_plugin_list) > 0) {
            if (count($feature_plugin_list) == 1) {
                $feature_string = $feature_plugin_list[0];
            } elseif (count($feature_plugin_list) == 2) {
                $feature_string = $feature_plugin_list[0] . ' and ' . $feature_plugin_list[1];
            } else {
                $last_feature = array_pop($feature_plugin_list);
                $feature_string = implode(', ', $feature_plugin_list) . ', and ' . $last_feature;
            }
        }

        // Build the HTML message with gradient underlines
        $message = "Let's take your {$website_type}  to the next level! ";
        $message .= "Based on your answers, we've handpicked a plugin stack that fits your website built with ";

        // Builder name with gradient underline
        $message .= '<strong class="relative">';
        $message .= '<span class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>';
        $message .= esc_html($builder_name);
        $message .= '</strong>';

        // Feature optimization (only if features exist)
        if (!empty($feature_string)) {
            $message .= ' — optimized for ';
            $message .= '<strong class="relative">';
            $message .= '<span class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>';
            $message .= $feature_string;
            $message .= '</strong>';
        }

        $message .= ', ';

        // Budget description with gradient underline
        $message .= '<strong class="relative">';
        $message .= '<span class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>';
        $message .= esc_html($budget_desc);
        $message .= '</strong>';

        $message .= ' that are ';

        // Expertise description with gradient underline
        $message .= '<strong class="relative">';
        $message .= '<span class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>';
        $message .= esc_html($expertise_desc);
        $message .= '</strong>';

        $message .= '.';

        return [
            'title' => $title,
            'message' => $message,
        ];
    }
    public static function my_get_dynamic_notices_generated_by_ai($builder = 'all')
    {

        $notices = [
            [
                'key' => 'slow_load_times',
                'title' => 'Slow load times that frustrate visitors',
                'text' => 'Pages built with page builders can become heavy — slow performance frustrates visitors and hurts engagement.',
                'icon' => 'times.svg',
                'builders' => ['elementor', 'divi', 'wpbakery', 'e-commerce'],
            ],
            [
                'key' => 'seo_visibility',
                'title' => 'Hard to get found on search engines',
                'text' => 'Even great-looking websites struggle to attract traffic without a clear and manageable SEO setup.',
                'icon' => 'hard.svg',
                'builders' => ['all'],
            ],
            [
                'key' => 'plugin_overload',
                'title' => 'Too many plugins, not enough clarity',
                'text' => 'Using too many tools often causes conflicts and bloated performance — a focused setup works better.',
                'icon' => 'layout-masonry-fill.svg',
                'builders' => ['all'],
            ],
            [
                'key' => 'mobile_experience',
                'title' => 'Slow mobile experience drives visitors away',
                'text' => 'Most visitors browse on mobile — slow pages quickly frustrate users and increase bounce rates.',
                'icon' => 'smartphone.svg',
                'builders' => ['elementor', 'divi', 'wpbakery', 'e-commerce'],
            ],
            [
                'key' => 'first_impression',
                'title' => 'First impressions are lost in seconds',
                'text' => 'Visitors judge your site instantly — slow load times create frustration before content appears.',
                'icon' => 'clock.svg',
                'builders' => ['all'],
            ],
        ];

        $filtered = array_filter($notices, function ($notice) use ($builder) {
            return in_array('all', $notice['builders'], true)
                || in_array($builder, $notice['builders'], true);
        });

        if (empty($filtered)) {
            return null;
        }

        return $filtered[array_rand($filtered)];
    }
    public static function get_three_unique_ai_notices($builder = 'all')
    {
        $unique_notices = [];
        $used_keys = [];

        // Safety to avoid infinite loops
        $max_attempts = 20;
        $attempts = 0;

        while (count($unique_notices) < 3 && $attempts < $max_attempts) {
            $attempts++;

            $notice = self::my_get_dynamic_notices_generated_by_ai($builder);

            if (!$notice || empty($notice['key'])) {
                continue;
            }

            // Prevent duplicate keys
            if (in_array($notice['key'], $used_keys, true)) {
                continue;
            }

            $used_keys[] = $notice['key'];
            $unique_notices[] = $notice;
        }

        return $unique_notices;
    }
    public static function save_date_personalized_plugin_recommendation($questions, $message, $recommandation_id = null)
    {
        global $wpdb;

        $table = $wpdb->prefix . "personalized_plugin_recommendation";
        $user_id = get_current_user_id();

        // -----------------------------------------
        // 1️⃣ Keep ORIGINAL questions (do not sort)
        // -----------------------------------------
        $original_questions_json = wp_json_encode($questions, JSON_UNESCAPED_UNICODE);

        // -----------------------------------------
        // 2️⃣ Create NORMALIZED copy only for hashing
        // -----------------------------------------
        $normalized_questions = $questions;

        if (is_array($normalized_questions)) {
            array_walk_recursive($normalized_questions, function (&$v) {
                if (is_string($v)) {
                    $v = trim(strtolower($v));
                }
            });
            sort($normalized_questions, SORT_STRING);
        }

        // -----------------------------------------
        // 3️⃣ Generate stable fingerprint
        // -----------------------------------------
        $questions_hash = md5(wp_json_encode($normalized_questions));

        // Helper
        $fetch_row_by_id = function ($id) use ($wpdb, $table, $user_id) {
            return $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$table} WHERE id = %d AND user_id = %d LIMIT 1",
                    $id,
                    $user_id
                ),
                ARRAY_A
            );
        };

        /**
         * -----------------------------------------
         * CASE 1: Update by ID
         * -----------------------------------------
         */
        if (!empty($recommandation_id)) {

            $existing_id = $wpdb->get_var(
                $wpdb->prepare(
                    "SELECT id FROM {$table} WHERE id = %d AND user_id = %d",
                    $recommandation_id,
                    $user_id
                )
            );

            if ($existing_id) {

                $wpdb->update(
                    $table,
                    [
                        'recommendation_title' => $message['title'],
                        'user_questions' => $original_questions_json, // ✅ full original JSON
                        'questions_hash' => $questions_hash,
                        'updated_at' => current_time('mysql'),
                    ],
                    [
                        'id' => $existing_id,
                        'user_id' => $user_id,
                    ],
                    ['%s', '%s', '%s', '%s'],
                    ['%d', '%d']
                );

                return $fetch_row_by_id($existing_id);
            }
        }

        /**
         * -----------------------------------------
         * CASE 2: Deduplicate by hash
         * -----------------------------------------
         */
        $existing_id = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT id FROM {$table}
             WHERE user_id = %d AND questions_hash = %s",
                $user_id,
                $questions_hash
            )
        );

        if ($existing_id) {
            return $fetch_row_by_id($existing_id);
        }

        /**
         * -----------------------------------------
         * CASE 3: Insert new
         * -----------------------------------------
         */
        $wpdb->insert(
            $table,
            [
                'recommendation_title' => $message['title'],
                'user_questions' => $original_questions_json, // ✅ full JSON
                'questions_hash' => $questions_hash,
                'user_id' => $user_id,
                'created_at' => current_time('mysql'),
            ],
            ['%s', '%s', '%s', '%d', '%s']
        );

        return $fetch_row_by_id((int) $wpdb->insert_id);
    }

    public static function rename_the_title()
    {
        global $wpdb;

        $table = $wpdb->prefix . "personalized_plugin_recommendation";
        $wpdb->update(
            $table,
            [
                'recommendation_title' => $_POST['title'],
            ],
            [
                'id' => $_POST['id'],
            ],
            ['%s'],
            ['%d']
        );
    }
    public static function already_saved_wizard_results()
    {
        global $wpdb;
        $table = $wpdb->prefix . "personalized_plugin_recommendation";
        $user_id = get_current_user_id();

        return $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM {$table} WHERE user_id = %d ORDER BY is_pinned DESC,id DESC",
                $user_id
            ),
            ARRAY_A
        );
    }
    public static function delete_recommandation_row()
    {
        global $wpdb;

        if (!isset($_POST['id'])) {
            wp_send_json_error("Missing ID");
        }

        $id = intval($_POST['id']);

        if ($id <= 0) {
            wp_send_json_error("Invalid ID");
        }

        $table = $wpdb->prefix . "personalized_plugin_recommendation";

        $deleted = $wpdb->delete(
            $table,
            ['id' => $id],
            ['%d']
        );

        if ($deleted === false) {
            wp_send_json_error("Database error");
        }

        if ($deleted === 0) {
            wp_send_json_error("Record not found");
        }

        wp_send_json_success("Deleted successfully");
    }
    public static function get_wizard_result_by_hash(string $questions_hash)
    {
        global $wpdb;

        $table = $wpdb->prefix . "personalized_plugin_recommendation";
        $user_id = get_current_user_id();

        if (empty($questions_hash)) {
            return null;
        }

        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT *
             FROM {$table}
             WHERE user_id = %d
               AND questions_hash = %s
             LIMIT 1",
                $user_id,
                $questions_hash
            ),
            ARRAY_A
        );
    }
    public static function pin_the_recomandation()
    {
        global $wpdb;

        // Check for ID
        if (!isset($_POST['id'])) {
            wp_send_json_error("Missing ID");
        }

        $id = intval($_POST['id']);
        if ($id <= 0) {
            wp_send_json_error("Invalid ID");
        }

        $table = $wpdb->prefix . "personalized_plugin_recommendation";

        // Get current is_pinned value
        $current = $wpdb->get_var(
            $wpdb->prepare("SELECT is_pinned FROM {$table} WHERE id = %d", $id)
        );

        if ($current === null) {
            wp_send_json_error("Record not found");
        }

        // Toggle the value: 0 -> 1, 1 -> 0
        $new_value = $current ? 0 : 1;

        $updated = $wpdb->update(
            $table,
            ['is_pinned' => $new_value],
            ['id' => $id],
            ['%d'],
            ['%d']
        );

        if ($updated === false) {
            wp_send_json_error("Database error");
        }

        // Return new status
        wp_send_json_success([
            'message' => $new_value ? "Pinned successfully" : "Unpinned successfully",
            'is_pinned' => $new_value
        ]);
    }
}
