<?php
class Helpers
{
    public static function metric_information_groups()
    {
        $metric_information_groups = [
            'core_performance' => 'Core Performance & Reliability Metrics',
            'business_fit' => 'Business Fit & Monetization Signals',
            'ux_technical' => 'UX / Compatibility / Technical Signals',
            'social_proof' => 'Social Proof & Brand Signals',
        ];
        return $metric_information_groups;
    }
    public static function metric_information_groups_image_icon()
    {
        $metric_information_groups = [
            'core_performance' => 'plugin-page/popup/bar-chart-box-line.svg',
            'business_fit' => 'plugin-page/popup/aed-line.svg',
            'ux_technical' => 'plugin-page/popup/computer-line.svg',
            'social_proof' => 'plugin-page/popup/archive-2-line.svg',
        ];
        return $metric_information_groups;
    }
    public static function metric_information_attributes()
    {
        $metric_information_attributes = [
            'core_performance_active_installs' => 'Active Installs',
            'core_performance_installation_growth' => 'Installation Growth',
            'core_performance_update_recency' => 'Update Recency',
            'core_performance_update_frequency' => 'Update Frequency',
            'core_performance_wp_compatibility' => 'Compatibility with Latest WP',
            'core_performance_support_responsiveness' => 'Support Responsiveness',
            'core_performance_average_rating' => 'Average Rating',
            'core_performance_number_of_ratings' => 'Number of Ratings',
            'core_performance_plugin_age_maturity' => 'Plugin Age + Maturity',
            'business_fit_pricing_model' => 'Free / Freemium / Paid',
            'business_fit_lifetime_license' => 'Has Lifetime License',
            'business_fit_woocommerce_support' => 'WooCommerce Support',
            'business_fit_agency_license' => 'Agency-Friendly License',
            'ux_technical_performance_impact' => 'Performance Impact',
            'ux_technical_php_version' => 'PHP Version Support',
            'ux_technical_multisite_support' => 'Multisite Support',
            'ux_technical_localization' => 'Localization / Languages',
            'social_proof_developer_reputation' => 'Developer Reputation',
            'social_proof_documentation_quality' => 'Documentation Quality',
            'social_proof_youtube_tutorials' => 'YouTube Tutorials',
            'social_proof_community_presence' => 'Active Facebook Group / Discord / page',
        ];
        return $metric_information_attributes;
    }
    public static function metric_information_attributes_mapping_db_keys()
    {
        $metric_information_attributes = [
            'core_performance_active_installs' => "wps_active_install_score",
            'core_performance_installation_growth' => "wps_installation_growth_score",
            'core_performance_update_recency' => "wps_update_recency_score",
            'core_performance_update_frequency' => "wps_update_frequency_score",
            'core_performance_wp_compatibility' => "wps_compatibility_with_latest_wp_score",
            'core_performance_support_responsiveness' => "wps_support_responsiveness_score",
            'core_performance_average_rating' => "wps_average_rating_score",
            'core_performance_number_of_ratings' => "wps_number_of_ratings_score",
            'core_performance_plugin_age_maturity' => "wps_maturity_score",

            // === Business Fit ===
            'business_fit_pricing_model' => "wps_license_score",
            'business_fit_lifetime_license' => "wps_has_lifetime_license_score",
            'business_fit_woocommerce_support' => "wps_woocommerce_support_score",
            'business_fit_agency_license' => "wps_agency_license_score",

            // === UX / Technical ===
            'ux_technical_performance_impact' => "wps_performance_impact_score",
            'ux_technical_php_version' => "wps_php_version_support_score",
            'ux_technical_multisite_support' => "wps_multisite_support_score", // you didn’t provide a score variable
            'ux_technical_localization' => "wps_localization_languages_score",

            // === Social Proof ===
            'social_proof_developer_reputation' => "wps_developer_reputation_score",
            'social_proof_documentation_quality' => "wps_documentation_quality_score", // you didn’t provide a score variable
            'social_proof_youtube_tutorials' => "wps_youtube_tutorials_score",
            'social_proof_community_presence' => "wps_community_page_score",
        ];
        return $metric_information_attributes;
    }
    public static function toPercentageFromOneToTen($value)
    {
        // Ensure value stays between 0 and 10
        $value = max(0, min(10, $value));

        // Convert to percentage
        return ($value / 10) * 100;
    }

    public static function get_all_subcategory_or_siblings($category_id)
    {

        // Get the term object
        $term = get_term($category_id, 'plugin_category');

        if (is_wp_error($term) || !$term) {
            return null;
        }

        // ✅ If parent term
        if ($term->parent == 0) {
            return get_term_meta($term->term_id, '_plugin_category_children_data', true);
        }

        // ✅ If child term → get parent
        return get_term_meta($term->parent, '_plugin_category_children_data', true);
    }

    public static function all_tags_related_category($category_id)
    {
        // Get the term object
        $term = get_term($category_id, 'plugin_category');

        if (is_wp_error($term) || !$term) {
            return null;
        }

        // ✅ If parent term
        if ($term->parent == 0) {
            return get_term_meta($term->term_id, '_plugin_category_tag_data', true);
        }

        // ✅ If child term → get parent
        return get_term_meta($term->parent, '_plugin_category_tag_data', true);
    }
    public static function rating_filter_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "1-3",
                "field" => "rating",
                "value" => [20, 60], // 1★=20%, 3★=60%
                "operator" => "between",
            ],
            [
                "front_end" => "3+",
                "field" => "rating",
                "value" => 60, // 3★+
                "operator" => ">",
            ],
            [
                "front_end" => "4+",
                "field" => "rating",
                "value" => 80, // 4★+
                "operator" => ">",
            ],
        ];

        return self::find_mapping($mapping, $front_end);
    }

    public static function wps_score_filter_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "0-4.9",
                "field" => "overall_wpscore",
                "value" => 5.00,
                "operator" => "<",
            ],
            [
                "front_end" => "5+",
                "field" => "overall_wpscore",
                "value" => 5.00,
                "operator" => ">=",
            ],
            [
                "front_end" => "7+",
                "field" => "overall_wpscore",
                "value" => 7.00,
                "operator" => ">=",
            ],
        ];

        return self::find_mapping($mapping, $front_end);
    }

    public static function last_updated_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Last 30 d",
                "field" => "last_update_days",
                "value" => 30,
                "operator" => "<=",
            ],
            [
                "front_end" => "Last 3mo",
                "field" => "last_update_days",
                "value" => 90,
                "operator" => "<=",
            ],
            [
                "front_end" => "Last 6 mo",
                "field" => "last_update_days",
                "value" => 180,
                "operator" => "<=",
            ],
            [
                "front_end" => "Last year",
                "field" => "last_update_days",
                "value" => 365,
                "operator" => "<=",
            ],
            [
                "front_end" => "Older",
                "field" => "plugin_age_days",
                "value" => 365,
                "operator" => ">",
            ],
        ];

        return self::find_mapping($mapping, $front_end);
    }

    public static function active_installation_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Under 10k",
                "field" => "active_installs",
                "value" => 10000,
                "operator" => "<",
            ],
            [
                "front_end" => "10k to 100k",
                "field" => "active_installs",
                "value" => [10000, 100000],
                "operator" => "between",
            ],
            [
                "front_end" => "100k to 1M",
                "field" => "active_installs",
                "value" => [100000, 1000000],
                "operator" => "between",
            ],
            [
                "front_end" => "Over 1M",
                "field" => "active_installs",
                "value" => 1000000,
                "operator" => ">",
            ],
        ];

        return self::find_mapping($mapping, $front_end);
    }
    public static function support_quality_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Excellent",
                "field" => "support_quality",
                "value" => "1",
                "operator" => "=",
            ],
            [
                "front_end" => "Good",
                "field" => "support_quality",
                "value" => "2",
                "operator" => "=",
            ],
            [
                "front_end" => "Fair",
                "field" => "support_quality",
                "value" => "3",
                "operator" => "=",
            ],
            [
                "front_end" => "Poor",
                "field" => "support_quality",
                "value" => "4",
                "operator" => "=",
            ],
        ];

        return self::find_mapping($mapping, $front_end);
    }
    public static function user_review_sentiment_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Mostly Positive",
                "field" => "user_review_sentiment",
                "value" => "2",
                "operator" => "=",
            ],
            [
                "front_end" => "Moderate",
                "field" => "user_review_sentiment",
                "value" => "1",
                "operator" => "=",
            ],
            [
                "front_end" => "High",
                "field" => "user_review_sentiment",
                "value" => "3",
                "operator" => "=",
            ],
        ];
        return self::find_mapping($mapping, $front_end);
    }
    public static function performace_impact_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Low",
                "field" => "performance_impact",
                "value" => "1",
                "operator" => "=",
            ],
            [
                "front_end" => "Moderate",
                "field" => "performance_impact",
                "value" => "2",
                "operator" => "=",
            ],
            [
                "front_end" => "High",
                "field" => "performance_impact",
                "value" => "3",
                "operator" => "=",
            ],
        ];
        return self::find_mapping($mapping, $front_end);
    }

    public static function multilingual_support_plugin_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Yes",
                "field" => "localization_count",
                "value" => 0,
                "type" => ">",
            ],
            [
                "front_end" => "No",
                "field" => "localization_count",
                "value" => 0,
                "type" => "=",
            ],
        ];
        return self::find_mapping($mapping, $front_end);
    }

    /**
     * Shared helper function to reduce duplicate code
     */
    private static function find_mapping(array $mapping, $front_end)
    {
        if ($front_end === null) {
            return $mapping;
        }

        foreach ($mapping as $item) {
            if ($item["front_end"] === $front_end) {
                return $item;
            }
        }

        return null;
    }
    public static function get_search_url_with_params($slug, $type = null, $value = null)
    {
        // Base URL
        $base_url = site_url("/search/" . $slug);

        // Start with current GET params
        $params = $_GET ?? [];

        if ($type === "overall_wpscore") {
            $params['overall_wpscore'] =
                get_front_end_for_by_score_filter_searching(
                    $value,
                    Helpers::wps_score_filter_mapping()
                );
        }

        if ($type === "active_installs") {
            $params['active_install'] =
                get_front_end_for_by_score_filter_searching(
                    $value,
                    Helpers::active_installation_plugin_mapping()
                );
        }

        if ($type === "performace_impact") {
            $params['performace_impact'] = "High";
        }
        // Build final URL
        if (!empty($params)) {
            $base_url .= '?' . http_build_query($params);
        }

        return $base_url;
    }
    public static function get_the_most_used_plugin_category()
    {
        $top_plugin_categories = get_option('top_plugin_categories');
        if (!empty($top_plugin_categories)) {
            return [
                'category_id' => $top_plugin_categories[0]['term_id'],
                'name' => $top_plugin_categories[0]['name'],
            ];
        }
    }
    public static function get_all_main_category_fuzzy($_fuzzy_categories)
    {
        $top_categories = get_option('top_plugin_categories');

        if (empty($top_categories) || !is_array($top_categories)) {
            return [];
        }

        // Ensure param is a clean array of integers
        $filter_ids = array_map('intval', (array) $_fuzzy_categories);

        $output = [];

        foreach ($top_categories as $term) {

            $term_id = isset($term['term_id']) ? (int) $term['term_id'] : 0;

            // ✅ FILTER: only allow IDs in param
            if (!in_array($term_id, $filter_ids, true)) {
                continue;
            }

            $output[] = [
                'id'    => $term_id,
                'name'  => isset($term['name'])
                    ? html_entity_decode($term['name'], ENT_QUOTES, 'UTF-8')
                    : '',
                'count' => isset($term['count']) ? (int) $term['count'] : 0,
                'slug'  => isset($term['slug']) ? $term['slug'] : '',
            ];
        }

        return $output;
    }

    public static function get_names_by_slug_comparison_plugins($wp_post_id)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugin_comparisons';
        return $wpdb->get_row(
            $wpdb->prepare(
                "SELECT plugin_names, plugin_slugs 
         FROM {$table}
         WHERE wp_post_id = %d",
                (int) $wp_post_id
            ),
            ARRAY_A
        );
    }
    public static function get_names_by_slug_wp_org($slug)
    {
        global $wpdb;

        $table = $wpdb->prefix . 'plugins_core_information';

        $name = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT name FROM {$table} WHERE slug = %s",
                $slug
            )
        );

        return $name ?: 'No Name';
    }
    public static function get_related_plugin_comparisons($current_post_id, $limit = 3)
    {

        if (!$current_post_id) {
            return [];
        }

        // Get category terms
        $term_ids = wp_get_post_terms(
            $current_post_id,
            'comparison_category',
            ['fields' => 'ids']
        );

        if (empty($term_ids) || is_wp_error($term_ids)) {
            return [];
        }

        $args = [
            'post_type' => 'plugin_comparison', // ✅ FIXED
            'posts_per_page' => $limit,
            'post__not_in' => [$current_post_id],
            'post_status' => 'publish',
            'tax_query' => [
                [
                    'taxonomy' => 'comparison_category',
                    'field' => 'term_id',
                    'terms' => $term_ids,
                ],
            ],
        ];

        $query = new WP_Query($args);

        return $query->posts;
    }
    public static function sort_by_key_mapping($front_end = null)
    {
        $mapping = [
            [
                "front_end" => "Most popular",
                "field" => "rating",
                "direction" => "desc",
            ],
            [
                "front_end" => "Relevance",
                "field" => "",
                "direction" => "",
            ],
            [
                "front_end" => "Highest score",
                "field" => "overall_wpscore",
                "direction" => "desc",
            ],
            [
                "front_end" => "Lowest score",
                "field" => "overall_wpscore",
                "direction" => "asc",
            ],
            [
                "front_end" => "Newest",
                "field" => "plugin_age_days",
                "direction" => "asc",
            ],
            [
                "front_end" => "Oldest",
                "field" => "plugin_age_days",
                "direction" => "desc",
            ],
        ];
        return self::find_mapping($mapping, $front_end);
    }
    public static function get_all_plugin_comparison_category()
    {
        // Get only parent terms from comparison_category taxonomy
        $terms = get_terms([
            'taxonomy' => 'comparison_category',
            'hide_empty' => false,
            'parent' => 0, // ✅ only parent categories
        ]);

        if (is_wp_error($terms) || empty($terms)) {
            return [];
        }

        $output = [];

        foreach ($terms as $term) {
            $output[] = [
                'id' => (int) $term->term_id,
                'name' => html_entity_decode($term->name, ENT_QUOTES, 'UTF-8'),
                'count' => (int) $term->count,
                'slug' => $term->slug,
            ];
        }

        return $output;
    }
}
