<?php
// Save data
if (isset($_POST['submit_theme_options']) && check_admin_referer('save_theme_options', 'theme_option_nonce')) {

    $website_rows = [];

    if (!empty($_POST['website_title']) && is_array($_POST['website_title'])) {
        foreach ($_POST['website_title'] as $i => $title) {
            $ids = isset($_POST['website_categories'][$i]) ? array_map('intval', $_POST['website_categories'][$i]) : [];

            $website_rows[] = [
                'title' => sanitize_text_field($title),
                'categories' => $ids
            ];
        }
    }

    $data = [
        'website_descriptions' => $website_rows,
        'social_media' => [
            'facebook' => sanitize_text_field($_POST['facebook'] ?? ''),
            'twitter' => sanitize_text_field($_POST['twitter'] ?? ''),
            'instagram' => sanitize_text_field($_POST['instagram'] ?? ''),
            'linkedin' => sanitize_text_field($_POST['linkedin'] ?? ''),
        ],
        'footer_description' => sanitize_textarea_field($_POST['footer_description'] ?? ''),
    ];

    update_option('theme_options_custom', $data, false); // no auto load
    echo '<div class="updated"><p>Settings Saved!</p></div>';
}

$options = get_option('theme_options_custom');
$rows = $options['website_descriptions'] ?? [];
$social = $options['social_media'] ?? [];
$footer_description=$options['footer_description'] ?? null;
// get only parent categories
$categories = get_terms([
    'taxonomy' => 'plugin_category',
    'hide_empty' => false,
    'parent' => 0
]);
?>

<div class="wrap">
    <h1>Theme Options</h1>

    <form method="post">
        <?php wp_nonce_field('save_theme_options', 'theme_option_nonce'); ?>

        <h2>Which best describes your website?</h2>

        <table class="form-table" style="width:100%;max-width:900px;">
            <thead>
                <tr>
                    <th style="width:40%">Title</th>
                    <th style="width:45%">Categories</th>
                    <th style="width:15%">Action</th>
                </tr>
            </thead>
            <tbody id="website-rows-body">

                <?php if (!empty($rows)):
                    foreach ($rows as $i => $row): ?>
                        <tr>
                            <td><input type="text" name="website_title[]" class="regular-text"
                                    value="<?php echo esc_attr($row['title']); ?>"></td>

                            <td>
                                <select name="website_categories[<?php echo $i; ?>][]" class="category-select" multiple
                                    style="width:100%">
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?php echo $cat->term_id; ?>" <?php echo in_array($cat->term_id, $row['categories']) ? 'selected' : ''; ?>>
                                            <?php echo esc_html($cat->name); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </td>

                            <td><button type="button" class="button remove-row">X</button></td>
                        </tr>
                    <?php endforeach; endif; ?>

            </tbody>
        </table>

        <p><button type="button" class="button button-secondary" id="add-row">+ Add Row</button></p>

        <hr />

        <h2>Social Media Links</h2>

        <table class="form-table">
            <tr>
                <th>Facebook</th>
                <td><input type="text" class="regular-text" name="facebook"
                        value="<?php echo esc_attr($social['facebook'] ?? ''); ?>"></td>
            </tr>
            <tr>
                <th>Twitter</th>
                <td><input type="text" class="regular-text" name="twitter"
                        value="<?php echo esc_attr($social['twitter'] ?? ''); ?>"></td>
            </tr>
            <tr>
                <th>Instagram</th>
                <td><input type="text" class="regular-text" name="instagram"
                        value="<?php echo esc_attr($social['instagram'] ?? ''); ?>"></td>
            </tr>
            <tr>
                <th>LinkedIn</th>
                <td><input type="text" class="regular-text" name="linkedin"
                        value="<?php echo esc_attr($social['linkedin'] ?? ''); ?>"></td>
            </tr>
        </table>
        <hr />

        <h2>Footer Description</h2>

        <table class="form-table">
            <tr>
                <th>Footer Description</th>
                <td>
                    <textarea name="footer_description" rows="5"
                        class="large-text"><?php echo esc_textarea($footer_description); ?></textarea>
                </td>
            </tr>
        </table>
        <br>
        <button type="submit" name="submit_theme_options" class="button-primary">Save Settings</button>
    </form>
</div>

<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    jQuery(function ($) {
        let rowIndex = <?php echo !empty($rows) ? count($rows) : 0; ?>;

        function initSelect2() {
            $(".category-select").select2({
                placeholder: "Select category…",
                width: 'resolve'
            });
        }
        initSelect2();

        $("#add-row").on("click", function () {
            let options = "";
            <?php foreach ($categories as $cat): ?>
                options += `<option value="<?php echo $cat->term_id; ?>"><?php echo esc_html($cat->name); ?></option>`;
            <?php endforeach; ?>

            $("#website-rows-body").append(`
            <tr>
                <td><input type="text" name="website_title[]" class="regular-text"></td>
                <td>
                    <select name="website_categories[${rowIndex}][]" class="category-select" multiple style="width:100%">
                        ${options}
                    </select>
                </td>
                <td><button type="button" class="button remove-row">X</button></td>
            </tr>
        `);

            rowIndex++;
            initSelect2();
        });

        $(document).on("click", ".remove-row", function () {
            $(this).closest('tr').remove();
        });
    });
</script>

<style>
    #website-rows-body input,
    #website-rows-body select {
        width: 100%;
    }

    .select2-container {
        min-width: 100% !important;
    }
</style>