<?php
// ====== LOAD SAVED OPTION DATA ======
$saved_metrics = get_option('plugin_metrics_settings', []); // autoload off handled below

$compare = [
    '>=' => 'Greater Than or Equal',
    '<=' => 'Less Than or Equal',
    '='  => 'Equal to'
];

// Example: You already have this from your context
// $column_names = ['active_installs', 'downloads', 'rating', 'reviews'];

// ====== SAVE HANDLER ======
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['plugin_metrics_save'])) {
    check_admin_referer('plugin_metrics_save_nonce');

    $metrics = [];
    if (!empty($_POST['metric_key'])) {
        foreach ($_POST['metric_key'] as $i => $key) {
            if (empty($key)) continue;
            $metrics[] = [
                'key'       => sanitize_text_field($key),
                'compare'   => sanitize_text_field($_POST['metric_compare'][$i] ?? ''),
                'value'     => floatval($_POST['metric_value'][$i] ?? 0),
                'multiple'  => floatval($_POST['metric_multiple'][$i] ?? 0),
            ];
        }
    }

    if (get_option('plugin_metrics_settings', false) === false) {
        add_option('plugin_metrics_settings', $metrics, '', 'no');
    } else {
        update_option('plugin_metrics_settings', $metrics, 'no');
    }

    echo '<div class="notice notice-success is-dismissible"><p>Settings saved!</p></div>';
    $saved_metrics = $metrics;
}
?>
<div class="wrap">
    <h1>Plugin Metrics Settings</h1>
    <form method="post">
        <?php wp_nonce_field('plugin_metrics_save_nonce'); ?>
        <table id="metricsTable" class="widefat striped">
            <thead>
                <tr>
                    <th>Param Key</th>
                    <th>Param Compare</th>
                    <th>Param Value</th>
                    <th>Param Multiple</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!empty($saved_metrics)) {
                    foreach ($saved_metrics as $index => $metric) { ?>
                        <tr class="metric-row">
                            <td>
                                <select class="select2-field" name="metric_key[]">
                                    <?php foreach ($column_names as $value) { ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($metric['key'], $value); ?>><?php echo esc_html($value); ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td>
                                <select class="select2-field" name="metric_compare[]">
                                    <?php foreach ($compare as $key => $value) { ?>
                                        <option value="<?php echo esc_attr($key); ?>" <?php selected($metric['compare'], $key); ?>><?php echo esc_html($value); ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td><input type="number" name="metric_value[]" step="any" value="<?php echo esc_attr($metric['value']); ?>"></td>
                            <td><input type="number" name="metric_multiple[]" step="any" value="<?php echo esc_attr($metric['multiple']); ?>"></td>
                            <td>
                                <?php if ($index === 0) : ?>
                                    <button type="button" class="add-row button button-primary">Add row</button>
                                <?php else : ?>
                                    <button type="button" class="remove-row button button-secondary">Remove</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php }
                } else { ?>
                    <tr class="metric-row">
                        <td>
                            <select class="select2-field" name="metric_key[]">
                                <?php foreach ($column_names as $value) { ?>
                                    <option value="<?php echo esc_attr($value); ?>"><?php echo esc_html($value); ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td>
                            <select class="select2-field" name="metric_compare[]">
                                <?php foreach ($compare as $key => $value) { ?>
                                    <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td><input type="number" name="metric_value[]" step="any"></td>
                        <td><input type="number" name="metric_multiple[]" step="any"></td>
                        <td><button type="button" class="add-row button button-primary">Add row</button></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <p><input type="submit" name="plugin_metrics_save" class="button button-primary" value="Save Settings"></p>
    </form>
</div>

<!-- Select2 (only needed dependency) -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
jQuery(document).ready(function ($) {
    function initSelect2(ctx) {
        $(ctx).find('.select2-field').select2({ width: '100%' });
    }
    initSelect2(document);

    $(document).on('click', '.add-row', function (e) {
        e.preventDefault();
        let $row = $(this).closest('tr');
        $row.find('.select2-field').select2('destroy');
        let $clone = $row.clone();
        initSelect2($row);
        $clone.find('input').val('');
        $clone.find('select').val('').trigger('change');
        $row.find('.add-row')
            .removeClass('add-row button-primary')
            .addClass('remove-row button-secondary')
            .text('Remove');
        $('#metricsTable tbody').append($clone);
        initSelect2($clone);
    });

    $(document).on('click', '.remove-row', function () {
        $(this).closest('tr').remove();
    });
});
</script>
