<?php
global $post;

$comparison_data = get_post_meta($post->ID, '_plugin_comparison_data', true);

if (empty($comparison_data)) {
    $comparison_data = json_encode([
        'comparison_title' => '',
        'plugins' => [],
        'overview' => '',
        'feature_table' => [
            'rows' => [],
            'verdict' => '',
        ],
        'ease_of_use' => [
            'content' => (object) [],
            'complexity' => (object) [],
            'comparison_level' => (object) [],
            'verdict' => ''
        ],
        'performance' => [
            'content' => (object) [],
            'speed' => (object) [],
            'comparison_level' => (object) [],
            'verdict' => ''
        ],
        'pricing' => [
            'content' => (object) [],
            'comparison_level' => (object) [],
            'recommendation' => ''
        ],
        'use_case' => [
            'content' => (object) [],
            'comparison_reason' => (object) [],
            'verdict' => ''
        ],
        'pros_cons' => [
            'content' => (object) [],
            'comparison_level' => (object) []
        ],
        'final_verdict' => (object) [],
        'faq' => [],
    ]);
}
?>


<style>
    #plugin_comparison_metabox .inside {
        margin: 0;
        padding: 0;
    }

    .comparison-editor {
        background: #fff;
    }

    .editor-header {
        background: #f9f9f9;
        border-bottom: 1px solid #ddd;
        padding: 15px 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .editor-header h3 {
        margin: 0;
        font-size: 16px;
        font-weight: 600;
    }

    .header-actions {
        display: flex;
        gap: 10px;
    }

    .comp-btn {
        padding: 6px 12px;
        border: 1px solid #2271b1;
        background: #2271b1;
        color: #fff;
        cursor: pointer;
        border-radius: 3px;
        font-size: 13px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 5px;
        transition: all 0.2s;
    }

    .comp-btn:hover {
        background: #135e96;
        border-color: #135e96;
        color: #fff;
    }

    .comp-btn-secondary {
        background: #fff;
        color: #2271b1;
        border-color: #2271b1;
    }

    .comp-btn-secondary:hover {
        background: #f6f7f7;
    }

    .comp-btn-danger {
        background: #d63638;
        border-color: #d63638;
        color: #fff;
    }

    .comp-btn-danger:hover {
        background: #b32d2e;
        border-color: #b32d2e;
    }

    .comp-btn-small {
        padding: 4px 10px;
        font-size: 12px;
    }

    .comp-tabs-wrapper {
        background: #fff;
        border-bottom: 1px solid #ddd;
    }

    .comp-nav-tabs {
        display: flex;
        list-style: none;
        padding: 0 20px;
        margin: 0;
    }

    .comp-nav-tabs li {
        margin: 0;
    }

    .comp-nav-tabs button {
        padding: 12px 20px;
        border: none;
        background: none;
        cursor: pointer;
        font-size: 13px;
        color: #50575e;
        border-bottom: 3px solid transparent;
        transition: all 0.2s;
    }

    .comp-nav-tabs button:hover {
        color: #2271b1;
    }

    .comp-nav-tabs button.active {
        color: #2271b1;
        border-bottom-color: #2271b1;
        font-weight: 600;
    }

    .comp-tab-content {
        padding: 20px;
        max-height: 500px;
        overflow-y: auto;
    }

    .comp-tab-pane {
        display: none;
    }

    .comp-tab-pane.active {
        display: block;
    }

    .comp-form-group {
        margin-bottom: 20px;
    }

    .comp-form-label {
        display: block;
        font-weight: 600;
        margin-bottom: 8px;
        color: #1d2327;
        font-size: 13px;
    }

    .comp-form-control {
        width: 100%;
        padding: 6px 10px;
        border: 1px solid #8c8f94;
        border-radius: 3px;
        font-size: 13px;
        line-height: 1.5;
    }

    .comp-form-control:focus {
        border-color: #2271b1;
        box-shadow: 0 0 0 1px #2271b1;
        outline: none;
    }

    textarea.comp-form-control {
        resize: vertical;
        min-height: 80px;
    }

    .comp-card {
        border: 1px solid #ddd;
        border-radius: 3px;
        margin-bottom: 15px;
        background: #fff;
    }

    .comp-card-header {
        padding: 10px 15px;
        background: #f9f9f9;
        border-bottom: 1px solid #ddd;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .comp-card-header h4 {
        font-size: 13px;
        font-weight: 600;
        color: #1d2327;
        margin: 0;
    }

    .comp-card-body {
        padding: 15px;
    }

    .comp-section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .comp-section-header h4 {
        font-size: 14px;
        font-weight: 600;
        color: #1d2327;
        margin: 0;
    }

    .comp-json-preview {
        background: #282c34;
        color: #abb2bf;
        border: 1px solid #ddd;
        padding: 15px;
        border-radius: 3px;
        overflow-x: auto;
        margin-top: 0;
        font-family: 'Courier New', Consolas, monospace;
        font-size: 11px;
        line-height: 1.6;
        max-height: 400px;
        overflow-y: auto;
    }

    .comp-json-preview pre {
        margin: 0;
        color: #abb2bf;
    }

    .comp-json-header {
        background: #f9f9f9;
        border-top: 1px solid #ddd;
        border-bottom: 1px solid #ddd;
        padding: 10px 20px;
        font-weight: 600;
        font-size: 13px;
    }

    .hidden {
        display: none !important;
    }

    .sections-subtabs-wrapper {
        background: #f9f9f9;
        border-bottom: 1px solid #ddd;
        padding: 0 10px;
        margin-bottom: 20px;
    }

    .sections-subtabs {
        display: flex;
        list-style: none;
        padding: 0;
        margin: 0;
        flex-wrap: wrap;
    }

    .sections-subtabs li {
        margin: 0;
    }

    .sections-subtabs button {
        padding: 10px 16px;
        border: none;
        background: none;
        cursor: pointer;
        font-size: 12px;
        color: #50575e;
        border-bottom: 2px solid transparent;
        transition: all 0.2s;
        white-space: nowrap;
    }

    .sections-subtabs button:hover {
        color: #2271b1;
        background: rgba(34, 113, 177, 0.05);
    }

    .sections-subtabs button.active {
        color: #2271b1;
        border-bottom-color: #2271b1;
        font-weight: 600;
        background: #fff;
    }

    .sections-subtabs-content {
        padding: 0 10px 20px;
    }

    .section-subtab-pane {
        display: none;
    }

    .section-subtab-pane.active {
        display: block;
    }

    .plugin-feature-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 15px;
    }

    @media (max-width: 768px) {
        .plugin-feature-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="comparison-editor">
    <div class="editor-header">
        <h3>Plugin Comparison Data</h3>
        <div class="header-actions">
            <label class="comp-btn comp-btn-secondary">
                <span>📤 Upload JSON</span>
                <input type="file" id="uploadJSON" accept=".json" class="hidden">
            </label>
            <button type="button" class="comp-btn" id="downloadJSON">💾 Download</button>
            <button type="button" class="comp-btn" id="copyJSON">📋 Copy</button>
        </div>
    </div>

    <div class="comp-tabs-wrapper">
        <ul class="comp-nav-tabs">
            <li><button type="button" class="comp-tab-link active" data-tab="basic">Basic Info</button></li>
            <li><button type="button" class="comp-tab-link" data-tab="plugins">Plugins</button></li>
            <li><button type="button" class="comp-tab-link" data-tab="features">Features</button></li>
            <li><button type="button" class="comp-tab-link" data-tab="sections">Sections</button></li>
            <li><button type="button" class="comp-tab-link" data-tab="faq">FAQ</button></li>
        </ul>
    </div>

    <div class="comp-tab-content">
        <!-- Basic Info Tab -->
        <div id="comp-tab-basic" class="comp-tab-pane active">
            <div class="comp-form-group">
                <label class="comp-form-label">Comparison Title</label>
                <input type="text" class="comp-form-control" id="comparisonTitle" placeholder="Enter comparison title">
            </div>
            <div class="comp-form-group">
                <label class="comp-form-label">Overview</label>
                <textarea class="comp-form-control" id="overview" rows="4"
                    placeholder="Enter overview description"></textarea>
            </div>
        </div>

        <!-- Plugins Tab -->
        <div id="comp-tab-plugins" class="comp-tab-pane">
            <div class="comp-section-header">
                <h4>Manage Plugins</h4>
                <button type="button" class="comp-btn" id="addPlugin">➕ Add Plugin</button>
            </div>
            <div id="pluginsList"></div>
        </div>

        <!-- Features Tab -->
        <div id="comp-tab-features" class="comp-tab-pane">
            <div class="comp-section-header">
                <h4>Feature Comparison Table</h4>
                <button type="button" class="comp-btn" id="addFeature">➕ Add Feature</button>
            </div>
            <div id="featuresList"></div>
            <div class="comp-form-group">
                <label class="comp-form-label">Feature Table Verdict</label>
                <textarea class="comp-form-control" id="featureVerdict" rows="3"></textarea>
            </div>
        </div>

        <!-- Sections Tab -->
        <div id="comp-tab-sections" class="comp-tab-pane">
            <div class="sections-subtabs-wrapper">
                <ul class="sections-subtabs" id="sectionSubtabs"></ul>
            </div>
            <div class="sections-subtabs-content" id="sectionsSubtabsContent"></div>
        </div>

        <!-- FAQ Tab -->
        <div id="comp-tab-faq" class="comp-tab-pane">
            <div class="comp-section-header">
                <h4>FAQ</h4>
                <button type="button" class="comp-btn" id="addFAQ">➕ Add FAQ</button>
            </div>
            <div id="faqList"></div>
        </div>
    </div>

    <div class="comp-json-header">
        📄 JSON Output Preview
    </div>
    <div class="comp-json-preview">
        <pre id="jsonOutput"></pre>
    </div>

    <input type="hidden" name="plugin_comparison_data" id="plugin_comparison_data" value="">
</div>

<script>
    jQuery(document).ready(function ($) {
        'use strict';

        let comparisonData = <?php echo $comparison_data; ?>;

        const sections = [
            { key: 'ease_of_use', label: 'Ease of Use', fields: ['content', 'complexity', 'comparison_level', 'verdict'] },
            { key: 'performance', label: 'Performance', fields: ['content', 'speed', 'comparison_level', 'verdict'] },
            { key: 'pricing', label: 'Pricing', fields: ['content', 'comparison_level', 'recommendation'] },
            { key: 'use_case', label: 'Use Case', fields: ['content', 'comparison_reason', 'verdict'] },
            { key: 'pros_cons', label: 'Pros & Cons', fields: ['content', 'comparison_level'] },
            { key: 'final_verdict', label: 'Final Verdict', fields: ['verdict', 'comparison_level'] }
        ];

        // Initialize
        function init() {
            loadInitialData();
            bindEvents();
            renderPlugins();
            renderFeatures();
            renderSections();
            renderFAQ();
            updateJSON();
        }

        // Load initial data
        function loadInitialData() {
            $('#comparisonTitle').val(comparisonData.comparison_title || '');
            $('#overview').val(comparisonData.overview || '');
            if (comparisonData.feature_table && comparisonData.feature_table.verdict) {
                $('#featureVerdict').val(comparisonData.feature_table.verdict);
            }
        }

        // Bind Events
        function bindEvents() {
            $('.comp-tab-link').on('click', function () {
                var tab = $(this).data('tab');
                $('.comp-tab-link').removeClass('active');
                $(this).addClass('active');
                $('.comp-tab-pane').removeClass('active');
                $('#comp-tab-' + tab).addClass('active');
            });

            $('#comparisonTitle').on('input', function () {
                comparisonData.comparison_title = $(this).val();
                updateJSON();
            });

            $('#overview').on('input', function () {
                comparisonData.overview = $(this).val();
                updateJSON();
            });

            $('#featureVerdict').on('input', function () {
                comparisonData.feature_table.verdict = $(this).val();
                updateJSON();
            });

            $('#addPlugin').on('click', addPlugin);
            $('#addFeature').on('click', addFeature);
            $('#addFAQ').on('click', addFAQ);
            $('#downloadJSON').on('click', downloadJSON);
            $('#copyJSON').on('click', copyJSON);
            $('#uploadJSON').on('change', uploadJSON);
        }

        // Plugins
        function renderPlugins() {
            var $list = $('#pluginsList');
            $list.empty();

            if (!comparisonData.plugins || comparisonData.plugins.length === 0) {
                $list.append('<p style="color: #666; font-style: italic;">No plugins added yet. Click "Add Plugin" to start.</p>');
                return;
            }

            comparisonData.plugins.forEach(function (plugin, index) {
                var cardHtml = '<div class="comp-card">' +
                    '<div class="comp-card-header">' +
                    '<h4>Plugin ' + (index + 1) + '</h4>' +
                    '<button type="button" class="comp-btn comp-btn-danger comp-btn-small remove-plugin" data-index="' + index + '">🗑️ Remove</button>' +
                    '</div>' +
                    '<div class="comp-card-body">' +
                    '<div class="comp-form-group">' +
                    '<label class="comp-form-label">Plugin Name</label>' +
                    '<input type="text" class="comp-form-control plugin-name" data-index="' + index + '" value="' + (plugin.name || '') + '">' +
                    '</div>' +
                    '<div class="comp-form-group">' +
                    '<label class="comp-form-label">Slug</label>' +
                    '<input type="text" class="comp-form-control plugin-slug" data-index="' + index + '" value="' + (plugin.slug || '') + '">' +
                    '</div>' +
                    '</div>' +
                    '</div>';
                $list.append(cardHtml);
            });

            $('.plugin-name').on('input', function () {
                var index = $(this).data('index');
                comparisonData.plugins[index].name = $(this).val();
                renderFeatures();
                renderSections();
                updateJSON();
            });

            $('.plugin-slug').on('input', function () {
                var index = $(this).data('index');
                comparisonData.plugins[index].slug = $(this).val();
                renderFeatures();
                renderSections();
                updateJSON();
            });

            $('.remove-plugin').on('click', function () {
                if (!confirm('Are you sure you want to remove this plugin?')) return;
                var index = $(this).data('index');
                comparisonData.plugins.splice(index, 1);
                renderPlugins();
                renderFeatures();
                renderSections();
                updateJSON();
            });
        }

        function addPlugin() {
            comparisonData.plugins.push({ name: '', slug: '' });
            renderPlugins();
            updateJSON();
        }

        // Features
        function renderFeatures() {
            var $list = $('#featuresList');
            $list.empty();

            if (!comparisonData.feature_table || !comparisonData.feature_table.rows || comparisonData.feature_table.rows.length === 0) {
                $list.append('<p style="color: #666; font-style: italic;">No features added yet. Click "Add Feature" to start.</p>');
                return;
            }

            comparisonData.feature_table.rows.forEach(function (row, index) {
                var pluginInputs = '';

                comparisonData.plugins.forEach(function (plugin) {
                    var featureData = row[plugin.slug] || { is_available: 0, note: '' };
                    var isAvailable = featureData.is_available || 0;
                    var note = featureData.note || '';

                    var selected0 = isAvailable == 0 ? 'selected' : '';
                    var selected1 = isAvailable == 1 ? 'selected' : '';

                    pluginInputs += '<div class="comp-card">' +
                        '<div class="comp-card-header">' +
                        '<h4 style="font-size: 12px;">' + (plugin.name || 'Unnamed Plugin') + '</h4>' +
                        '</div>' +
                        '<div class="comp-card-body">' +
                        '<div class="comp-form-group" style="margin-bottom: 10px;">' +
                        '<label class="comp-form-label">Available</label>' +
                        '<select class="comp-form-control feature-available" data-row="' + index + '" data-slug="' + plugin.slug + '">' +
                        '<option value="0" ' + selected0 + '>No</option>' +
                        '<option value="1" ' + selected1 + '>Yes</option>' +
                        '</select>' +
                        '</div>' +
                        '<div class="comp-form-group" style="margin-bottom: 0;">' +
                        '<label class="comp-form-label">Note</label>' +
                        '<input type="text" class="comp-form-control feature-note" data-row="' + index + '" data-slug="' + plugin.slug + '" value="' + note + '" placeholder="Optional note">' +
                        '</div>' +
                        '</div>' +
                        '</div>';
                });

                var cardHtml = '<div class="comp-card">' +
                    '<div class="comp-card-header">' +
                    '<h4>Feature ' + (index + 1) + '</h4>' +
                    '<button type="button" class="comp-btn comp-btn-danger comp-btn-small remove-feature" data-index="' + index + '">🗑️ Remove</button>' +
                    '</div>' +
                    '<div class="comp-card-body">' +
                    '<div class="comp-form-group">' +
                    '<label class="comp-form-label">Feature Name</label>' +
                    '<input type="text" class="comp-form-control feature-name" data-index="' + index + '" value="' + (row.feature || '') + '">' +
                    '</div>' +
                    '<div class="plugin-feature-grid">' +
                    pluginInputs +
                    '</div>' +
                    '</div>' +
                    '</div>';
                $list.append(cardHtml);
            });

            $('.feature-name').on('input', function () {
                var index = $(this).data('index');
                comparisonData.feature_table.rows[index].feature = $(this).val();
                updateJSON();
            });

            $('.feature-available').on('change', function () {
                var row = $(this).data('row');
                var slug = $(this).data('slug');
                if (!comparisonData.feature_table.rows[row][slug]) {
                    comparisonData.feature_table.rows[row][slug] = { is_available: 0, note: '' };
                }
                comparisonData.feature_table.rows[row][slug].is_available = parseInt($(this).val());
                updateJSON();
            });

            $('.feature-note').on('input', function () {
                var row = $(this).data('row');
                var slug = $(this).data('slug');
                if (!comparisonData.feature_table.rows[row][slug]) {
                    comparisonData.feature_table.rows[row][slug] = { is_available: 0, note: '' };
                }
                comparisonData.feature_table.rows[row][slug].note = $(this).val();
                updateJSON();
            });

            $('.remove-feature').on('click', function () {
                if (!confirm('Are you sure you want to remove this feature?')) return;
                var index = $(this).data('index');
                comparisonData.feature_table.rows.splice(index, 1);
                renderFeatures();
                updateJSON();
            });
        }

        function addFeature() {
            var newRow = { feature: '' };
            comparisonData.plugins.forEach(function (plugin) {
                newRow[plugin.slug] = { is_available: 0, note: '' };
            });
            comparisonData.feature_table.rows.push(newRow);
            renderFeatures();
            updateJSON();
        }

        // Sections
        function renderSections() {
            var $subtabs = $('#sectionSubtabs');
            var $content = $('#sectionsSubtabsContent');

            $subtabs.empty();
            $content.empty();

            if (!comparisonData.plugins || comparisonData.plugins.length === 0) {
                $content.append('<p style="color: #666; font-style: italic; padding: 20px;">Please add plugins first to manage sections.</p>');
                return;
            }

            sections.forEach(function (section, sectionIndex) {
                var activeClass = sectionIndex === 0 ? 'active' : '';
                var tabHtml = '<li><button type="button" class="section-subtab-link ' + activeClass + '" data-section="' + section.key + '">' + section.label + '</button></li>';
                $subtabs.append(tabHtml);

                var paneActiveClass = sectionIndex === 0 ? 'active' : '';
                var sectionContent = '';

                // Handle pros_cons section
                if (section.key === 'pros_cons') {
                    comparisonData.plugins.forEach(function (plugin) {
                        var pros = '';
                        var cons = '';
                        var level = 'moderate';

                        if (comparisonData[section.key] && comparisonData[section.key].content && comparisonData[section.key].content[plugin.slug]) {
                            var contentData = comparisonData[section.key].content[plugin.slug];
                            pros = Array.isArray(contentData.pros) ? contentData.pros.join('\n') : '';
                            cons = Array.isArray(contentData.cons) ? contentData.cons.join('\n') : '';
                        }
                        if (comparisonData[section.key] && comparisonData[section.key].comparison_level) {
                            level = comparisonData[section.key].comparison_level[plugin.slug] || 'moderate';
                        }

                        sectionContent += '<div class="comp-card">' +
                            '<div class="comp-card-header"><h4>' + (plugin.name || 'Unnamed Plugin') + '</h4></div>' +
                            '<div class="comp-card-body">' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Pros (one per line)</label>' +
                            '<textarea class="comp-form-control section-pros" data-section="' + section.key + '" data-slug="' + plugin.slug + '" rows="4">' + pros + '</textarea>' +
                            '</div>' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Cons (one per line)</label>' +
                            '<textarea class="comp-form-control section-cons" data-section="' + section.key + '" data-slug="' + plugin.slug + '" rows="4">' + cons + '</textarea>' +
                            '</div>' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Comparison Level</label>' +
                            '<select class="comp-form-control section-level" data-section="' + section.key + '" data-slug="' + plugin.slug + '">' +
                            '<option value="win"' + (level === 'win' ? ' selected' : '') + '>Win</option>' +
                            '<option value="high"' + (level === 'high' ? ' selected' : '') + '>High</option>' +
                            '<option value="moderate"' + (level === 'moderate' ? ' selected' : '') + '>Moderate</option>' +
                            '<option value="low"' + (level === 'low' ? ' selected' : '') + '>Low</option>' +
                            '</select>' +
                            '</div>' +
                            '</div></div>';
                    });
                }
                // Handle PRICING section - FIXED VERSION
                else if (section.key === 'pricing') {
                    comparisonData.plugins.forEach(function (plugin) {
                        var content = '';
                        var pricingLevel = 'moderate';
                        var pricingNote = '';

                        // Get content
                        if (comparisonData[section.key] && comparisonData[section.key].content) {
                            content = comparisonData[section.key].content[plugin.slug] || '';
                        }

                        // Get comparison_level data (handles both old and new format)
                        if (comparisonData[section.key] && comparisonData[section.key].comparison_level) {
                            var levelData = comparisonData[section.key].comparison_level[plugin.slug];

                            if (typeof levelData === 'object' && levelData !== null) {
                                // New format: {pricing: "win", note: "..."}
                                pricingLevel = levelData.pricing || 'moderate';
                                pricingNote = levelData.note || '';
                            } else if (typeof levelData === 'string') {
                                // Old format: just a string value
                                pricingLevel = levelData;
                            }
                        }

                        sectionContent += '<div class="comp-card">' +
                            '<div class="comp-card-header"><h4>' + (plugin.name || 'Unnamed Plugin') + '</h4></div>' +
                            '<div class="comp-card-body">' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Content</label>' +
                            '<textarea class="comp-form-control pricing-content" data-section="' + section.key + '" data-slug="' + plugin.slug + '" rows="3">' + content + '</textarea>' +
                            '</div>' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Comparison Level</label>' +
                            '<select class="comp-form-control pricing-level" data-section="' + section.key + '" data-slug="' + plugin.slug + '">' +
                            '<option value="win"' + (pricingLevel === 'win' ? ' selected' : '') + '>Win</option>' +
                            '<option value="high"' + (pricingLevel === 'high' ? ' selected' : '') + '>High</option>' +
                            '<option value="moderate"' + (pricingLevel === 'moderate' ? ' selected' : '') + '>Moderate</option>' +
                            '<option value="low"' + (pricingLevel === 'low' ? ' selected' : '') + '>Low</option>' +
                            '</select>' +
                            '</div>' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Note (Optional)</label>' +
                            '<input type="text" class="comp-form-control pricing-note" data-section="' + section.key + '" data-slug="' + plugin.slug + '" value="' + pricingNote + '" placeholder="Additional pricing information">' +
                            '</div>' +
                            '</div></div>';
                    });

                    // Add global recommendation field for pricing
                    var recommendation = comparisonData[section.key] && comparisonData[section.key].recommendation ? comparisonData[section.key].recommendation : '';

                    sectionContent += '<div class="comp-form-group" style="margin-top: 20px; padding-top: 20px; border-top: 2px solid #ddd;">' +
                        '<label class="comp-form-label">Recommendation (Global)</label>' +
                        '<textarea class="comp-form-control section-global-field" data-section="' + section.key + '" data-field="recommendation" rows="3">' + recommendation + '</textarea>' +
                        '</div>';
                }
                // Handle final_verdict section
                else if (section.key === 'final_verdict') {
                    comparisonData.plugins.forEach(function (plugin) {
                        var verdict = '';
                        var level = 'moderate';

                        if (comparisonData[section.key] && comparisonData[section.key][plugin.slug]) {
                            verdict = comparisonData[section.key][plugin.slug].verdict || '';
                            level = comparisonData[section.key][plugin.slug].comparison_level || 'moderate';
                        }

                        sectionContent += '<div class="comp-card">' +
                            '<div class="comp-card-header"><h4>' + (plugin.name || 'Unnamed Plugin') + '</h4></div>' +
                            '<div class="comp-card-body">' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Verdict</label>' +
                            '<textarea class="comp-form-control section-verdict" data-section="' + section.key + '" data-slug="' + plugin.slug + '" rows="3">' + verdict + '</textarea>' +
                            '</div>' +
                            '<div class="comp-form-group">' +
                            '<label class="comp-form-label">Comparison Level</label>' +
                            '<select class="comp-form-control section-verdict-level" data-section="' + section.key + '" data-slug="' + plugin.slug + '">' +
                            '<option value="win"' + (level === 'win' ? ' selected' : '') + '>Win</option>' +
                            '<option value="high"' + (level === 'high' ? ' selected' : '') + '>High</option>' +
                            '<option value="moderate"' + (level === 'moderate' ? ' selected' : '') + '>Moderate</option>' +
                            '<option value="low"' + (level === 'low' ? ' selected' : '') + '>Low</option>' +
                            '</select>' +
                            '</div>' +
                            '</div></div>';
                    });
                }
                // Handle standard sections (ease_of_use, performance, use_case)
                else {
                    // Per-plugin fields
                    comparisonData.plugins.forEach(function (plugin) {
                        sectionContent += '<div class="comp-card">' +
                            '<div class="comp-card-header"><h4>' + (plugin.name || 'Unnamed Plugin') + '</h4></div>' +
                            '<div class="comp-card-body">';

                        section.fields.forEach(function (field) {
                            if (field === 'verdict' || field === 'recommendation') return; // Skip global fields

                            var fieldValue = '';
                            var fieldLabel = field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());

                            if (comparisonData[section.key] && comparisonData[section.key][field]) {
                                fieldValue = comparisonData[section.key][field][plugin.slug] || '';
                            }

                            if ((field === 'comparison_level' && section.key !== 'pricing') ||
                                field === 'complexity' ||
                                field === 'speed') {
                                var level = fieldValue || 'moderate';
                                sectionContent += '<div class="comp-form-group">' +
                                    '<label class="comp-form-label">' + fieldLabel + '</label>' +
                                    '<select class="comp-form-control section-field" data-section="' + section.key + '" data-field="' + field + '" data-slug="' + plugin.slug + '">' +
                                    '<option value="win"' + (level === 'win' ? ' selected' : '') + '>Win</option>' +
                                    '<option value="high"' + (level === 'high' ? ' selected' : '') + '>High</option>' +
                                    '<option value="moderate"' + (level === 'moderate' ? ' selected' : '') + '>Moderate</option>' +
                                    '<option value="low"' + (level === 'low' ? ' selected' : '') + '>Low</option>' +
                                    '<option value="simple"' + (level === 'simple' ? ' selected' : '') + '>Simple</option>' +
                                    '<option value="fast"' + (level === 'fast' ? ' selected' : '') + '>Fast</option>' +
                                    '</select>' +
                                    '</div>';
                            } else {
                                sectionContent += '<div class="comp-form-group">' +
                                    '<label class="comp-form-label">' + fieldLabel + '</label>' +
                                    '<textarea class="comp-form-control section-field" data-section="' + section.key + '" data-field="' + field + '" data-slug="' + plugin.slug + '" rows="3">' + fieldValue + '</textarea>' +
                                    '</div>';
                            }
                        });

                        sectionContent += '</div></div>';
                    });

                    // Add global verdict/recommendation field
                    section.fields.forEach(function (field) {
                        if (field === 'verdict' || field === 'recommendation') {
                            var globalValue = comparisonData[section.key] && comparisonData[section.key][field] ? comparisonData[section.key][field] : '';
                            var fieldLabel = field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());

                            sectionContent += '<div class="comp-form-group" style="margin-top: 20px; padding-top: 20px; border-top: 2px solid #ddd;">' +
                                '<label class="comp-form-label">' + fieldLabel + ' (Global)</label>' +
                                '<textarea class="comp-form-control section-global-field" data-section="' + section.key + '" data-field="' + field + '" rows="3">' + globalValue + '</textarea>' +
                                '</div>';
                        }
                    });
                }

                var paneHtml = '<div class="section-subtab-pane ' + paneActiveClass + '" id="section-pane-' + section.key + '">' + sectionContent + '</div>';
                $content.append(paneHtml);
            });

            // Bind events
            $('.section-subtab-link').on('click', function () {
                var sectionKey = $(this).data('section');
                $('.section-subtab-link').removeClass('active');
                $(this).addClass('active');
                $('.section-subtab-pane').removeClass('active');
                $('#section-pane-' + sectionKey).addClass('active');
            });

            // Standard field handlers
            $('.section-field').on('input change', function () {
                var section = $(this).data('section');
                var field = $(this).data('field');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section][field]) comparisonData[section][field] = {};

                comparisonData[section][field][slug] = $(this).val();
                updateJSON();
            });

            // Global field handlers
            $('.section-global-field').on('input', function () {
                var section = $(this).data('section');
                var field = $(this).data('field');

                if (!comparisonData[section]) comparisonData[section] = {};
                comparisonData[section][field] = $(this).val();
                updateJSON();
            });

            // PRICING SPECIFIC HANDLERS - NEW
            $('.pricing-content').on('input', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section].content) comparisonData[section].content = {};

                comparisonData[section].content[slug] = $(this).val();
                updateJSON();
            });

            $('.pricing-level').on('change', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section].comparison_level) comparisonData[section].comparison_level = {};
                if (typeof comparisonData[section].comparison_level[slug] !== 'object') {
                    comparisonData[section].comparison_level[slug] = { pricing: 'moderate', note: '' };
                }

                comparisonData[section].comparison_level[slug].pricing = $(this).val();
                updateJSON();
            });

            $('.pricing-note').on('input', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section].comparison_level) comparisonData[section].comparison_level = {};
                if (typeof comparisonData[section].comparison_level[slug] !== 'object') {
                    comparisonData[section].comparison_level[slug] = { pricing: 'moderate', note: '' };
                }

                comparisonData[section].comparison_level[slug].note = $(this).val();
                updateJSON();
            });

            // Pros/Cons handlers
            $('.section-pros').on('input', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section].content) comparisonData[section].content = {};
                if (!comparisonData[section].content[slug]) comparisonData[section].content[slug] = { pros: [], cons: [] };

                var prosText = $(this).val();
                comparisonData[section].content[slug].pros = prosText.split('\n').filter(line => line.trim() !== '');
                updateJSON();
            });

            $('.section-cons').on('input', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section].content) comparisonData[section].content = {};
                if (!comparisonData[section].content[slug]) comparisonData[section].content[slug] = { pros: [], cons: [] };

                var consText = $(this).val();
                comparisonData[section].content[slug].cons = consText.split('\n').filter(line => line.trim() !== '');
                updateJSON();
            });

            $('.section-level').on('change', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section].comparison_level) comparisonData[section].comparison_level = {};
                comparisonData[section].comparison_level[slug] = $(this).val();
                updateJSON();
            });

            // Final verdict handlers
            $('.section-verdict').on('input', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section][slug]) comparisonData[section][slug] = { verdict: '', comparison_level: 'moderate' };

                comparisonData[section][slug].verdict = $(this).val();
                updateJSON();
            });

            $('.section-verdict-level').on('change', function () {
                var section = $(this).data('section');
                var slug = $(this).data('slug');

                if (!comparisonData[section]) comparisonData[section] = {};
                if (!comparisonData[section][slug]) comparisonData[section][slug] = { verdict: '', comparison_level: 'moderate' };

                comparisonData[section][slug].comparison_level = $(this).val();
                updateJSON();
            });
        }

        // FAQ
        function renderFAQ() {
            var $list = $('#faqList');
            $list.empty();

            if (!comparisonData.faq || comparisonData.faq.length === 0) {
                $list.append('<p style="color: #666; font-style: italic;">No FAQs added yet. Click "Add FAQ" to start.</p>');
                return;
            }

            comparisonData.faq.forEach(function (faq, index) {
                var cardHtml = '<div class="comp-card">' +
                    '<div class="comp-card-header">' +
                    '<h4>FAQ ' + (index + 1) + '</h4>' +
                    '<button type="button" class="comp-btn comp-btn-danger comp-btn-small remove-faq" data-index="' + index + '">🗑️ Remove</button>' +
                    '</div>' +
                    '<div class="comp-card-body">' +
                    '<div class="comp-form-group">' +
                    '<label class="comp-form-label">Question</label>' +
                    '<input type="text" class="comp-form-control faq-question" data-index="' + index + '" value="' + (faq.question || '') + '">' +
                    '</div>' +
                    '<div class="comp-form-group">' +
                    '<label class="comp-form-label">Answer</label>' +
                    '<textarea class="comp-form-control faq-answer" data-index="' + index + '" rows="2">' + (faq.answer || '') + '</textarea>' +
                    '</div>' +
                    '</div>' +
                    '</div>';
                $list.append(cardHtml);
            });

            $('.faq-question').on('input', function () {
                var index = $(this).data('index');
                comparisonData.faq[index].question = $(this).val();
                updateJSON();
            });

            $('.faq-answer').on('input', function () {
                var index = $(this).data('index');
                comparisonData.faq[index].answer = $(this).val();
                updateJSON();
            });

            $('.remove-faq').on('click', function () {
                if (!confirm('Are you sure you want to remove this FAQ?')) return;
                var index = $(this).data('index');
                comparisonData.faq.splice(index, 1);
                renderFAQ();
                updateJSON();
            });
        }

        function addFAQ() {
            comparisonData.faq.push({ question: '', answer: '' });
            renderFAQ();
            updateJSON();
        }

        // JSON Operations
        function updateJSON() {
            var json = JSON.stringify(comparisonData, null, 2);
            $('#jsonOutput').text(json);
            $('#plugin_comparison_data').val(json);
        }

        function downloadJSON() {
            var json = JSON.stringify(comparisonData, null, 2);
            var blob = new Blob([json], { type: 'application/json' });
            var url = URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = 'plugin-comparison-<?php echo $post->ID; ?>.json';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function copyJSON() {
            var json = JSON.stringify(comparisonData, null, 2);
            var tempTextarea = document.createElement('textarea');
            tempTextarea.value = json;
            document.body.appendChild(tempTextarea);
            tempTextarea.select();
            document.execCommand('copy');
            document.body.removeChild(tempTextarea);
            alert('JSON copied to clipboard!');
        }

        function uploadJSON(e) {
            var file = e.target.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    try {
                        var newData = JSON.parse(e.target.result);
                        comparisonData = newData;
                        loadData();
                        alert('JSON loaded successfully!');
                    } catch (error) {
                        alert('Invalid JSON file: ' + error.message);
                    }
                };
                reader.readAsText(file);
            }
            $(this).val('');
        }

        function loadData() {
            $('#comparisonTitle').val(comparisonData.comparison_title || '');
            $('#overview').val(comparisonData.overview || '');
            $('#featureVerdict').val(comparisonData.feature_table && comparisonData.feature_table.verdict ? comparisonData.feature_table.verdict : '');
            renderPlugins();
            renderFeatures();
            renderSections();
            renderFAQ();
            updateJSON();
        }

        // Start
        init();
    });
</script>