<?php
// ✅ Handle Save Submit
if (isset($_POST['category_replace_nonce']) && wp_verify_nonce($_POST['category_replace_nonce'], 'save_category_replace')) {

    if (!empty($_POST['replace_cats']) && is_array($_POST['replace_cats'])) {
        foreach ($_POST['replace_cats'] as $cat_id => $replace_ids) {

            // Clean values
            $ids = array_map('intval', $replace_ids);

            // Convert to comma separated string
            $save_value = implode(',', $ids);

            // Save as term meta, NO AUTOLOAD
            update_term_meta($cat_id, '_replaceable_cats', $save_value);
        }
    }

    echo '<div class="updated"><p>Category Mapping Saved ✅</p></div>';
}

// ✅ Load ALL categories (no parent filter)
$categories = get_terms([
    'taxonomy'   => 'plugin_category',
    'hide_empty' => false,
    'parent' => 0,
]);

?>
<div class="wrap">
    <h2>Category Replace Mapping</h2>

    <form method="post">
        <?php wp_nonce_field('save_category_replace', 'category_replace_nonce'); ?>

        <table class="widefat" id="replace-table" style="width:700px;">
            <thead>
                <tr>
                    <th style="width:30%">Category (keep this)</th>
                    <th style="width:60%">Replaceable Categories (remove this)</th>
                    <th style="width:10%">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $cat): 
                    $saved = get_term_meta($cat->term_id, '_replaceable_cats', true);
                    $saved_ids = $saved ? array_map('intval', explode(',', $saved)) : [];
                ?>
                <tr>
                    <td><strong><?php echo esc_html($cat->name); ?></strong></td>
                    <td>
                        <select name="replace_cats[<?php echo $cat->term_id; ?>][]" multiple 
                                class="replace-select" style="width:100%;">
                            <?php foreach ($categories as $c2): ?>
                                <option value="<?php echo $c2->term_id; ?>" 
                                    <?php echo in_array($c2->term_id, $saved_ids) ? 'selected' : ''; ?>>
                                    <?php echo esc_html($c2->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                    <td></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <br>
        <input type="submit" class="button button-primary" value="Save Mapping">
    </form>
</div>

<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
.select2-container { min-width:100% !important; }
</style>

<script>
jQuery(function($){
    $('.replace-select').select2({
        placeholder: "Select replaceable categories",
        width:'resolve'
    });
});
</script>
