<?php
class site_settings
{
    public static function wpsearch_custom_settings_menu()
    {
        add_options_page(
            'Plugin Metric Information Settings',           // Page title
            'Plugin Metric Information Settings',           // Menu title
            'manage_options',            // Capability
            'plugin-metric-information-settings',        // Menu slug
            array('site_settings', 'plugin_metric_information_settings')    // Function to display content
        );
        add_options_page(
            'Cron Job list',           // Page title
            'Cron Job list',           // Menu title
            'manage_options',            // Capability
            'custom-cron-job-list',        // Menu slug
            array('site_settings', 'plugin_custom_cron_job_list')    // Function to display content
        );

        // ✅ Add new OpenAI settings page
        add_options_page(
            'OpenAI API Settings',               // Page title
            'OpenAI API Settings',               // Menu title
            'manage_options',                    // Capability
            'openai-api-settings',               // Menu slug
            array('site_settings', 'openai_api_settings_page') // Callback
        );
        // ✅ Add new OpenAI settings page
        add_options_page(
            'Information Gemini Search',               // Page title
            'Information Gemini Search',               // Menu title
            'manage_options',                    // Capability
            'information-gemini-search',               // Menu slug
            array('site_settings', 'information_gemini_search') // Callback
        );

    }
    public static function information_gemini_search()
    {
        if (!current_user_can('manage_options')) {
            return;
        }
        require get_template_directory() . '/admin/plugin-metric-settings/getting-meta-data-gemeni-command.php';
    }
    public static function plugin_metric_information_settings()
    {
        if (!current_user_can('manage_options')) {
            return;
        }
        // global $wpdb;
        // $full_table_name = $wpdb->prefix . "plugins_core_information";
        // $query = $wpdb->prepare(
        //     "
        // SELECT COLUMN_NAME, DATA_TYPE
        // FROM INFORMATION_SCHEMA.COLUMNS
        // WHERE TABLE_SCHEMA = %s
        //   AND TABLE_NAME = %s
        //   AND DATA_TYPE IN ('tinyint','smallint','mediumint','int','bigint','decimal','numeric','float','double','real')
        // ",
        //     DB_NAME,
        //     $full_table_name
        // );

        // $results = $wpdb->get_results($query);

        // if (empty($results)) {
        //     return [];
        // }

        // // Return only column names
        // $column_names = wp_list_pluck($results, 'COLUMN_NAME');
        require get_template_directory() . '/admin/plugin-metric-settings/new-table.php';
    }
    public static function plugin_custom_cron_job_list()
    {
        if (!current_user_can('manage_options')) {
            return;
        }
        require get_template_directory() . '/admin/plugin-metric-settings/cron-job-list.php';
    }
    public static function openai_api_settings_page()
    {
        if (!current_user_can('manage_options')) {
            return;
        }
        require get_template_directory() . '/admin/plugin-metric-settings/open-ai-key-settings.php';

    }
    public static function save_command_data_for_meta()
    {

        // Always sanitize user input
        $msg1 = isset($_POST['message_1']) ? sanitize_textarea_field($_POST['message_1']) : '';
        $msg2 = isset($_POST['message_2']) ? sanitize_textarea_field($_POST['message_2']) : '';

        // Save as array
        update_option('gemini_command_data_for_getting_meta', [
            'message_1' => $msg1,
            'message_2' => $msg2
        ],false);

        wp_send_json_success('Saved successfully');
    }
}