<?php
// Load WordPress environment safely
require_once dirname(__FILE__) . '/index.php';

class Wp_plugin_missing_feature_image
{

    public function __construct()
    {

        // Check & acquire lock
        if (! wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->wpPluginMissingFeatureImage();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Main process — updates active_installs in cron_scraped_plugins_log
     */
    private function wpPluginMissingFeatureImage()
    {
        global $wpdb;

        $tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";
        $tbl_cron_scraped_plugins_log = $wpdb->prefix . "cron_scraped_plugins_log";

        // Log run
        update_option('wp_plugin_missing_feature_image_last_run', current_time('mysql'), false);

        // ✅ Get plugins missing feature image
        $plugins_core_information = $wpdb->get_results(
            "SELECT id, slug
         FROM {$tbl_plugins_core_information}
         WHERE plugin_feature_image IS NULL
            OR plugin_feature_image = ''"
        );

        if (empty($plugins_core_information)) {
            echo "No Plugins found.\n";
            return;
        }

        foreach ($plugins_core_information as $plugin) {

            $icon = $this->scrap_the_missing_feature_image($plugin->slug);

            if (! empty($icon)) {

                // ✅ Update main table
                $wpdb->update(
                    $tbl_plugins_core_information,
                    ['plugin_feature_image' => $icon],
                    ['id' => $plugin->id],
                    ['%s'],
                    ['%d']
                );

                // ✅ Check & update cron scraped plugins table
                $exists = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT 1 FROM $tbl_cron_scraped_plugins_log
                     WHERE plugin_slug = %s
                       AND (plugin_icon IS NULL OR plugin_icon = '')",
                        $plugin->slug
                    )
                );

                if ($exists) {
                    $wpdb->update(
                        $tbl_cron_scraped_plugins_log,
                        ['plugin_icon' => $icon],
                        ['plugin_slug' => $plugin->slug],
                        ['%s'],
                        ['%s']
                    );
                }
            }
        }

        // ✅ End timestamp
        update_option('wp_plugin_missing_feature_image_job_last_run', current_time('mysql'), false);
    }
    private function scrap_the_missing_feature_image($slug)
    {
        try {

            $icon       = null;
            $scrapp_url = "https://wordpress.org/plugins/" . $slug;
            $ch         = curl_init($scrapp_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            $html_data = curl_exec($ch);
            curl_close($ch);

            if ($html_data) {
                $html = str_get_html($html_data);
            } else {
                $html = false;
            }
            if (! $html) {
                return null;
            }

            $thumbnail = $html->find('div.entry-thumbnail img.plugin-icon', 0);

            if ($thumbnail && isset($thumbnail->src)) {
                $icon = $thumbnail->src;
            }
            return $icon;

        } catch (Exception $e) {
            return false;
        }

    }

}

// Instantiate the class
new Wp_plugin_missing_feature_image();
