<?php
require_once dirname(__FILE__) . '/index.php';

class WpManageScrappFlagManagement
{

    public function __construct()
    {
        // Run the reset process when object is created

        // Check & acquire lock
        if (! wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->resetFlags();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Reset flags based on last_visited_at condition
     */
    private function resetFlags()
    {
        global $wpdb;

        $table_cron_page_visits = $wpdb->prefix . "cron_page_visits_log";
        $cron_scraped_plugins   = $wpdb->prefix . "cron_scraped_plugins_log";

        // ✅ 1. Reset visited flag in page visits table
        $wpdb->query(
            "UPDATE {$table_cron_page_visits}
             SET visited = 0
             WHERE last_visited_at IS NULL
                OR last_visited_at < DATE_SUB(NOW(), INTERVAL 7 DAY)"
        );

        // ✅ 2. Reset flags in scraped plugins table
        $wpdb->query(
            "UPDATE {$cron_scraped_plugins}
             SET api_scrapped = 0,
                 scrapped = 0,
                 is_wps_score_field_set = 0,
                 is_wps_score_calculated = 0
             WHERE last_scraped_at IS NULL
                OR last_scraped_at < DATE_SUB(NOW(), INTERVAL 7 DAY)"
        );

        update_option('reset_cron_flag_job_run', current_time('mysql'), false);
        echo "done";
    }
}

// Instantiate the class to trigger the process
new WpManageScrappFlagManagement();
