<?php
require_once dirname(__FILE__) . '/index.php';

class WpGeneratePost
{

    public function __construct()
    {
        if (!new_post_publishing) {
            echo "No plan to Generate New post so no new AI call";
            update_option('wp_plugin_generate_post_last_run', current_time('mysql'), false);
            return; // already running
        }
        // Check & acquire lock
        if (!wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->wpGeneratePost();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    private function wpGeneratePost()
    {
        global $wpdb;
        $tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";
        update_option('wp_plugin_generate_post_last_run', current_time('mysql'), false);
        $core_plugin_information = $wpdb->get_results("
        SELECT
        id,
        name,
        slug,
        plugin_open_ai_long_description,
        plugin_open_ai_short_description,
        plugin_feature_meta_key_word_ai,
        plugin_open_ai_category,
        plugin_tags
        FROM {$tbl_plugins_core_information}
        WHERE
            is_wp_post_created = 0
            AND is_api_crawled = 1
            AND is_web_crawled = 1
            AND is_ai_long_description_done = 1
            AND is_ai_short_description_done = 1
            AND is_ai_meta_keywords_done = 1
            AND is_ai_tax_category_done = 1
        LIMIT 100
    ");
        if (empty($core_plugin_information)) {
            echo "No Plugins found.\n";
            return;
        }
        foreach ($core_plugin_information as $single_key => $single_value) {
            $categories = $this->generate_post_taxonomy($single_value->plugin_open_ai_category);
            $tags = $this->generate_post_tags($single_value->plugin_tags);
            //dd($categories);
            //exit;
            $taxonomy = 'plugin_category';
            $taxonomy_tags = 'plugin_tag';

            // ✅ Prepare post data
            $post_data = [
                'post_title' => $single_value->name,
                'post_name' => $single_value->slug,
                'post_content' => $single_value->plugin_open_ai_long_description,
                'post_excerpt' => $single_value->plugin_open_ai_short_description,
                'post_status' => 'publish',
                'post_type' => 'plugins',
            ];
            $post_id = $this->insert_post($post_data, $categories, $taxonomy, $tags, $taxonomy_tags);
            $wpdb->update(
                $tbl_plugins_core_information,
                [
                    'is_wp_post_created' => 1,
                    'wp_post_id' => $post_id,
                    'post_title' => $single_value->name,
                    'post_short_descripton' => $single_value->plugin_open_ai_short_description,
                    'post_long_descripton' => $single_value->plugin_open_ai_long_description,
                    'post_meta_keywords' => $single_value->plugin_feature_meta_key_word_ai,

                ],
                ['id' => $single_value->id],
                ['%d', '%d', '%s', '%s', '%s', '%s'],
                ['%d']
            );

        }
        update_option('wp_plugin_generate_post_last_run', current_time('mysql'), false);
    }
    private function generate_post_taxonomy($category_json)
    {
        $taxonomy = 'plugin_category';

        // ✅ Decode AI JSON safely
        $ai_data = json_decode($category_json, true);
        if (!is_array($ai_data) || empty($ai_data['category'])) {
            taxonomy_creation_log("❌ Missing or invalid 'category' key in AI JSON data.");
            return [];
        }

        // Get AI-suggested category and subcategories
        $ai_category = trim($ai_data['category']);
        $ai_subcategories = [];

        if (!empty($ai_data['subcategories'])) {
            if (is_string($ai_data['subcategories'])) {
                $ai_subcategories = array_filter(array_map('trim', explode(',', $ai_data['subcategories'])));
            } elseif (is_array($ai_data['subcategories'])) {
                $ai_subcategories = array_filter(array_map('trim', $ai_data['subcategories']));
            }
        }

        $term_ids = [];

        // ✅ Convert AI category to slug using wps_create_slug
        $category_slug = wps_create_slug($ai_category);
        $main_term = get_term_by('slug', $category_slug, $taxonomy);

        if (!$main_term) {
            taxonomy_creation_log("⚠️ AI category '{$ai_category}' (slug: {$category_slug}) not found in WordPress. Run sync first.");
            return [];
        }

        // Add main category
        $term_ids[] = $main_term->term_id;

        // ✅ Convert AI subcategories to slugs using wps_create_slug
        if (!empty($ai_subcategories)) {
            foreach ($ai_subcategories as $ai_subcat) {
                $subcat_slug = wps_create_slug($ai_subcat);
                $sub_term = get_term_by('slug', $subcat_slug, $taxonomy);

                if ($sub_term) {
                    // Verify it's actually a child of the main category (optional safety check)
                    if ($sub_term->parent === $main_term->term_id) {
                        $term_ids[] = $sub_term->term_id;
                    } else {
                        // Subcategory found but under different parent
                        if ($sub_term->parent > 0) {
                            $actual_parent = get_term($sub_term->parent, $taxonomy);
                            $parent_name = $actual_parent && !is_wp_error($actual_parent) ? $actual_parent->name : 'Unknown';
                            taxonomy_creation_log("⚠️ Subcategory '{$ai_subcat}' (slug: {$subcat_slug}) found under '{$parent_name}' instead of '{$ai_category}'. Using it anyway.");
                        } else {
                            taxonomy_creation_log("⚠️ Subcategory '{$ai_subcat}' (slug: {$subcat_slug}) found as top-level term, not under '{$ai_category}'. Using it anyway.");
                        }
                        // Still add it to term_ids
                        $term_ids[] = $sub_term->term_id;
                    }
                } else {
                    taxonomy_creation_log("⚠️ AI subcategory '{$ai_subcat}' (slug: {$subcat_slug}) not found in WordPress.");
                }
            }
        }

        return array_unique($term_ids);

    }
    private function insert_post($post_data, $categories, $taxonomy, $tags, $taxonomy_tags)
    {
        //dd($categories);
        // ✅ Insert post
        $post_id = wp_insert_post($post_data);

        if (is_wp_error($post_id)) {
            taxonomy_creation_log('Error creating post: ' . $post_id->get_error_message());
            return false;
        }

        // ✅ Assign taxonomy terms
        if (!empty($categories)) {
            taxonomy_creation_log('Working.... assignment of category');
            wp_set_object_terms($post_id, $categories, $taxonomy, false);
        }
        if (!empty($tags)) {
            taxonomy_creation_log('Working.... assignment of tags');
            wp_set_object_terms($post_id, $tags, $taxonomy_tags, false);
        }

        // ✅ Add custom meta fields if provided
        if (!empty($post_data['meta']) && is_array($post_data['meta'])) {
            foreach ($post_data['meta'] as $key => $value) {
                update_post_meta($post_id, $key, $value);
            }
        }

        return $post_id;
    }
    private function generate_post_tags($plugin_tags)
    {
        // Convert comma-separated string into array
        $plugin_tags_array = !empty($plugin_tags)
            ? array_map('trim', explode(',', $plugin_tags))
            : [];

        if (empty($plugin_tags_array)) {
            return [];
        }

        $taxonomy = 'plugin_tag';
        $term_ids = [];

        foreach ($plugin_tags_array as $tag_name) {

            if (empty($tag_name)) {
                continue;
            }

            // 🔍 Check if term already exists (by name)
            $existing_term = term_exists($tag_name, $taxonomy);

            if ($existing_term !== 0 && $existing_term !== null) {
                // Tag exists → push ID
                $term_ids[] = (int) $existing_term['term_id'];
            } else {
                // ➕ Insert new tag
                $new_term = wp_insert_term($tag_name, $taxonomy);

                if (!is_wp_error($new_term)) {
                    $term_ids[] = (int) $new_term['term_id'];
                }
            }
        }

        return $term_ids;
    }

}

// Instantiate the class
new WpGeneratePost();
