<?php
//load core wordpress
require_once dirname(__FILE__) . '/../wp-load.php';
require_once dirname(__FILE__) . '/simplehtmldom/simple_html_dom.php';

//constant define
define('total_pages_wp_org_plugin_api', 560);
define('per_page_wp_org_plugin_api', 100);
define('YOUR_OPENAI_API_KEY', get_option('openai_api_key'));

function getLinkInnerText($linkHtml)
{
    if (empty($linkHtml)) {
        return null;
    }

    // Use DOMDocument to parse the HTML
    $dom = new DOMDocument();

    // Suppress errors due to malformed HTML
    libxml_use_internal_errors(true);
    $dom->loadHTML($linkHtml, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
    libxml_clear_errors();

    // Get the anchor tag
    $anchor = $dom->getElementsByTagName('a')->item(0);

    // Return the inner text if anchor tag is found
    return $anchor ? $anchor->textContent : '';
}
function html_to_plain_text($html)
{
    // 1️⃣ Remove scripts, styles, and iframes completely
    $html = preg_replace('#<(script|style|iframe)[^>]*?>.*?</\1>#si', '', $html);

    // 2️⃣ Replace <p>, <br>, and block tags with a period + space
    $html = preg_replace('/<\/?(p|div|h[1-6]|li|ul|ol|br|section|article|blockquote)[^>]*>/i', '. ', $html);

    // 3️⃣ Strip all other HTML tags
    $text = strip_tags($html);

    // 4️⃣ Decode HTML entities
    $text = html_entity_decode($text, ENT_QUOTES | ENT_HTML5, 'UTF-8');

    // 5️⃣ Remove multiple spaces, tabs, or line breaks
    $text = preg_replace('/\s+/', ' ', $text);

    // 6️⃣ Remove duplicate periods (e.g., "... ..." → ". ")
    $text = preg_replace('/(\.\s*)+/', '. ', $text);

    // 7️⃣ Trim and ensure proper ending punctuation
    $text = trim($text);
    if (! preg_match('/[.!?]$/', $text)) {
        $text .= '.';
    }
    return $text;
    // $word_count = str_word_count(strip_tags($text));

    // return [
    //     'text' => $text,
    //     'word_count' => $word_count
    // ];
}
function to_mysql_datetime($time = null)
{
    // If no time passed, use current time
    if (empty($time)) {
        return gmdate("Y-m-d H:i:s"); // always safe UTC format
    }

    // Convert using strtotime()
    $timestamp = strtotime($time);

    // If invalid date string, return current UTC time
    if ($timestamp === false) {
        return gmdate("Y-m-d H:i:s");
    }

    // Return formatted for MySQL
    return gmdate("Y-m-d H:i:s", $timestamp);
}
function plugin_tag_handle_convert_to_comma_separated($tags)
{
    //$tags = [];
    if (empty($tags)) {
        return null;
    }

    $tags_only = [];
    foreach ($tags as $k => $single_tag) {
        $tags_only[] = ucwords($single_tag);
    }
    return implode(',', $tags_only);
}
function plugin_screenshots_parsing($screenshots)
{
    //return $screenshots;
    if (empty($screenshots)) {
        return null;
    }

    $screenshots_parsed = [];

    // Loop and make sure each item is cast to object
    foreach ($screenshots as $v) {
        $screenshots_parsed[] = (object) $v; // cast array to object
    }

    return json_encode($screenshots_parsed);
}
function update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value)
{
    global $wpdb;
    $wpdb->update(
        $table_name,
        [
            $flag_name => $flag_value,
        ],
        [$where_name => $where_value]
    );
}

/**
 * ✅ Get existing term or create new one (exact match by slug)
 * @param string $name Term name from JSON
 * @param string $taxonomy Taxonomy name
 * @param array $args Additional arguments (parent, slug, etc.)
 * @return int|array|WP_Error Term ID or term array or WP_Error
 */
function wps_get_or_create_term($name, $taxonomy, $args = [])
{
    // First, check if term exists by exact slug (if provided)
    if (! empty($args['slug'])) {
        $existing = get_term_by('slug', $args['slug'], $taxonomy);
        if ($existing) {
            return ['term_id' => $existing->term_id];
        }
    }

    // Check by exact name
    $existing = term_exists($name, $taxonomy, $args['parent'] ?? 0);
    if ($existing) {
        return $existing;
    }

    // Create new term with exact name and slug from JSON
    return wp_insert_term($name, $taxonomy, $args);
}

/**
 * ✅ Normalize term names for fuzzy comparison
 * @param string $string String to normalize
 * @return string Normalized string
 */
function wps_normalize_string($string)
{
    $string = strtolower(trim($string));
    $string = str_replace(['-', '_', '&'], ' ', $string);
    $string = preg_replace('/\s+/', ' ', $string);

    // Remove common variations
    $string = str_replace(['and', 'the'], '', $string);
    $string = trim($string);

    // Remove trailing plural 's' (simple)
    if (substr($string, -1) === 's' && strlen($string) > 3) {
        $string = substr($string, 0, -1);
    }

    return $string;
}
/**
 * ✅ CRITICAL: Single slug generation function used by BOTH sync and AI lookup
 * This ensures slugs always match regardless of input format
 *
 * @param string $text Text to convert to slug
 * @return string URL-friendly slug
 */
function wps_create_slug($text)
{
    // Convert to lowercase
    $slug = strtolower(trim($text));

    // Replace special characters and spaces with hyphens
    $slug = str_replace(['&', '+', ' and ', ' ', '/', '\\', '|', ',', '.', ':', ';'], '-', $slug);

    // Remove any other special characters except hyphens and alphanumeric
    $slug = preg_replace('/[^a-z0-9\-]/', '', $slug);

    // Replace multiple consecutive hyphens with single hyphen
    $slug = preg_replace('/-+/', '-', $slug);

    // Remove leading/trailing hyphens
    $slug = trim($slug, '-');

    return $slug;
}

/**
 * Acquire job lock (auto key from calling file)
 *
 * @return bool
 */
function wp_job_lock($ttl = 2700)
{
    $option_key = wp_job_lock_key();
    $now        = time();

    // Structure: ['locked' => 0|1, 'time' => timestamp]
    $default = [
        'locked' => 0,
        'time'   => 0,
    ];

    // Create once if not exists
    add_option($option_key, $default, '', 'no');

    $lock = get_option($option_key, $default);

    // If locked AND not expired → deny
    if (
        ! empty($lock['locked']) &&
        ! empty($lock['time']) &&
        ($now - (int) $lock['time']) < $ttl
    ) {
        return false;
    }

    // Acquire / renew lock
    update_option(
        $option_key,
        [
            'locked' => 1,
            'time'   => $now,
        ],
        false
    );

    return true;
}

/**
 * Release job lock
 */
function wp_job_unlock()
{
    update_option(
        wp_job_lock_key(),
        [
            'locked' => 0,
            'time'   => 0,
        ],
        false
    );
}
/**
 * Generate lock key from caller file
 *
 * @return string
 */
function wp_job_lock_key()
{
    $trace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 3);

    /**
     * [0] wp_job_lock()
     * [1] caller (your class/method)
     * [2] actual file
     */
    $file = $trace[2]['file'] ?? __FILE__;

    $name = sanitize_key(basename($file, '.php'));

    return 'job_lock_' . $name;
}
