<?php
require_once(dirname(__FILE__) . '/index.php');

$category_json = file_get_contents(dirname(__FILE__) . '/possible_category.json');
$data = json_decode($category_json, true);

$category = [];

if (!empty($data['categories'])) {
    foreach ($data['categories'] as $single_category) {
        // Add main category name
        $category[] = $single_category['name'];

        // Add subcategory names if present
        if (!empty($single_category['subcategories'])) {
            foreach ($single_category['subcategories'] as $single_sub_category) {
                $category[] = $single_sub_category['name'];
            }
        }
    }
}

// Save as comma-separated string
update_option('pre_defined_ai_category', implode(',', $category), false);

echo "done";

update_option('pre_defined_ai_category_last_run', current_time('mysql'), false);