<?php
defined('ABSPATH') || exit;

do_action('woocommerce_before_account_orders', $has_orders);
?>

<?php if ($has_orders) : ?>

	<?php
	// Get all columns dynamically.
	$columns = wc_get_account_orders_columns();
	?>

	<!-- Header Row -->
	<div class="hidden md:flex justify-between text-sm text-(--theme-color) font-bold leading-[165%] border-y border-[#E0E0E0]">
		<?php foreach ($columns as $column_id => $column_name) : ?>
			<?php
			// Adjust width dynamically based on known columns (you can map your preferred widths)
			$widths = [
				'order-number' => 'md:w-[12.5%]',
				'order-date'   => 'md:w-[18.75%]',
				'order-status' => 'md:w-[18.75%]',
				'order-total'  => 'md:w-[37.5%]',
				'order-actions' => 'md:w-[12.5%]',
			];
			$width_class = isset($widths[$column_id]) ? $widths[$column_id] : 'flex-1';
			?>
			<div class="<?php echo esc_attr($width_class); ?> py-[17.5px] md:last:text-right">
				<?php echo esc_html($column_name); ?>
			</div>
		<?php endforeach; ?>
	</div>

	<div class="space-y-3 md:space-y-0">
		<?php foreach ($customer_orders->orders as $customer_order) :
			$order = wc_get_order($customer_order);
			$item_count = $order->get_item_count() - $order->get_item_count_refunded();
		?>
			<!-- Loop Start -->
			<div class="p-4 md:p-0 border border-[#EFEFEF] md:border-0 md:border-b md:border-[#E0E0E0] md:py-3 flex md:items-center flex-col md:flex-row justify-between text-sm text-(--theme-color) font-normal leading-[165%] woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr($order->get_status()); ?>">
				<?php foreach ($columns as $column_id => $column_name) : ?>
					<?php
					$is_order_number = ('order-number' === $column_id);
					$width_class = isset($widths[$column_id]) ? $widths[$column_id] : 'flex-1';
					?>
					<div class="<?php echo esc_attr($width_class); ?> w-full flex justify-between md:block border-b border-dashed border-[#EFEFEF] md:border-0 py-3 md:py-0 md:last:text-right">
						<span class="font-bold md:hidden"><?php echo esc_html($column_name) . ':'; ?></span>
						<span>
							<?php
							if (has_action('woocommerce_my_account_my_orders_column_' . $column_id)) {
								do_action('woocommerce_my_account_my_orders_column_' . $column_id, $order);
							} elseif ('order-number' === $column_id) {
								printf(
									'<a href="%s" aria-label="%s">#%s</a>',
									esc_url($order->get_view_order_url()),
									esc_attr(sprintf(__('Visa beställning #%s', 'woocommerce'), $order->get_order_number())),
									esc_html($order->get_order_number())
								);
							} elseif ('order-date' === $column_id) {
								echo esc_html(wc_format_datetime($order->get_date_created(), get_option('date_format')));
							} elseif ('order-status' === $column_id) {
								echo esc_html(wc_get_order_status_name($order->get_status()));
							} elseif ('order-total' === $column_id) {
								printf(
									esc_html(_n('%1$s för %2$d artikel', '%1$s för %2$d artiklar', $item_count, 'woocommerce')),
									wp_kses_post($order->get_formatted_order_total()),
									$item_count
								);
							} elseif ('order-actions' === $column_id) {
								$actions = wc_get_account_orders_actions($order);
								if (!empty($actions)) {
									foreach ($actions as $key => $action) { ?>
										<a href="<?php echo esc_url($action['url']); ?>" class="px-6 py-[5.5px] inline-block text-white bg-(--theme-dark) tracking-[18%%] border border-[#1C1C1C] duration-400 hover:opacity-65 uppercase <?php echo esc_attr($key); ?>">
											<?php echo esc_html($action['name']); ?>
										</a>
							<?php }
								}
							} else {
								// fallback for future WooCommerce columns
								echo esc_html($order->get_meta($column_id) ?: '-');
							}
							?>
						</span>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endforeach; ?>
	</div>

	<?php do_action('woocommerce_before_account_orders_pagination'); ?>

	<?php if (1 < $customer_orders->max_num_pages) : ?>
		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination mt-6 text-center">
			<?php if (1 !== $current_page) : ?>
				<a class="woocommerce-button woocommerce-button--previous button" href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page - 1)); ?>">
					<?php esc_html_e('Föregående', 'woocommerce'); ?>
				</a>
			<?php endif; ?>

			<?php if (intval($customer_orders->max_num_pages) !== $current_page) : ?>
				<a class="woocommerce-button woocommerce-button--next button" href="<?php echo esc_url(wc_get_endpoint_url('orders', $current_page + 1)); ?>">
					<?php esc_html_e('Nästa', 'woocommerce'); ?>
				</a>
			<?php endif; ?>
		</div>
	<?php endif; ?>

<?php else : ?>
	<?php
	wc_print_notice(
		sprintf(
			'%s <a class="woocommerce-Button wc-forward button" href="%s">%s</a>',
			esc_html__('Inga beställningar har gjorts ännu.', 'woocommerce'),
			esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))),
			esc_html__('Bläddra bland produkter', 'woocommerce')
		),
		'notice'
	);
	?>
<?php endif; ?>

<?php do_action('woocommerce_after_account_orders', $has_orders); ?>