<?php

/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined('ABSPATH') || exit;

$customer_id = get_current_user_id();

if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __('Billing address', 'woocommerce'),
			'shipping' => __('Shipping address', 'woocommerce'),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __('Billing address', 'woocommerce'),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>
<div class="address-wrapper space-y-5"> <!-- Parent wrapper for the entire content -->

	<div class="text-sm leading-[165%]">
		<?php echo apply_filters('woocommerce_my_account_my_address_description', esc_html__('Följande adresser kommer att användas på kassan som standard.', 'woocommerce')); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
		?>
	</div>

	<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
		<div class="u-columns woocommerce-Addresses col2-set addresses">
		<?php endif; ?>

		<?php foreach ($get_addresses as $name => $address_title) : ?>
			<?php
			$address = wc_get_account_formatted_address($name);
			$col     = $col * -1;
			$oldcol  = $oldcol * -1;
			?>

			<div class="space-y-5 u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> woocommerce-Address w-full md:w-[calc(50%-16px)]">
				<header class="woocommerce-Address-title title space-y-5">
					<div class="titleBorder relative flex items-center gap-6 space-x-6">
						<h2 class="uppercase leading-[140%] md:text-lg text-base tracking-[18%]">
							<?php echo esc_html($address_title); ?>
						</h2>
					</div>
					<a href="<?php echo esc_url(wc_get_endpoint_url('edit-address', $name)); ?>"
						class="edit cursor-pointer flex items-center text-sm leading-[165%] duration-400 hover:opacity-65 space-x-2">
						<img class="w-4 min-w-4 h-4 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/Edit.svg" alt="Edit">
						<span class="text-sm leading-[165%]">
							<?php
							printf(
								/* translators: %s: Address title */
								$address ? esc_html__('Edit %s', 'woocommerce') : esc_html__('Add %s', 'woocommerce'),
								esc_html($address_title)
							);
							?>
						</span>
					</a>
				</header>
				<address class="text-sm leading-[165%] not-italic bg-(--theme-white) p-4 md:p-8">
					<?php
					echo $address ? wp_kses_post($address) : esc_html_e('You have not set up this type of address yet.', 'woocommerce');

					/**
					 * Used to output content after core address fields.
					 *
					 * @param string $name Address type.
					 * @since 8.7.0
					 */
					do_action('woocommerce_my_account_after_my_address', $name);
					?>
				</address>
			</div>

		<?php endforeach; ?>

		<?php if (! wc_ship_to_billing_address_only() && wc_shipping_enabled()) : ?>
		</div> <!-- Close the .u-columns div -->
	<?php endif; ?>

</div> <!-- Close the parent wrapper div -->