<?php

/**
 * Lost password confirmation text.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/lost-password-confirmation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.9.0
 */

defined('ABSPATH') || exit;


?>
<section>
   <div class="flex flex-col lg:flex-row items-stretch lg:min-h-[768px]">
      <div class="w-full lg:w-[61.3%] px-4 py-8 md:p-12 flex items-center justify-center">
         <div class="max-w-[450px] mx-auto w-full space-y-6 md:space-y-9">

            <?php wc_print_notice(esc_html__('Password reset email has been sent.', 'woocommerce')); ?>
            <?php do_action('woocommerce_before_lost_password_confirmation_message'); ?>

            <div class="space-y-3 md:space-y-5 text-center ">
               <div class="text-sm leading-[165%]">
                  <?php echo esc_html(apply_filters('woocommerce_lost_password_confirmation_message', esc_html__('A password reset email has been sent to the email address on file for your account, but may take several minutes to show up in your inbox. Please wait at least 10 minutes before attempting another reset.', 'woocommerce'))); ?>
               </div>
            </div>

            <?php do_action('woocommerce_after_lost_password_confirmation_message'); ?>

         </div>
      </div>

      <!-- Include banner img -->
      <?php require get_template_directory() . '/inc/common-sections/login-register-banner-img.php'; ?>
   </div>
</section>