<?php

/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.9.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

?>

<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')): ?>
	<section>
		<div class="flex flex-col lg:flex-row items-stretch lg:min-h-[768px]">
			<div class="w-full lg:w-[61.3%] px-4 py-8 md:p-12 flex items-center justify-center">
				<div class="max-w-[450px] mx-auto w-full space-y-6 md:space-y-9">
					<?php do_action('woocommerce_before_customer_login_form'); ?>

					<div class="space-y-3 md:space-y-5 text-center ">
						<h1
							class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">

							<?php esc_html_e('LOGGA IN', 'woocommerce'); ?>
						</h1>
						<div class="text-sm leading-[165%]">
							<?php echo esc_html(__('Logga in för att hantera ditt konto och dina tjänster.', 'tusenrosor')); ?>
						</div>
					</div>

					<form
						class="w-full woocommerce-form woocommerce-form-login login space-y-4"
						method="post">
						<?php do_action('woocommerce_login_form_start'); ?>

						<div class="relative">
							<input
								class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg"
								type="text"
								placeholder="<?php esc_attr_e('E-post', 'woocommerce'); ?>"
								name="username"
								id="username"
								autocomplete="username"
								value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"
								required />
							<label
								for="username"
								class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
								<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M2.5 5.83332L10 9.99999L17.5 5.83332M2.5 4.16666H17.5V15.8333H2.5V4.16666Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
								</svg>
							</label>
						</div>
						<div class="relative">
							<input
								class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg"
								type="password"
								placeholder="<?php esc_attr_e('Lösenord', 'woocommerce'); ?>"
								name="password"
								id="password"
								autocomplete="current-password"
								required />
							<button
								id="togglePassword"
								class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">

								<svg class="eyeOpen" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M18.3307 9.99999C18.3307 9.99999 14.5998 15.8333 9.9974 15.8333C5.39502 15.8333 1.66406 9.99999 1.66406 9.99999C1.66406 9.99999 5.39502 4.16666 9.9974 4.16666C14.5998 4.16666 18.3307 9.99999 18.3307 9.99999Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
									<path d="M13.3307 9.99999C13.3307 11.8409 11.8383 13.3333 9.9974 13.3333C8.15645 13.3333 6.66406 11.8409 6.66406 9.99999C6.66406 8.15904 8.15645 6.66666 9.9974 6.66666C11.8383 6.66666 13.3307 8.15904 13.3307 9.99999Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
								</svg>

								<svg class="eyeClose hidden" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M1.66602 10C1.66602 10 5.39698 15.8333 9.99935 15.8333C11.6938 15.8333 13.2343 15.2372 14.5306 14.247" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
									<path d="M18.3327 10C18.3327 10 14.6017 4.16666 9.99935 4.16666C8.49577 4.16666 7.09489 4.56203 5.86893 5.263" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
									<path d="M7.5 9.16667C7.5 7.78996 8.62262 6.66667 10 6.66667C10.5455 6.66667 11.0536 6.84701 11.4574 7.16256" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
									<path d="M12.5 10.8333C12.5 12.21 11.3774 13.3333 10 13.3333C9.45452 13.3333 8.94643 13.153 8.54263 12.8375" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
									<path d="M3.33203 3.33333L16.6654 16.6667" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
								</svg>

							</button>

						</div>
						<div class="text-sm leading-[165%] flex items-center justify-between">
							<label
								class="flex items-center space-x-3 cursor-pointer"
								for="rememberme">
								<input class="tusenCheckbox"
									name="rememberme"
									type="checkbox"
									id="rememberme"
									value="forever" />
								<span class="duration-400 hover:opacity-65">
									<?php esc_html_e('Kom ihåg mig', 'woocommerce'); ?>
								</span>
							</label>
							<a class="duration-400 hover:opacity-65" href="<?php echo esc_url(wp_lostpassword_url()); ?>">
								<?php esc_html_e('Glömt ditt lösenord?', 'woocommerce'); ?>
							</a>
						</div>

						<?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
						<?php if (get_theme_option_data('google_key')) { ?>
							<div class="g-recaptcha" data-sitekey="<?php echo get_theme_option_data('google_key'); ?>">

							</div>
						<?php } ?>
						<button
							class="text-sm text-white bg-(--theme-dark) font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center cursor-pointer"
							type="submit"
							name="login"
							value="<?php esc_attr_e('Log in', 'woocommerce'); ?>">
							<?php esc_html_e('LOGGA IN', 'woocommerce'); ?>
						</button>

						<?php do_action('woocommerce_login_form'); ?>
						<?php do_action('woocommerce_login_form_end'); ?>
					</form>
					<div class="text-center text-sm leading-[165%]">
						<?php esc_html_e("Har du inget konto?", 'woocommerce'); ?>
						<a
							class="underline hover:opacity-65 duration-400"
							href="<?php echo esc_url(site_url('register')); ?>">
							<?php esc_html_e('Registrera dig', 'woocommerce'); ?>
						</a>
					</div>
				</div>
			</div>

			<!-- Include banner img -->
			<?php require get_template_directory() . '/inc/common-sections/login-register-banner-img.php'; ?>
		</div>
	</section>
<?php endif; ?>
<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')): ?>


<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>

<script>
	document.addEventListener('DOMContentLoaded', function() {
		const togglePassword = document.getElementById('togglePassword');
		const passwordInput = document.getElementById('password');

		togglePassword.addEventListener('click', function(e) {
			e.preventDefault();

			const isPassword = passwordInput.getAttribute('type') === 'password';
			passwordInput.setAttribute('type', isPassword ? 'text' : 'password');

			// Find both icons inside the button
			const eye = this.querySelector('.eyeClose');
			const eyeSlash = this.querySelector('.eyeOpen');

			if (isPassword) {
				eye.style.display = 'inline';
				eyeSlash.style.display = 'none';
			} else {
				eye.style.display = 'none';
				eyeSlash.style.display = 'inline';
			}
		});
	})
	jQuery(function($) {
		$('form.woocommerce-form-login').on('submit', function(e) {
			var response = grecaptcha.getResponse();
			if (!response) {

				alert("Vänligen bekräfta att du inte är en robot.");
				// Optional: e.preventDefault(); to enforce
				// e.preventDefault(); // Uncomment this line to actually block form submission
			}
		});
	});
</script>