<?php
defined('ABSPATH') || exit;

/** @var WC_Product $product */
global $product;
if (! $product || ! $product->is_visible()) {
    return;
}
//print_r($product);
$permalink      = $product->get_permalink();
$title          = $product->get_name();
$image_html     = $product->get_image('full', [
    'class' => 'productImg w-full h-full object-contain text-center flex items-center justify-center bg-[var(--theme-white)]',
    'alt'   => esc_attr($title),
]);

// Prices
$regular_price  = (float) $product->get_regular_price();
$sale_price     = (float) $product->get_sale_price();
$on_sale        = $product->is_on_sale() && $sale_price > 0 && $regular_price > $sale_price;

// Discount info
$save_amount  = $on_sale ? ($regular_price - $sale_price) : 0.0;

// Ratings
$average_rating = (int) $product->get_average_rating();
$review_count   = (int) $product->get_review_count();
$rating_html    = ($average_rating > 0 && $review_count > 0) ? wc_get_rating_html($average_rating) : '';
?>

<a href="<?php echo esc_url($permalink); ?>"
    class="group m-1.5 flex flex-col duration-400 w-[calc(50%-12px)] sm:w-[calc(33.3333%-12px)] lg:w-[calc(25%-12px)] lg:in-[#searchDrawer]:flex-col in-[#searchDrawer]:flex-row in-[#searchDrawer]:w-[calc(100%-12px)] lg:in-[#searchDrawer]:w-[calc(25%-12px)] in-[.favoritSection]:min-w-[150px] md:in-[.favoritSection]:min-w-[227.33px] lg:in-[.favoritSection]:min-w-[unset]
    in-[.scrollSlider]:min-w-[150px] md:in-[.scrollSlider]:min-w-[227.33px] 
    lg:in-[.scrollSlider]:min-w-[327px]">

    <div
        class="aspect-square overflow-hidden w-full relative z-9 in-[#searchDrawer]:min-w-20 in-[#searchDrawer]:max-w-20 md:in-[#searchDrawer]:max-w-[100px] md:in-[#searchDrawer]:min-w-[100px] lg:in-[#searchDrawer]:max-w-full lg:in-[#searchDrawer]:min-w-full">

        <?php if ($on_sale && $save_amount > 0) : ?>
            <div
                class="uppercase absolute top-2 left-2 bg-(--sub-text) text-white text-[10px] font-normal leading-[130%] px-[5px] py-[3px] z-10">
                <?php
                echo esc_html(__('SPARA', 'tusenrosor')) . ' ' . strip_tags(wc_price($save_amount));
                ?>
            </div>
        <?php endif; ?>

        <div
            class="translate-2 group-hover:translate-0 opacity-0 group-hover:opacity-100 hover:opacity-65 duration-400 h-8 w-8 md:h-12 md:w-12 flex items-center justify-center absolute bottom-2 right-2 bg-(--theme-dark) z-10">
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8 0V16M0 8H16" stroke="white" stroke-width="1.5" />
            </svg>
        </div>

        <?php echo $image_html; ?>
    </div>

    <div
        class="w-full p-2 pt-3 md:p-5 md:pb-3 text-center space-y-1 in-[#searchDrawer]:text-left lg:in-[#searchDrawer]:text-center in-[#searchDrawer]:p-1 in-[#searchDrawer]:pl-4.5 lg:in-[#searchDrawer]:p-2 lg:in-[#searchDrawer]:pt-3">

        <h3 class="productTitle line-clamp-1 text-xs font-normal leading-[165%]"
            title="<?php echo esc_attr($title); ?>">
            <?php echo esc_html($title); ?>
        </h3>

        <?php if ($review_count) : ?>
            <div
                class="flex items-center justify-center space-x-1 rtl:space-x-reverse lg:in-[#searchDrawer]:justify-center in-[#searchDrawer]:justify-start">
                <div class="flex items-center space-x-0.5 rtl:space-x-reverse">
                    <?php
                    for ($i = 1; $i <= 5; $i++) :

                        if ($i <= (int)$average_rating):
                    ?>
                            <svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 0V8.635L2.292 11L3.48 6.87L0 4.202L4.443 4.015L6 0ZM6 0V8.635L9.708 11L8.52 6.87L12 4.202L7.557 4.015L6 0Z" fill="#1C1C1C" />
                            </svg>
                        <?php else: ?>
                            <svg width="12" height="11" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M10.9091 1.23639L13.4979 7.15097L13.6061 7.39426L13.8713 7.40586L20.2735 7.68361L15.1493 11.6691L14.9369 11.8325L15.0103 12.0946L16.6687 18.0992L11.1005 14.5637L10.9091 14.4419L10.7178 14.5637L5.14958 18.0992L6.80799 12.0946L6.88136 11.8325L6.66895 11.6691L1.54478 7.68361L7.94699 7.40586L8.21215 7.39426L8.32033 7.15097L10.9091 1.23639Z"
                                    stroke="#303030"
                                    stroke-width="1.5"
                                    stroke-linejoin="round" />
                            </svg>
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>
                <span class="text-xs font-normal opacity-65">
                    (<?php echo esc_html($review_count); ?>)
                </span>
            </div>
        <?php endif; ?>

        <div
            class="flex items-center justify-center text-xs md:text-sm font-normal leading-[165%] space-x-2 rtl:space-x-reverse text-(--theme-color) opacity-65 lg:in-[#searchDrawer]:justify-center in-[#searchDrawer]:justify-start">
            <?php if ($on_sale) : ?>
                <div class="">
                    <?php echo wp_kses_post(wc_price($sale_price)); ?>
                </div>
                <div class="line-through">
                    <?php echo wp_kses_post(wc_price($regular_price)); ?>
                </div>
            <?php else : ?>
                <div class="">
                    <?php echo wp_kses_post(wc_price($product->get_price())); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</a>